/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.util.UUID;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.DataFrame;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u00015\u0011Q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019Y\u0002\u0003B\b\u0011%ii\u0011AA\u0005\u0003#\t\u0011qBU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\ta\u0001\\5oC2<'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBC\u0001\u0004WK\u000e$xN\u001d\t\u0003\u001f\u0001\u0001\"a\u0004\u000f\n\u0005u\u0011!A\u0006'j]\u0016\f'OU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\t\u0011}\u0001!Q1A\u0005B\u0001\n1!^5e+\u0005\t\u0003C\u0001\u0012)\u001d\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011F\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d\"\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\tULG\r\t\u0005\t]\u0001\u0011)\u0019!C\u0001_\u00059q/Z5hQR\u001cX#\u0001\n\t\u0011E\u0002!\u0011!Q\u0001\nI\t\u0001b^3jO\"$8\u000f\t\u0005\tg\u0001\u0011)\u0019!C\u0001i\u0005I\u0011N\u001c;fe\u000e,\u0007\u000f^\u000b\u0002kA\u00111EN\u0005\u0003o\u0011\u0012a\u0001R8vE2,\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u0015%tG/\u001a:dKB$\b\u0005\u0003\u0004<\u0001\u0011\u0005A\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\tiidh\u0010\u0005\u0006?i\u0002\r!\t\u0005\u0006]i\u0002\rA\u0005\u0005\u0006gi\u0002\r!\u000e\u0005\b\u0003\u0002\u0001\r\u0011\"\u0003C\u0003=!(/Y5oS:<7+^7nCJLX#A\"\u0011\u0007\r\"e)\u0003\u0002FI\t1q\n\u001d;j_:\u0004\"aD$\n\u0005!\u0013!a\b'j]\u0016\f'OU3he\u0016\u001c8/[8o)J\f\u0017N\\5oON+X.\\1ss\"9!\n\u0001a\u0001\n\u0013Y\u0015a\u0005;sC&t\u0017N\\4Tk6l\u0017M]=`I\u0015\fHC\u0001'P!\t\u0019S*\u0003\u0002OI\t!QK\\5u\u0011\u001d\u0001\u0016*!AA\u0002\r\u000b1\u0001\u001f\u00132\u0011\u0019\u0011\u0006\u0001)Q\u0005\u0007\u0006\u0001BO]1j]&twmU;n[\u0006\u0014\u0018\u0010\t\u0005\b)\u0002\u0011\r\u0011\"\u0011V\u0003-qW/\u001c$fCR,(/Z:\u0016\u0003Y\u0003\"aI,\n\u0005a##aA%oi\"1!\f\u0001Q\u0001\nY\u000bAB\\;n\r\u0016\fG/\u001e:fg\u0002BQ\u0001\u0018\u0001\u0005\u0002u\u000bqa];n[\u0006\u0014\u00180F\u0001G\u0011\u0019y\u0006\u0001\"\u0001\u0003A\u0006Q1/\u001a;Tk6l\u0017M]=\u0015\u0005\u0005\u0014W\"\u0001\u0001\t\u000bqs\u0006\u0019\u0001$\t\u000b\u0011\u0004A\u0011A3\u0002\u0015!\f7oU;n[\u0006\u0014\u00180F\u0001g!\t\u0019s-\u0003\u0002iI\t9!i\\8mK\u0006t\u0007B\u00026\u0001\t\u0003\u00111.\u0001\u0005fm\u0006dW/\u0019;f)\taw\u000e\u0005\u0002\u0010[&\u0011aN\u0001\u0002\u0018\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:\u001cV/\\7befDQ\u0001]5A\u0002E\fq\u0001Z1uCN,G\u000f\u0005\u0002sk6\t1O\u0003\u0002u\r\u0005\u00191/\u001d7\n\u0005Y\u001c(!\u0003#bi\u00064%/Y7f\u0011\u0019A\b\u0001\"\u0001\u0003s\u0006\u0001c-\u001b8e'VlW.\u0019:z\u001b>$W\r\\!oIB\u0013X\rZ5di&|gnQ8m)\u0005Q\b\u0003B\u0012|5\u0005J!\u0001 \u0013\u0003\rQ+\b\u000f\\33\u0011\u0015q\b\u0001\"\u0015\u0000\u0003\u001d\u0001(/\u001a3jGR$2!NA\u0001\u0011\u0019\t\u0019! a\u0001%\u0005Aa-Z1ukJ,7\u000fC\u0004\u0002\b\u0001!\t%!\u0003\u0002\t\r|\u0007/\u001f\u000b\u00045\u0005-\u0001\u0002CA\u0007\u0003\u000b\u0001\r!a\u0004\u0002\u000b\u0015DHO]1\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\u0005\u0003\u0015\u0001\u0018M]1n\u0013\u0011\tI\"a\u0005\u0003\u0011A\u000b'/Y7NCBD3\u0001AA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0012\u0011\u0005\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams {
    private final String uid;
    private final Vector weights;
    private final double intercept;
    private Option<LinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    private Option<LinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public LinearRegressionTrainingSummary summary() {
        Option<LinearRegressionTrainingSummary> option = this.trainingSummary();
        if (option instanceof Some) {
            LinearRegressionTrainingSummary summ;
            Some some = (Some)option;
            LinearRegressionTrainingSummary linearRegressionTrainingSummary = summ = (LinearRegressionTrainingSummary)some.x();
            return linearRegressionTrainingSummary;
        }
        None$ none$ = None$.MODULE$;
        Option<LinearRegressionTrainingSummary> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new SparkException("No training summary available for this LinearRegressionModel", (Throwable)new NullPointerException());
        }
        throw new MatchError(option);
    }

    public LinearRegressionModel setSummary(LinearRegressionTrainingSummary summary) {
        this.trainingSummary_$eq((Option<LinearRegressionTrainingSummary>)new Some((Object)summary));
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LinearRegressionSummary evaluate(DataFrame dataset) {
        Tuple2<LinearRegressionModel, String> tuple2 = this.findSummaryModelAndPredictionCol();
        if (tuple2 != null) {
            Tuple2 tuple22;
            LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
            String predictionColName = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
            LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
            String predictionColName2 = (String)tuple23._2();
            return new LinearRegressionSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()));
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<LinearRegressionModel, String> findSummaryModelAndPredictionCol() {
        Tuple2 tuple2;
        String string;
        String string2 = string = this.$(this.predictionCol());
        if (!("" != null ? !"".equals(string2) : string2 != null)) {
            String predictionColName = new StringBuilder().append((Object)"prediction_").append((Object)UUID.randomUUID().toString()).toString();
            tuple2 = new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(predictionColName), (Object)predictionColName);
        } else {
            tuple2 = new Tuple2((Object)this, (Object)string);
        }
        return tuple2;
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.weights()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        LinearRegressionModel newModel = this.copyValues(new LinearRegressionModel(this.uid(), this.weights(), this.intercept()), extra);
        Object object = this.trainingSummary().isDefined() ? newModel.setSummary((LinearRegressionTrainingSummary)this.trainingSummary().get()) : BoxedUnit.UNIT;
        return (LinearRegressionModel)newModel.setParent(this.parent());
    }

    public LinearRegressionModel(String uid, Vector weights2, double intercept) {
        this.uid = uid;
        this.weights = weights2;
        this.intercept = intercept;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = weights2.size();
    }
}

