/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.LeastSquaresCostFun;
import org.apache.spark.ml.regression.LinearRegression$;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u00015\u0011\u0001\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aBH\u0011\u0011\u000b=\u0001\"CG\u000e\u000e\u0003\tI!!\u0005\u0002\u0003\u0013I+wM]3tg>\u0014\bCA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0019a\u0017N\\1mO*\u0011qCB\u0001\u0006[2d\u0017NY\u0005\u00033Q\u0011aAV3di>\u0014\bCA\b\u0001!\tyA$\u0003\u0002\u001e\u0005\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\b \u0013\t\u0001#A\u0001\fMS:,\u0017M\u001d*fOJ,7o]5p]B\u000b'/Y7t!\t\u00113%D\u0001\u0007\u0013\t!cAA\u0004M_\u001e<\u0017N\\4\t\u0011\u0019\u0002!Q1A\u0005B\u001d\n1!^5e+\u0005A\u0003CA\u00150\u001d\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059Z\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\tULG\r\t\u0005\u0006k\u0001!\tAN\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005i9\u0004\"\u0002\u00145\u0001\u0004A\u0003\"B\u001b\u0001\t\u0003ID#\u0001\u000e\t\u000bm\u0002A\u0011\u0001\u001f\u0002\u0017M,GOU3h!\u0006\u0014\u0018-\u001c\u000b\u0003{yj\u0011\u0001\u0001\u0005\u0006\u007fi\u0002\r\u0001Q\u0001\u0006m\u0006dW/\u001a\t\u0003U\u0005K!AQ\u0016\u0003\r\u0011{WO\u00197f\u0011\u0015!\u0005\u0001\"\u0001F\u0003=\u0019X\r\u001e$ji&sG/\u001a:dKB$HCA\u001fG\u0011\u0015y4\t1\u0001H!\tQ\u0003*\u0003\u0002JW\t9!i\\8mK\u0006t\u0007\"B&\u0001\t\u0003a\u0015AE:fiN#\u0018M\u001c3be\u0012L'0\u0019;j_:$\"!P'\t\u000b}R\u0005\u0019A$\t\u000b=\u0003A\u0011\u0001)\u0002%M,G/\u00127bgRL7MT3u!\u0006\u0014\u0018-\u001c\u000b\u0003{ECQa\u0010(A\u0002\u0001CQa\u0015\u0001\u0005\u0002Q\u000b!b]3u\u001b\u0006D\u0018\n^3s)\tiT\u000bC\u0003@%\u0002\u0007a\u000b\u0005\u0002+/&\u0011\u0001l\u000b\u0002\u0004\u0013:$\b\"\u0002.\u0001\t\u0003Y\u0016AB:fiR{G\u000e\u0006\u0002>9\")q(\u0017a\u0001\u0001\")a\f\u0001C\u0001?\u0006a1/\u001a;XK&<\u0007\u000e^\"pYR\u0011Q\b\u0019\u0005\u0006\u007fu\u0003\r\u0001\u000b\u0005\u0006E\u0002!\taY\u0001\ng\u0016$8k\u001c7wKJ$\"!\u00103\t\u000b}\n\u0007\u0019\u0001\u0015\t\u000b\u0019\u0004A\u0011K4\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0005mA\u0007\"B5f\u0001\u0004Q\u0017a\u00023bi\u0006\u001cX\r\u001e\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u001a\t1a]9m\u0013\tyGNA\u0005ECR\fgI]1nK\")\u0011\u000f\u0001C!e\u0006!1m\u001c9z)\tQ2\u000fC\u0003ua\u0002\u0007Q/A\u0003fqR\u0014\u0018\r\u0005\u0002ws6\tqO\u0003\u0002y\t\u0005)\u0001/\u0019:b[&\u0011!p\u001e\u0002\t!\u0006\u0014\u0018-\\'ba\"\u0012\u0001\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}4\u0011AC1o]>$\u0018\r^5p]&\u0019\u00111\u0001@\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197")
public class LinearRegression
extends Regressor<Vector, LinearRegression, LinearRegressionModel>
implements LinearRegressionParams,
Logging {
    private final String uid;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearRegression setRegParam(double value) {
        return (LinearRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setFitIntercept(boolean value) {
        return (LinearRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setStandardization(boolean value) {
        return (LinearRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setElasticNetParam(double value) {
        return (LinearRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxIter(int value) {
        return (LinearRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setTol(double value) {
        return (LinearRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setWeightCol(String value) {
        return (LinearRegression)this.set(this.weightCol(), value);
    }

    public LinearRegression setSolver(String value) {
        return (LinearRegression)this.set(this.solver(), value);
    }

    @Override
    public LinearRegressionModel train(DataFrame dataset) {
        Column w2;
        int numFeatures;
        block14: {
            block13: {
                block12: {
                    numFeatures = BoxesRunTime.unboxToInt((Object)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).limit(1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Row x0$1) {
                            Object features;
                            Row row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (features = ((SeqLike)some.get()).apply(0)) instanceof Vector) {
                                Vector vector = (Vector)features;
                                int n = vector.size();
                                return n;
                            }
                            throw new MatchError((Object)row);
                        }
                    }, ClassTag$.MODULE$.Int()).first());
                    w2 = this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.col(this.$(this.weightCol()));
                    String string = this.$(this.solver());
                    String string2 = "auto";
                    if (string != null ? !string.equals(string2) : string2 != null) break block12;
                    if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 && numFeatures <= 4096) break block13;
                }
                String string = this.$(this.solver());
                String string3 = "normal";
                if (string != null ? !string.equals(string3) : string3 != null) break block14;
            }
            Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Only L2 regularization can be used when normal solver is used.'";
                }
            });
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w2, functions$.MODULE$.col(this.$(this.featuresCol()))})).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Instance apply(Row x0$2) {
                    Row row = x0$2;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                        Object label = ((SeqLike)some.get()).apply(0);
                        Object weight = ((SeqLike)some.get()).apply(1);
                        Object features = ((SeqLike)some.get()).apply(2);
                        if (label instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)label);
                            if (weight instanceof Double) {
                                double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                                if (features instanceof Vector) {
                                    Vector vector = (Vector)features;
                                    Instance instance = new Instance(d, d2, vector);
                                    return instance;
                                }
                            }
                        }
                    }
                    throw new MatchError((Object)row);
                }
            }, ClassTag$.MODULE$.apply(Instance.class));
            WeightedLeastSquares optimizer = new WeightedLeastSquares(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), true);
            WeightedLeastSquaresModel model = optimizer.fit((RDD<Instance>)instances);
            LinearRegressionModel lrModel = this.copyValues(new LinearRegressionModel(this.uid(), model.coefficients(), model.intercept()), this.copyValues$default$2());
            Tuple2<LinearRegressionModel, String> tuple2 = lrModel.findSummaryModelAndPredictionCol();
            if (tuple2 != null) {
                Tuple2 tuple22;
                LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
                String predictionColName = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
                String predictionColName2 = (String)tuple23._2();
                LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), new double[]{0.0});
                return lrModel.setSummary(trainingSummary);
            }
            throw new MatchError(tuple2);
        }
        RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w2, functions$.MODULE$.col(this.$(this.featuresCol()))})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Instance apply(Row x0$3) {
                Row row = x0$3;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object weight = ((SeqLike)some.get()).apply(1);
                    Object features = ((SeqLike)some.get()).apply(2);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (weight instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                Instance instance = new Instance(d, d2, vector);
                                return instance;
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Instance.class));
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        Tuple2 x$8 = new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultivariateOnlineSummarizer());
        Serializable seqOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> c, Instance instance) {
                return new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(instance.features(), instance.weight()), (Object)((MultivariateOnlineSummarizer)c._2()).add(Vectors$.MODULE$.dense(instance.label(), (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])), instance.weight()));
            }
        };
        Serializable x$9 = seqOp;
        Serializable combOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> c2) {
                return new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultivariateOnlineSummarizer)c1._2()).merge((MultivariateOnlineSummarizer)c2._2()));
            }
        };
        Serializable x$10 = combOp;
        int x$11 = instances.treeAggregate$default$4((Object)x$8);
        Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)x$8, (Function2)x$9, (Function2)x$10, x$11, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple24;
            MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultivariateOnlineSummarizer ySummarizer = (MultivariateOnlineSummarizer)tuple2._2();
            Tuple2 tuple25 = tuple24 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
            MultivariateOnlineSummarizer featuresSummarizer2 = (MultivariateOnlineSummarizer)tuple25._1();
            MultivariateOnlineSummarizer ySummarizer2 = (MultivariateOnlineSummarizer)tuple25._2();
            double yMean = ySummarizer2.mean().apply(0);
            double yStd = package$.MODULE$.sqrt(ySummarizer2.variance().apply(0));
            if (yStd == 0.0) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero, so the coefficients will be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zeros and the intercept will be the mean of the label; as a result, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                    }
                });
                Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                Vector coefficients = Vectors$.MODULE$.sparse(numFeatures, (Seq<Tuple2<Object, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                double intercept = yMean;
                LinearRegressionModel model = new LinearRegressionModel(this.uid(), coefficients, intercept);
                Tuple2<LinearRegressionModel, String> tuple26 = model.findSummaryModelAndPredictionCol();
                if (tuple26 != null) {
                    Tuple2 tuple27;
                    LinearRegressionModel summaryModel = (LinearRegressionModel)tuple26._1();
                    String predictionColName = (String)tuple26._2();
                    Tuple2 tuple28 = tuple27 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                    LinearRegressionModel summaryModel3 = (LinearRegressionModel)tuple28._1();
                    String predictionColName3 = (String)tuple28._2();
                    LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel3.transform(dataset), predictionColName3, this.$(this.labelCol()), this.$(this.featuresCol()), new double[]{0.0});
                    return this.copyValues(model.setSummary(trainingSummary), this.copyValues$default$2());
                }
                throw new MatchError(tuple26);
            }
            double[] featuresMean = featuresSummarizer2.mean().toArray();
            double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return package$.MODULE$.sqrt(x);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double effectiveRegParam = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) / yStd;
            double effectiveL1RegParam = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * effectiveRegParam;
            double effectiveL2RegParam = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * effectiveRegParam;
            LeastSquaresCostFun costFun = new LeastSquaresCostFun((RDD<Instance>)instances, yStd, yMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), featuresStd, featuresMean, effectiveL2RegParam);
            LBFGS optimizer = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || effectiveRegParam == 0.0 ? new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double())) : new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.effectiveL1RegFun$1(featuresStd, effectiveL1RegParam), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
            Vector initialCoefficients = Vectors$.MODULE$.zeros(numFeatures);
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialCoefficients.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            FirstOrderMinimizer.State state = null;
            while (states.hasNext()) {
                state = (FirstOrderMinimizer.State)states.next();
                arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
            }
            if (state == null) {
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                this.logError((Function0<String>)new $anonfun$9(this, msg));
                throw new SparkException(msg);
            }
            double[] rawCoefficients = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
            int len = rawCoefficients.length;
            for (int i = 0; i < len; ++i) {
                int n = i;
                rawCoefficients[n] = rawCoefficients[n] * (featuresStd[i] != 0.0 ? yStd / featuresStd[i] : 0.0);
            }
            Tuple2 tuple29 = new Tuple2((Object)Vectors$.MODULE$.dense(rawCoefficients).compressed(), arrayBuilder.result());
            if (tuple29 != null) {
                Tuple2 tuple210;
                Vector coefficients = (Vector)tuple29._1();
                double[] objectiveHistory = (double[])tuple29._2();
                Tuple2 tuple211 = tuple210 = new Tuple2((Object)coefficients, (Object)objectiveHistory);
                Vector coefficients2 = (Vector)tuple211._1();
                double[] objectiveHistory2 = (double[])tuple211._2();
                double intercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? yMean - BLAS$.MODULE$.dot(coefficients2, Vectors$.MODULE$.dense(featuresMean)) : 0.0;
                Object object3 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                LinearRegressionModel model = this.copyValues(new LinearRegressionModel(this.uid(), coefficients2, intercept), this.copyValues$default$2());
                Tuple2<LinearRegressionModel, String> tuple212 = model.findSummaryModelAndPredictionCol();
                if (tuple212 != null) {
                    Tuple2 tuple213;
                    LinearRegressionModel summaryModel = (LinearRegressionModel)tuple212._1();
                    String predictionColName = (String)tuple212._2();
                    Tuple2 tuple214 = tuple213 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                    LinearRegressionModel summaryModel4 = (LinearRegressionModel)tuple214._1();
                    String predictionColName4 = (String)tuple214._2();
                    LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel4.transform(dataset), predictionColName4, this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory2);
                    return model.setSummary(trainingSummary);
                }
                throw new MatchError(tuple212);
            }
            throw new MatchError((Object)tuple29);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public LinearRegression copy(ParamMap extra) {
        return (LinearRegression)this.defaultCopy(extra);
    }

    private final Function1 effectiveL1RegFun$1(double[] featuresStd$1, double effectiveL1RegParam$1) {
        return new Serializable(this, featuresStd$1, effectiveL1RegParam$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegression $outer;
            private final double[] featuresStd$1;
            private final double effectiveL1RegParam$1;

            public final double apply(int index2) {
                return this.apply$mcDI$sp(index2);
            }

            public double apply$mcDI$sp(int index2) {
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.standardization())) ? this.effectiveL1RegParam$1 : (this.featuresStd$1[index2] != 0.0 ? this.effectiveL1RegParam$1 / this.featuresStd$1[index2] : 0.0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.featuresStd$1 = featuresStd$1;
                this.effectiveL1RegParam$1 = effectiveL1RegParam$1;
            }
        };
    }

    public LinearRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.weightCol().$minus$greater("")}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.solver().$minus$greater("auto")}));
    }

    public LinearRegression() {
        this(Identifiable$.MODULE$.randomUID("linReg"));
    }
}

