/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasStepSize$class;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.regression.GBTRegressor$;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTParams$class;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.TreeRegressorParams$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.AbsoluteError$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.loss.SquaredError$;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u00055\u0011Ab\u0012\"U%\u0016<'/Z:t_JT!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f?\u0015B\u0003#B\b\u0011%iaR\"\u0001\u0003\n\u0005E!!!\u0003)sK\u0012L7\r^8s!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0004mS:\fGn\u001a\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003\rY+7\r^8s!\tY\u0002!D\u0001\u0003!\tYR$\u0003\u0002\u001f\u0005\t\u0011rI\u0011+SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0003ue\u0016,\u0017B\u0001\u0013\"\u0005%9%\t\u0016)be\u0006l7\u000f\u0005\u0002!M%\u0011q%\t\u0002\u0014)J,WMU3he\u0016\u001c8o\u001c:QCJ\fWn\u001d\t\u0003S)j\u0011AB\u0005\u0003W\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0011/\u0003\r)\u0018\u000eZ\u000b\u0002_A\u0011\u0001G\u000e\b\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QGM\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026e!A!\b\u0001B\u0001B\u0003%q&\u0001\u0003vS\u0012\u0004\u0003\"\u0002\u001f\u0001\t\u0003i\u0014A\u0002\u001fj]&$h\b\u0006\u0002\u001b}!)Qf\u000fa\u0001_!)A\b\u0001C\u0001\u0001R\t!\u0004C\u0003C\u0001\u0011\u00053)A\u0006tKRl\u0015\r\u001f#faRDGC\u0001#F\u001b\u0005\u0001\u0001\"\u0002$B\u0001\u00049\u0015!\u0002<bYV,\u0007CA\u0019I\u0013\tI%GA\u0002J]RDQa\u0013\u0001\u0005B1\u000b!b]3u\u001b\u0006D()\u001b8t)\t!U\nC\u0003G\u0015\u0002\u0007q\tC\u0003P\u0001\u0011\u0005\u0003+\u0001\ftKRl\u0015N\\%ogR\fgnY3t!\u0016\u0014hj\u001c3f)\t!\u0015\u000bC\u0003G\u001d\u0002\u0007q\tC\u0003T\u0001\u0011\u0005C+\u0001\btKRl\u0015N\\%oM><\u0015-\u001b8\u0015\u0005\u0011+\u0006\"\u0002$S\u0001\u00041\u0006CA\u0019X\u0013\tA&G\u0001\u0004E_V\u0014G.\u001a\u0005\u00065\u0002!\teW\u0001\u0011g\u0016$X*\u0019=NK6|'/_%o\u001b\n#\"\u0001\u0012/\t\u000b\u0019K\u0006\u0019A$\t\u000by\u0003A\u0011I0\u0002\u001fM,GoQ1dQ\u0016tu\u000eZ3JIN$\"\u0001\u00121\t\u000b\u0019k\u0006\u0019A1\u0011\u0005E\u0012\u0017BA23\u0005\u001d\u0011un\u001c7fC:DQ!\u001a\u0001\u0005B\u0019\fQc]3u\u0007\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0006\u0002EO\")a\t\u001aa\u0001\u000f\")\u0011\u000e\u0001C!U\u0006Y1/\u001a;J[B,(/\u001b;z)\t!5\u000eC\u0003GQ\u0002\u0007q\u0006C\u0003n\u0001\u0011\u0005c.\u0001\ntKR\u001cVOY:b[Bd\u0017N\\4SCR,GC\u0001#p\u0011\u00151E\u000e1\u0001W\u0011\u0015\t\b\u0001\"\u0011s\u0003\u001d\u0019X\r^*fK\u0012$\"\u0001R:\t\u000b\u0019\u0003\b\u0019\u0001;\u0011\u0005E*\u0018B\u0001<3\u0005\u0011auN\\4\t\u000ba\u0004A\u0011I=\u0002\u0015M,G/T1y\u0013R,'\u000f\u0006\u0002Eu\")ai\u001ea\u0001\u000f\")A\u0010\u0001C!{\u0006Y1/\u001a;Ti\u0016\u00048+\u001b>f)\t!e\u0010C\u0003Gw\u0002\u0007a\u000bC\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004\u0005AAn\\:t)f\u0004X-\u0006\u0002\u0002\u0006A)\u0011qAA\u0007_5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017!\u0011!\u00029be\u0006l\u0017\u0002BA\b\u0003\u0013\u0011Q\u0001U1sC6D\u0001\"a\u0005\u0001A\u0003%\u0011QA\u0001\nY>\u001c8\u000fV=qK\u0002Bq!a\u0006\u0001\t\u0003\tI\"A\u0006tKRdun]:UsB,Gc\u0001#\u0002\u001c!1a)!\u0006A\u0002=Ba!a\b\u0001\t\u0003q\u0013aC4fi2{7o\u001d+za\u0016D\u0001\"a\t\u0001\t\u0003\"\u0011QE\u0001\u000fO\u0016$x\n\u001c3M_N\u001cH+\u001f9f+\t\t9\u0003\u0005\u0003\u0002*\u0005ERBAA\u0016\u0015\u0011\ti#a\f\u0002\t1|7o\u001d\u0006\u0003EYIA!a\r\u0002,\t!Aj\\:t\u0011\u001d\t9\u0004\u0001C)\u0003s\tQ\u0001\u001e:bS:$2\u0001HA\u001e\u0011!\ti$!\u000eA\u0002\u0005}\u0012a\u00023bi\u0006\u001cX\r\u001e\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0004\u0002\u0007M\fH.\u0003\u0003\u0002J\u0005\r#!\u0003#bi\u00064%/Y7f\u0011\u001d\ti\u0005\u0001C!\u0003\u001f\nAaY8qsR\u0019!$!\u0015\t\u0011\u0005M\u00131\na\u0001\u0003+\nQ!\u001a=ue\u0006\u0004B!a\u0002\u0002X%!\u0011\u0011LA\u0005\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\u0001\u0002^A!\u0011qLA3\u001b\t\t\tGC\u0002\u0002d\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9'!\u0019\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u000f\u0005-$\u0001#\u0001\u0002n\u0005aqI\u0011+SK\u001e\u0014Xm]:peB\u00191$a\u001c\u0007\r\u0005\u0011\u0001\u0012AA9'\u0019\ty'a\u001d\u0002zA\u0019\u0011'!\u001e\n\u0007\u0005]$G\u0001\u0004B]f\u0014VM\u001a\t\u0004c\u0005m\u0014bAA?e\ta1+\u001a:jC2L'0\u00192mK\"9A(a\u001c\u0005\u0002\u0005\u0005ECAA7\u0011)\t))a\u001cC\u0002\u0013\u0015\u0011qQ\u0001\u0013gV\u0004\bo\u001c:uK\u0012dun]:UsB,7/\u0006\u0002\u0002\nB!\u0011'a#0\u0013\r\tiI\r\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\n\u0003#\u000by\u0007)A\u0007\u0003\u0013\u000b1c];qa>\u0014H/\u001a3M_N\u001cH+\u001f9fg\u0002B!\"!&\u0002p\u0005\u0005I\u0011BAL\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005e\u0005\u0003BAN\u0003Kk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\u0005Y\u0006twM\u0003\u0002\u0002$\u0006!!.\u0019<b\u0013\u0011\t9+!(\u0003\r=\u0013'.Z2uQ\u0011\ty'!\u0018)\t\u0005%\u0014Q\f")
public final class GBTRegressor
extends Predictor<Vector, GBTRegressor, GBTRegressionModel>
implements GBTParams,
TreeRegressorParams,
Logging {
    private final String uid;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final LongParam seed;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final IntParam checkpointInterval;

    public static String[] supportedLossTypes() {
        return GBTRegressor$.MODULE$.supportedLossTypes();
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams$class.getOldImpurity(this);
    }

    public Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public void validateParams() {
        GBTParams$class.validateParams(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final double getStepSize() {
        return HasStepSize$class.getStepSize(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    public Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GBTRegressor setMaxDepth(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public GBTRegressor setMaxBins(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public GBTRegressor setMinInstancesPerNode(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public GBTRegressor setMinInfoGain(double value) {
        return (GBTRegressor)DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public GBTRegressor setMaxMemoryInMB(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public GBTRegressor setCacheNodeIds(boolean value) {
        return (GBTRegressor)DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public GBTRegressor setCheckpointInterval(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public GBTRegressor setImpurity(String value) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "GBTRegressor.setImpurity should NOT be used";
            }
        });
        return this;
    }

    @Override
    public GBTRegressor setSubsamplingRate(double value) {
        return (GBTRegressor)TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public GBTRegressor setSeed(long value) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The 'seed' parameter is currently ignored by Gradient Boosting.";
            }
        });
        return (GBTRegressor)TreeEnsembleParams$class.setSeed(this, value);
    }

    @Override
    public GBTRegressor setMaxIter(int value) {
        return (GBTRegressor)GBTParams$class.setMaxIter(this, value);
    }

    @Override
    public GBTRegressor setStepSize(double value) {
        return (GBTRegressor)GBTParams$class.setStepSize(this, value);
    }

    public Param<String> lossType() {
        return this.lossType;
    }

    public GBTRegressor setLossType(String value) {
        return (GBTRegressor)this.set(this.lossType(), value);
    }

    public String getLossType() {
        return this.$(this.lossType()).toLowerCase();
    }

    @Override
    public Loss getOldLossType() {
        block4: {
            Loss loss2;
            block3: {
                String string;
                block2: {
                    String string2 = string = this.getLossType();
                    if ("squared" != null ? !"squared".equals(string2) : string2 != null) break block2;
                    loss2 = SquaredError$.MODULE$;
                    break block3;
                }
                String string3 = string;
                if ("absolute" != null ? !"absolute".equals(string3) : string3 != null) break block4;
                loss2 = AbsoluteError$.MODULE$;
            }
            return loss2;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTRegressorParams was given bad loss type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getLossType()})));
    }

    @Override
    public GBTRegressionModel train(DataFrame dataset) {
        Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
        RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
        int numFeatures = ((LabeledPoint)oldDataset.first()).features().size();
        BoostingStrategy boostingStrategy = GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, Algo$.MODULE$.Regression());
        GradientBoostedTrees oldGBT = new GradientBoostedTrees(boostingStrategy);
        GradientBoostedTreesModel oldModel = oldGBT.run(oldDataset);
        return GBTRegressionModel$.MODULE$.fromOld(oldModel, this, categoricalFeatures, numFeatures);
    }

    @Override
    public GBTRegressor copy(ParamMap extra) {
        return (GBTRegressor)this.defaultCopy(extra);
    }

    public GBTRegressor(String uid) {
        this.uid = uid;
        HasCheckpointInterval$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        HasSeed$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasStepSize$class.$init$(this);
        GBTParams$class.$init$(this);
        TreeRegressorParams$class.$init$(this);
        this.lossType = new Param(this, "lossType", new StringBuilder().append((Object)"Loss function which GBT tries to minimize (case-insensitive). Supported options:").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])GBTRegressor$.MODULE$.supportedLossTypes()).mkString(", ")}))).toString(), new $anonfun$1(this));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.lossType().$minus$greater("squared")}));
    }

    public GBTRegressor() {
        this(Identifiable$.MODULE$.randomUID("gbtr"));
    }
}

