/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams$class;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u00015\u0011!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2T!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0019q\u0002\u0005\n\u000e\u0003\u0011I!!\u0005\u0003\u0003\u000b5{G-\u001a7\u0011\u0005M\u0001Q\"\u0001\u0002\u0011\u0005M)\u0012B\u0001\f\u0003\u0005m\te\tV*veZLg/\u00197SK\u001e\u0014Xm]:j_:\u0004\u0016M]1ng\"A\u0001\u0004\u0001BC\u0002\u0013\u0005\u0013$A\u0002vS\u0012,\u0012A\u0007\t\u00037\u0005r!\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0012$\u0005\u0019\u0019FO]5oO*\u0011\u0001%\b\u0015\u0004/\u0015Z\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003U\u001d\u0012QaU5oG\u0016\f\u0013\u0001L\u0001\u0006c92d\u0006\r\u0005\t]\u0001\u0011\t\u0011)A\u00055\u0005!Q/\u001b3!Q\riSe\u000b\u0005\tc\u0001\u0011)\u0019!C\u0001e\u0005a1m\\3gM&\u001c\u0017.\u001a8ugV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u00051A.\u001b8bY\u001eT!\u0001\u000f\u0004\u0002\u000b5dG.\u001b2\n\u0005i*$A\u0002,fGR|'\u000fK\u00021K-B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IaM\u0001\u000eG>,gMZ5dS\u0016tGo\u001d\u0011)\u0007q*3\u0006\u0003\u0005A\u0001\t\u0015\r\u0011\"\u0001B\u0003%Ig\u000e^3sG\u0016\u0004H/F\u0001C!\ta2)\u0003\u0002E;\t1Ai\\;cY\u0016D3aP\u0013,\u0011!9\u0005A!A!\u0002\u0013\u0011\u0015AC5oi\u0016\u00148-\u001a9uA!\u001aa)J\u0016\t\u0011)\u0003!Q1A\u0005\u0002\u0005\u000bQa]2bY\u0016D3!S\u0013,\u0011!i\u0005A!A!\u0002\u0013\u0011\u0015AB:dC2,\u0007\u0005K\u0002MK-Ba\u0001\u0015\u0001\u0005\u0002\u0011\t\u0016A\u0002\u001fj]&$h\bF\u0003\u0013%R3\u0006\fC\u0003\u0019\u001f\u0002\u0007!\u0004K\u0002SK-BQ!M(A\u0002MB3\u0001V\u0013,\u0011\u0015\u0001u\n1\u0001CQ\r1Ve\u000b\u0005\u0006\u0015>\u0003\rA\u0011\u0015\u00041\u0016Z\u0003\"B.\u0001\t\u0003a\u0016AD:fi\u001a+\u0017\r^;sKN\u001cu\u000e\u001c\u000b\u0003;zk\u0011\u0001\u0001\u0005\u0006?j\u0003\rAG\u0001\u0006m\u0006dW/\u001a\u0015\u00045\u0016Z\u0003\"\u00022\u0001\t\u0003\u0019\u0017\u0001E:fiB\u0013X\rZ5di&|gnQ8m)\tiF\rC\u0003`C\u0002\u0007!\u0004K\u0002bK-BQa\u001a\u0001\u0005\u0002!\f\u0001d]3u#V\fg\u000e^5mKB\u0013xNY1cS2LG/[3t)\ti\u0016\u000eC\u0003`M\u0002\u0007!\u000eE\u0002\u001dW\nK!\u0001\\\u000f\u0003\u000b\u0005\u0013(/Y=)\u0007\u0019,3\u0006C\u0003p\u0001\u0011\u0005\u0001/A\btKR\fV/\u00198uS2,7oQ8m)\ti\u0016\u000fC\u0003`]\u0002\u0007!\u0004K\u0002oK-BQ\u0001\u001e\u0001\u0005\u0002U\f\u0001\u0003\u001d:fI&\u001cG/U;b]RLG.Z:\u0015\u0005M2\b\"B<t\u0001\u0004\u0019\u0014\u0001\u00034fCR,(/Z:)\u0007M,3\u0006C\u0003{\u0001\u0011\u000510A\u0004qe\u0016$\u0017n\u0019;\u0015\u0005\tc\b\"B<z\u0001\u0004\u0019\u0004fA=&W!1q\u0010\u0001C!\u0003\u0003\t\u0011\u0002\u001e:b]N4wN]7\u0015\t\u0005\r\u0011q\u0002\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0004\u0002\u0007M\fH.\u0003\u0003\u0002\u000e\u0005\u001d!!\u0003#bi\u00064%/Y7f\u0011\u001d\t\tB a\u0001\u0003\u0007\tq\u0001Z1uCN,G\u000fK\u0002\u007fK-Bq!a\u0006\u0001\t\u0003\nI\"A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\tY\"a\n\u0011\t\u0005u\u00111E\u0007\u0003\u0003?QA!!\t\u0002\b\u0005)A/\u001f9fg&!\u0011QEA\u0010\u0005)\u0019FO];diRK\b/\u001a\u0005\t\u0003S\t)\u00021\u0001\u0002\u001c\u000511o\u00195f[\u0006DC!!\u0006&W!9\u0011q\u0006\u0001\u0005B\u0005E\u0012\u0001B2paf$2AEA\u001a\u0011!\t)$!\fA\u0002\u0005]\u0012!B3yiJ\f\u0007\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005uB!A\u0003qCJ\fW.\u0003\u0003\u0002B\u0005m\"\u0001\u0003)be\u0006lW*\u00199)\t\u00055Re\u000b\u0015\u0004\u0001\u0015Z\u0003f\u0001\u0001\u0002JA\u0019a%a\u0013\n\u0007\u00055sE\u0001\u0007FqB,'/[7f]R\fG\u000e")
public class AFTSurvivalRegressionModel
extends Model<AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final Param<String> predictionCol;
    private final Param<String> labelCol;
    private final Param<String> featuresCol;

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams$class.getCensorCol(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams$class.getQuantileProbabilities(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams$class.getQuantilesCol(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams$class.hasQuantilesCol(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams$class.validateAndTransformSchema(this, schema, fitting);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    public AFTSurvivalRegressionModel setFeaturesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.featuresCol(), value);
    }

    public AFTSurvivalRegressionModel setPredictionCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.predictionCol(), value);
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
        double k = 1.0 / this.scale();
        double[] quantiles = (double[])Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities())).map((Function1)new Serializable(this, lambda, k){
            public static final long serialVersionUID = 0L;
            private final double lambda$1;
            private final double k$1;

            public final double apply(double q) {
                return this.apply$mcDD$sp(q);
            }

            public double apply$mcDD$sp(double q) {
                return this.lambda$1 * scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log(1.0 - q)) / this.k$1);
            }
            {
                this.lambda$1 = lambda$1;
                this.k$1 = k$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return Vectors$.MODULE$.dense(quantiles);
    }

    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        this.transformSchema(dataset.schema());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionModel $outer;

            public final double apply(Vector features) {
                return this.$outer.predict(features);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(this)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictQuantilesUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionModel $outer;

            public final Vector apply(Vector features) {
                return this.$outer.predictQuantiles(features);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(this)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(this)));
        return this.hasQuantilesCol() ? dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))).withColumn(this.$(this.quantilesCol()), predictQuantilesUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))) : dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, false);
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasFeaturesCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        AFTSurvivalRegressionParams$class.$init$(this);
    }
}

