/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.storage.Zero;
import org.apache.spark.ml.regression.AFTPoint;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0005\u001b\ti\u0011I\u0012+BO\u001e\u0014XmZ1u_JT!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"aD\u000b\n\u0005Y\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u000f],\u0017n\u001a5ugB\u0019!dH\u0011\u000e\u0003mQ!\u0001H\u000f\u0002\r1Lg.\u00197h\u0015\u0005q\u0012A\u00022sK\u0016TX-\u0003\u0002!7\tYA)\u001a8tKZ+7\r^8s!\ty!%\u0003\u0002$!\t1Ai\\;cY\u0016D\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\rM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\t\u0003\u001f\u001dJ!\u0001\u000b\t\u0003\u000f\t{w\u000e\\3b]\")!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"2\u0001\f\u00180!\ti\u0003!D\u0001\u0003\u0011\u0015A\u0012\u00061\u0001\u001a\u0011\u0015)\u0013\u00061\u0001'\u0011\u001d\t\u0004A1A\u0005\nI\nAAY3uCV\t\u0011\u0004\u0003\u00045\u0001\u0001\u0006I!G\u0001\u0006E\u0016$\u0018\r\t\u0005\bm\u0001\u0011\r\u0011\"\u00038\u0003\u0015\u0019\u0018nZ7b+\u0005\t\u0003BB\u001d\u0001A\u0003%\u0011%\u0001\u0004tS\u001el\u0017\r\t\u0005\bw\u0001\u0001\r\u0011\"\u0003=\u0003!!x\u000e^1m\u0007:$X#A\u001f\u0011\u0005=q\u0014BA \u0011\u0005\u0011auN\\4\t\u000f\u0005\u0003\u0001\u0019!C\u0005\u0005\u0006aAo\u001c;bY\u000esGo\u0018\u0013fcR\u00111I\u0012\t\u0003\u001f\u0011K!!\u0012\t\u0003\tUs\u0017\u000e\u001e\u0005\b\u000f\u0002\u000b\t\u00111\u0001>\u0003\rAH%\r\u0005\u0007\u0013\u0002\u0001\u000b\u0015B\u001f\u0002\u0013Q|G/\u00197D]R\u0004\u0003bB&\u0001\u0001\u0004%IaN\u0001\bY>\u001c8oU;n\u0011\u001di\u0005\u00011A\u0005\n9\u000b1\u0002\\8tgN+Xn\u0018\u0013fcR\u00111i\u0014\u0005\b\u000f2\u000b\t\u00111\u0001\"\u0011\u0019\t\u0006\u0001)Q\u0005C\u0005AAn\\:t'Vl\u0007\u0005C\u0004T\u0001\u0001\u0007I\u0011\u0002\u001a\u0002\u001f\u001d\u0014\u0018\rZ5f]R\u0014U\r^1Tk6Dq!\u0016\u0001A\u0002\u0013%a+A\nhe\u0006$\u0017.\u001a8u\u0005\u0016$\u0018mU;n?\u0012*\u0017\u000f\u0006\u0002D/\"9q\tVA\u0001\u0002\u0004I\u0002BB-\u0001A\u0003&\u0011$\u0001\the\u0006$\u0017.\u001a8u\u0005\u0016$\u0018mU;nA!91\f\u0001a\u0001\n\u00139\u0014aE4sC\u0012LWM\u001c;M_\u001e\u001c\u0016nZ7b'Vl\u0007bB/\u0001\u0001\u0004%IAX\u0001\u0018OJ\fG-[3oi2{wmU5h[\u0006\u001cV/\\0%KF$\"aQ0\t\u000f\u001dc\u0016\u0011!a\u0001C!1\u0011\r\u0001Q!\n\u0005\nAc\u001a:bI&,g\u000e\u001e'pONKw-\\1Tk6\u0004\u0003\"B2\u0001\t\u0003a\u0014!B2pk:$\b\"B3\u0001\t\u00039\u0014\u0001\u00027pgNDQa\u001a\u0001\u0005\u0002I\n\u0001b\u001a:bI&,g\u000e\u001e\u0005\u0006S\u0002!\tA[\u0001\u0004C\u0012$GCA6m\u001b\u0005\u0001\u0001\"B7i\u0001\u0004q\u0017\u0001\u00023bi\u0006\u0004\"!L8\n\u0005A\u0014!\u0001C!G)B{\u0017N\u001c;\t\u000bI\u0004A\u0011A:\u0002\u000b5,'oZ3\u0015\u0005-$\b\"B;r\u0001\u0004a\u0013!B8uQ\u0016\u0014\b")
public class AFTAggregator
implements Serializable {
    private final boolean fitIntercept;
    private final DenseVector<Object> beta;
    private final double sigma;
    private long totalCnt;
    private double lossSum;
    private DenseVector<Object> gradientBetaSum;
    private double gradientLogSigmaSum;

    private DenseVector<Object> beta() {
        return this.beta;
    }

    private double sigma() {
        return this.sigma;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double lossSum() {
        return this.lossSum;
    }

    private void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private DenseVector<Object> gradientBetaSum() {
        return this.gradientBetaSum;
    }

    private void gradientBetaSum_$eq(DenseVector<Object> x$1) {
        this.gradientBetaSum = x$1;
    }

    private double gradientLogSigmaSum() {
        return this.gradientLogSigmaSum;
    }

    private void gradientLogSigmaSum_$eq(double x$1) {
        this.gradientLogSigmaSum = x$1;
    }

    public long count() {
        return this.totalCnt();
    }

    public double loss() {
        return this.totalCnt() == 0L ? 1.0 : this.lossSum() / (double)this.totalCnt();
    }

    public DenseVector<Object> gradient() {
        return DenseVector$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DenseVector[]{DenseVector$.MODULE$.apply$mDc$sp(new double[]{this.gradientLogSigmaSum() / (double)this.totalCnt()}), (DenseVector)this.gradientBetaSum().$div((Object)BoxesRunTime.boxToDouble((double)this.totalCnt()), DenseVector$.MODULE$.dv_s_Op_Double_OpDiv())}), DenseVector$.MODULE$.canSetD(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    public AFTAggregator add(AFTPoint data) {
        Vector<Object> xi = this.fitIntercept ? Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(new double[]{1.0}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(data.features().toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toBreeze() : Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.0}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(data.features().toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toBreeze();
        double ti = data.label();
        double delta = data.censor();
        double epsilon = (package$.MODULE$.log(ti) - BoxesRunTime.unboxToDouble((Object)this.beta().dot(xi, DenseVector$.MODULE$.canDot_DV_V_Double()))) / this.sigma();
        this.lossSum_$eq(this.lossSum() + package$.MODULE$.log(this.sigma()) * delta);
        this.lossSum_$eq(this.lossSum() + (package$.MODULE$.exp(epsilon) - delta * epsilon));
        Predef$.MODULE$.assert(!RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(this.lossSum())), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AFTAggregator loss sum is infinity. Error for unknown reason."})).s((Seq)Nil$.MODULE$);
            }
        });
        this.gradientBetaSum().$plus$eq(((ImmutableNumericOps)xi.$times((Object)BoxesRunTime.boxToDouble((double)(delta - package$.MODULE$.exp(epsilon))), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())).$div((Object)BoxesRunTime.boxToDouble((double)this.sigma()), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv()), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
        this.gradientLogSigmaSum_$eq(this.gradientLogSigmaSum() + (delta + (delta - package$.MODULE$.exp(epsilon)) * epsilon));
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public AFTAggregator merge(AFTAggregator other) {
        if (this.totalCnt() != 0L) {
            this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
            this.lossSum_$eq(this.lossSum() + other.lossSum());
            this.gradientBetaSum().$plus$eq(other.gradientBetaSum(), DenseVector$.MODULE$.canAddIntoD());
            this.gradientLogSigmaSum_$eq(this.gradientLogSigmaSum() + other.gradientLogSigmaSum());
        }
        return this;
    }

    public AFTAggregator(DenseVector<Object> weights2, boolean fitIntercept) {
        this.fitIntercept = fitIntercept;
        this.beta = weights2.slice$mcD$sp(1, weights2.length(), weights2.slice$default$3());
        this.sigma = package$.MODULE$.exp(weights2.apply$mcD$sp(0));
        this.totalCnt = 0L;
        this.lossSum = 0.0;
        this.gradientBetaSum = DenseVector$.MODULE$.zeros$mDc$sp(this.beta().length(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        this.gradientLogSigmaSum = 0.0;
    }
}

