/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import org.apache.spark.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.CholeskyDecomposition$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%h!B\u0001\u0003\u0001\u0011a!\u0001F,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7O\u0003\u0002\u0004\t\u0005)q\u000e\u001d;j[*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0005\u00015\u0019r\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Ui\u0011AB\u0005\u0003-\u0019\u0011q\u0001T8hO&tw\r\u0005\u0002\u000f1%\u0011\u0011d\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t7\u0001\u0011)\u0019!C\u0001;\u0005aa-\u001b;J]R,'oY3qi\u000e\u0001Q#\u0001\u0010\u0011\u00059y\u0012B\u0001\u0011\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001B\t\u0001\u0003\u0002\u0003\u0006IAH\u0001\u000eM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0011\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\n\u0001B]3h!\u0006\u0014\u0018-\\\u000b\u0002MA\u0011abJ\u0005\u0003Q=\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0013I,w\rU1sC6\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002'M$\u0018M\u001c3be\u0012L'0\u001a$fCR,(/Z:\t\u00119\u0002!\u0011!Q\u0001\ny\tAc\u001d;b]\u0012\f'\u000fZ5{K\u001a+\u0017\r^;sKN\u0004\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002!M$\u0018M\u001c3be\u0012L'0\u001a'bE\u0016d\u0007\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002#M$\u0018M\u001c3be\u0012L'0\u001a'bE\u0016d\u0007\u0005C\u00035\u0001\u0011\u0005Q'\u0001\u0004=S:LGO\u0010\u000b\u0006maJ$h\u000f\t\u0003o\u0001i\u0011A\u0001\u0005\u00067M\u0002\rA\b\u0005\u0006IM\u0002\rA\n\u0005\u0006YM\u0002\rA\b\u0005\u0006aM\u0002\rA\b\u0005\u0006{\u0001!\tAP\u0001\u0004M&$HCA C!\t9\u0004)\u0003\u0002B\u0005\tIr+Z5hQR,G\rT3bgR\u001c\u0016/^1sKNlu\u000eZ3m\u0011\u0015\u0019E\b1\u0001E\u0003%Ign\u001d;b]\u000e,7\u000fE\u0002F\u0011*k\u0011A\u0012\u0006\u0003\u000f\u001a\t1A\u001d3e\u0013\tIeIA\u0002S\t\u0012\u0003\"a\u0013(\u000e\u00031S!!\u0014\u0003\u0002\u000f\u0019,\u0017\r^;sK&\u0011q\n\u0014\u0002\t\u0013:\u001cH/\u00198dK\u001e1\u0011K\u0001E\u0001\tI\u000bAcV3jO\"$X\r\u001a'fCN$8+];be\u0016\u001c\bCA\u001cT\r\u0019\t!\u0001#\u0001\u0005)N\u00191+D\f\t\u000bQ\u001aF\u0011\u0001,\u0015\u0003I3A\u0001W*\u00053\nQ\u0011iZ4sK\u001e\fGo\u001c:\u0014\u0007]kq\u0003C\u00035/\u0012\u00051\fF\u0001]!\tiv+D\u0001T\u0011\u001dyv\u000b1A\u0005\u0002u\t1\"\u001b8ji&\fG.\u001b>fI\"9\u0011m\u0016a\u0001\n\u0003\u0011\u0017aD5oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\u0005\r4\u0007C\u0001\be\u0013\t)wB\u0001\u0003V]&$\bbB4a\u0003\u0003\u0005\rAH\u0001\u0004q\u0012\n\u0004BB5XA\u0003&a$\u0001\u0007j]&$\u0018.\u00197ju\u0016$\u0007\u0005C\u0005l/\u0002\u0007\t\u0019!C\u0001Y\u0006\t1.F\u0001n!\tqa.\u0003\u0002p\u001f\t\u0019\u0011J\u001c;\t\u0013E<\u0006\u0019!a\u0001\n\u0003\u0011\u0018!B6`I\u0015\fHCA2t\u0011\u001d9\u0007/!AA\u00025Da!^,!B\u0013i\u0017AA6!\u0011%9x\u000b1AA\u0002\u0013\u0005\u00010A\u0003d_VtG/F\u0001z!\tq!0\u0003\u0002|\u001f\t!Aj\u001c8h\u0011%ix\u000b1AA\u0002\u0013\u0005a0A\u0005d_VtGo\u0018\u0013fcR\u00111m \u0005\bOr\f\t\u00111\u0001z\u0011\u001d\t\u0019a\u0016Q!\ne\faaY8v]R\u0004\u0003BCA\u0004/\u0002\u0007\t\u0019!C\u0001Y\u0006!AO]5L\u0011-\tYa\u0016a\u0001\u0002\u0004%\t!!\u0004\u0002\u0011Q\u0014\u0018nS0%KF$2aYA\b\u0011!9\u0017\u0011BA\u0001\u0002\u0004i\u0007bBA\n/\u0002\u0006K!\\\u0001\u0006iJL7\n\t\u0005\u000b\u0003/9\u0006\u0019!a\u0001\n\u0013)\u0013\u0001B<Tk6D1\"a\u0007X\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001e\u0005AqoU;n?\u0012*\u0017\u000fF\u0002d\u0003?A\u0001bZA\r\u0003\u0003\u0005\rA\n\u0005\b\u0003G9\u0006\u0015)\u0003'\u0003\u001598+^7!\u0011)\t9c\u0016a\u0001\u0002\u0004%I!J\u0001\u0006o^\u001cV/\u001c\u0005\f\u0003W9\u0006\u0019!a\u0001\n\u0013\ti#A\u0005xoN+Xn\u0018\u0013fcR\u00191-a\f\t\u0011\u001d\fI#!AA\u0002\u0019Bq!a\rXA\u0003&a%\u0001\u0004xoN+X\u000e\t\u0005\u000b\u0003o9\u0006\u0019!a\u0001\n\u0013)\u0013\u0001\u00022Tk6D1\"a\u000fX\u0001\u0004\u0005\r\u0011\"\u0003\u0002>\u0005A!mU;n?\u0012*\u0017\u000fF\u0002d\u0003\u007fA\u0001bZA\u001d\u0003\u0003\u0005\rA\n\u0005\b\u0003\u0007:\u0006\u0015)\u0003'\u0003\u0015\u00117+^7!\u0011)\t9e\u0016a\u0001\u0002\u0004%I!J\u0001\u0006E\n\u001cV/\u001c\u0005\f\u0003\u0017:\u0006\u0019!a\u0001\n\u0013\ti%A\u0005cEN+Xn\u0018\u0013fcR\u00191-a\u0014\t\u0011\u001d\fI%!AA\u0002\u0019Bq!a\u0015XA\u0003&a%\u0001\u0004cEN+X\u000e\t\u0005\f\u0003/:\u0006\u0019!a\u0001\n\u0013\tI&\u0001\u0003b'VlWCAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\na\u0001\\5oC2<'bAA3\r\u0005)Q\u000e\u001c7jE&!\u0011\u0011NA0\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u0017\u00055t\u000b1AA\u0002\u0013%\u0011qN\u0001\tCN+Xn\u0018\u0013fcR\u00191-!\u001d\t\u0013\u001d\fY'!AA\u0002\u0005m\u0003\u0002CA;/\u0002\u0006K!a\u0017\u0002\u000b\u0005\u001cV/\u001c\u0011\t\u0017\u0005et\u000b1AA\u0002\u0013%\u0011\u0011L\u0001\u0006C\n\u001cV/\u001c\u0005\f\u0003{:\u0006\u0019!a\u0001\n\u0013\ty(A\u0005bEN+Xn\u0018\u0013fcR\u00191-!!\t\u0013\u001d\fY(!AA\u0002\u0005m\u0003\u0002CAC/\u0002\u0006K!a\u0017\u0002\r\u0005\u00147+^7!\u0011-\tIi\u0016a\u0001\u0002\u0004%I!!\u0017\u0002\u000b\u0005\f7+^7\t\u0017\u00055u\u000b1AA\u0002\u0013%\u0011qR\u0001\nC\u0006\u001cV/\\0%KF$2aYAI\u0011%9\u00171RA\u0001\u0002\u0004\tY\u0006\u0003\u0005\u0002\u0016^\u0003\u000b\u0015BA.\u0003\u0019\t\u0017mU;nA!9\u0011\u0011T,\u0005\n\u0005m\u0015\u0001B5oSR$2aYAO\u0011\u0019Y\u0017q\u0013a\u0001[\"9\u0011\u0011U,\u0005\u0002\u0005\r\u0016aA1eIR!\u0011QUAT\u001b\u00059\u0006bBAU\u0003?\u0003\rAS\u0001\tS:\u001cH/\u00198dK\"9\u0011QV,\u0005\u0002\u0005=\u0016!B7fe\u001e,G\u0003BAS\u0003cCq!a-\u0002,\u0002\u0007A,A\u0003pi\",'\u000fC\u0004\u00028^#\t!!/\u0002\u0011Y\fG.\u001b3bi\u0016$\u0012a\u0019\u0005\b\u0003{;F\u0011AA-\u0003\u0011\t')\u0019:\t\r\u0005\u0005w\u000b\"\u0001&\u0003\u0011\u0011')\u0019:\t\r\u0005\u0015w\u000b\"\u0001&\u0003\u0011\u00117\u000b\u001e3\t\u000f\u0005%w\u000b\"\u0001\u0002Z\u0005)\u0011M\u0019\"be\"9\u0011QZ,\u0005\u0002\u0005e\u0013!B1b\u0005\u0006\u0014\bbBAi/\u0012\u0005\u0011\u0011L\u0001\u0005CZ\u000b'\u000fC\u0005\u0002VN\u000b\t\u0011\"\u0003\u0002X\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u000e\u0005\u0003\u0002\\\u0006\u0015XBAAo\u0015\u0011\ty.!9\u0002\t1\fgn\u001a\u0006\u0003\u0003G\fAA[1wC&!\u0011q]Ao\u0005\u0019y%M[3di\u0002")
public class WeightedLeastSquares
implements Logging,
Serializable {
    private final boolean fitIntercept;
    private final double regParam;
    private final boolean standardizeFeatures;
    private final boolean standardizeLabel;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public boolean standardizeFeatures() {
        return this.standardizeFeatures;
    }

    public boolean standardizeLabel() {
        return this.standardizeLabel;
    }

    public WeightedLeastSquaresModel fit(RDD<Instance> instances) {
        Aggregator x$6 = new Aggregator();
        Serializable x$7 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Aggregator apply(Aggregator x$1, Instance x$2) {
                return x$1.add(x$2);
            }
        };
        Serializable x$8 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Aggregator apply(Aggregator x$3, Aggregator x$4) {
                return x$3.merge(x$4);
            }
        };
        int x$9 = instances.treeAggregate$default$4((Object)x$6);
        Aggregator summary = (Aggregator)instances.treeAggregate((Object)x$6, (Function2)x$7, (Function2)x$8, x$9, ClassTag$.MODULE$.apply(Aggregator.class));
        summary.validate();
        this.logInfo((Function0<String>)new Serializable(this, summary){
            public static final long serialVersionUID = 0L;
            private final Aggregator summary$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of instances: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.summary$1.count())}));
            }
            {
                this.summary$1 = summary$1;
            }
        });
        int triK = summary.triK();
        double bBar = summary.bBar();
        double bStd = summary.bStd();
        DenseVector aBar = summary.aBar();
        DenseVector aVar = summary.aVar();
        DenseVector abBar = summary.abBar();
        DenseVector aaBar = summary.aaBar();
        double[] aaValues = aaBar.values();
        if (this.fitIntercept()) {
            BLAS$.MODULE$.spr(-1.0, (Vector)aBar, aaValues);
            BLAS$.MODULE$.axpy(-bBar, (Vector)aBar, (Vector)abBar);
        }
        int i = 0;
        int j = 2;
        while (i < triK) {
            double lambda = this.regParam();
            if (this.standardizeFeatures()) {
                lambda *= aVar.apply(j - 2);
            }
            if (this.standardizeLabel()) {
                lambda /= bStd;
            }
            int n = i;
            aaValues[n] = aaValues[n] + lambda;
            i += j;
            ++j;
        }
        DenseVector x = new DenseVector(CholeskyDecomposition$.MODULE$.solve(aaBar.values(), abBar.values()));
        double intercept = this.fitIntercept() ? bBar - BLAS$.MODULE$.dot((Vector)aBar, (Vector)x) : 0.0;
        return new WeightedLeastSquaresModel(x, intercept);
    }

    public WeightedLeastSquares(boolean fitIntercept, double regParam, boolean standardizeFeatures, boolean standardizeLabel) {
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.standardizeFeatures = standardizeFeatures;
        this.standardizeLabel = standardizeLabel;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(regParam >= 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regParam cannot be negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.regParam())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (regParam == 0.0) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "regParam is zero, which might cause numerical instability and overfitting.";
                }
            });
        }
    }

    public static class Aggregator
    implements Serializable {
        private boolean initialized = false;
        private int k;
        private long count;
        private int triK;
        private double wSum;
        private double wwSum;
        private double bSum;
        private double bbSum;
        private DenseVector aSum;
        private DenseVector abSum;
        private DenseVector aaSum;

        public boolean initialized() {
            return this.initialized;
        }

        public void initialized_$eq(boolean x$1) {
            this.initialized = x$1;
        }

        public int k() {
            return this.k;
        }

        public void k_$eq(int x$1) {
            this.k = x$1;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public int triK() {
            return this.triK;
        }

        public void triK_$eq(int x$1) {
            this.triK = x$1;
        }

        private double wSum() {
            return this.wSum;
        }

        private void wSum_$eq(double x$1) {
            this.wSum = x$1;
        }

        private double wwSum() {
            return this.wwSum;
        }

        private void wwSum_$eq(double x$1) {
            this.wwSum = x$1;
        }

        private double bSum() {
            return this.bSum;
        }

        private void bSum_$eq(double x$1) {
            this.bSum = x$1;
        }

        private double bbSum() {
            return this.bbSum;
        }

        private void bbSum_$eq(double x$1) {
            this.bbSum = x$1;
        }

        private DenseVector aSum() {
            return this.aSum;
        }

        private void aSum_$eq(DenseVector x$1) {
            this.aSum = x$1;
        }

        private DenseVector abSum() {
            return this.abSum;
        }

        private void abSum_$eq(DenseVector x$1) {
            this.abSum = x$1;
        }

        private DenseVector aaSum() {
            return this.aaSum;
        }

        private void aaSum_$eq(DenseVector x$1) {
            this.aaSum = x$1;
        }

        private void init(int k) {
            Predef$.MODULE$.require(k <= 4096, (Function0)new Serializable(this, k){
                public static final long serialVersionUID = 0L;
                private final int k$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"In order to take the normal equation approach efficiently, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we set the max number of features to 4096 but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}))).toString();
                }
                {
                    this.k$1 = k$1;
                }
            });
            this.k_$eq(k);
            this.triK_$eq(k * (k + 1) / 2);
            this.count_$eq(0L);
            this.wSum_$eq(0.0);
            this.wwSum_$eq(0.0);
            this.bSum_$eq(0.0);
            this.bbSum_$eq(0.0);
            this.aSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.abSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.aaSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(this.triK(), ClassTag$.MODULE$.Double())));
            this.initialized_$eq(true);
        }

        public Aggregator add(Instance instance) {
            Instance instance2 = instance;
            if (instance2 != null) {
                Tuple3 tuple3;
                double l = instance2.label();
                double w2 = instance2.weight();
                Vector f = instance2.features();
                Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w2), (Object)f);
                double l2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                double w3 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                Vector f2 = (Vector)tuple32._3();
                int ak = f2.size();
                if (!this.initialized()) {
                    this.init(ak);
                }
                Predef$.MODULE$.assert(ak == this.k(), (Function0)new Serializable(this, ak){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Aggregator $outer;
                    private final int ak$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch. Expect vectors of size ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k()), BoxesRunTime.boxToInteger((int)this.ak$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.ak$1 = ak$1;
                    }
                });
                this.count_$eq(this.count() + 1L);
                this.wSum_$eq(this.wSum() + w3);
                this.wwSum_$eq(this.wwSum() + w3 * w3);
                this.bSum_$eq(this.bSum() + w3 * l2);
                this.bbSum_$eq(this.bbSum() + w3 * l2 * l2);
                BLAS$.MODULE$.axpy(w3, f2, (Vector)this.aSum());
                BLAS$.MODULE$.axpy(w3 * l2, f2, (Vector)this.abSum());
                BLAS$.MODULE$.spr(w3, f2, this.aaSum());
                return this;
            }
            throw new MatchError((Object)instance2);
        }

        public Aggregator merge(Aggregator other) {
            Aggregator aggregator;
            if (other.initialized()) {
                if (!this.initialized()) {
                    this.init(other.k());
                }
                Predef$.MODULE$.assert(this.k() == other.k(), (Function0)new Serializable(this, other){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Aggregator $outer;
                    private final Aggregator other$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension mismatch: this.k = ", " but other.k = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k()), BoxesRunTime.boxToInteger((int)this.other$1.k())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.other$1 = other$1;
                    }
                });
                this.count_$eq(this.count() + other.count());
                this.wSum_$eq(this.wSum() + other.wSum());
                this.wwSum_$eq(this.wwSum() + other.wwSum());
                this.bSum_$eq(this.bSum() + other.bSum());
                this.bbSum_$eq(this.bbSum() + other.bbSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aSum(), (Vector)this.aSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.abSum(), (Vector)this.abSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aaSum(), (Vector)this.aaSum());
                aggregator = this;
            } else {
                aggregator = this;
            }
            return aggregator;
        }

        public void validate() {
            Predef$.MODULE$.assert(this.initialized(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Training dataset is empty.";
                }
            });
            Predef$.MODULE$.assert(this.wSum() > 0.0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Sum of weights cannot be zero.";
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aBar() {
            void var1_1;
            DenseVector output = this.aSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), output);
            return var1_1;
        }

        public double bBar() {
            return this.bSum() / this.wSum();
        }

        public double bStd() {
            return package$.MODULE$.sqrt(this.bbSum() / this.wSum() - this.bBar() * this.bBar());
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector abBar() {
            void var1_1;
            DenseVector output = this.abSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), output);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aaBar() {
            void var1_1;
            DenseVector output = this.aaSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), output);
            return var1_1;
        }

        public DenseVector aVar() {
            double[] variance2 = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                variance2[l] = aaValues[i] / this.wSum() - aw * aw;
                i += j;
                ++j;
            }
            return new DenseVector(variance2);
        }
    }
}

