/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.VectorSlicer$;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u00055\u0011ABV3di>\u00148\u000b\\5dKJT!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0005\u000e\u0011\u0005=\u0001R\"\u0001\u0003\n\u0005E!!a\u0003+sC:\u001chm\u001c:nKJ\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\rMD\u0017M]3e\u0015\t9B!A\u0003qCJ\fW.\u0003\u0002\u001a)\tY\u0001*Y:J]B,HoQ8m!\t\u00192$\u0003\u0002\u001d)\ta\u0001*Y:PkR\u0004X\u000f^\"pY\"Aa\u0004\u0001BC\u0002\u0013\u0005s$A\u0002vS\u0012,\u0012\u0001\t\t\u0003C\u001dr!AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u0015*\u0005\u0019\u0019FO]5oO*\u0011ae\t\u0005\tW\u0001\u0011\t\u0011)A\u0005A\u0005!Q/\u001b3!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0011q&\r\t\u0003a\u0001i\u0011A\u0001\u0005\u0006=1\u0002\r\u0001\t\u0005\u0006[\u0001!\ta\r\u000b\u0002_!9Q\u0007\u0001b\u0001\n\u00031\u0014aB5oI&\u001cWm]\u000b\u0002oA\u0011\u0001(O\u0007\u0002-%\u0011!H\u0006\u0002\u000e\u0013:$\u0018I\u001d:bsB\u000b'/Y7\t\rq\u0002\u0001\u0015!\u00038\u0003!Ig\u000eZ5dKN\u0004\u0003\"\u0002 \u0001\t\u0003y\u0014AC4fi&sG-[2fgV\t\u0001\tE\u0002#\u0003\u000eK!AQ\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\t\"\u0015BA#$\u0005\rIe\u000e\u001e\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u000bg\u0016$\u0018J\u001c3jG\u0016\u001cHCA%K\u001b\u0005\u0001\u0001\"B&G\u0001\u0004\u0001\u0015!\u0002<bYV,\u0007bB'\u0001\u0005\u0004%\tAT\u0001\u0006]\u0006lWm]\u000b\u0002\u001fB\u0011\u0001\bU\u0005\u0003#Z\u0011\u0001c\u0015;sS:<\u0017I\u001d:bsB\u000b'/Y7\t\rM\u0003\u0001\u0015!\u0003P\u0003\u0019q\u0017-\\3tA!)Q\u000b\u0001C\u0001-\u0006Aq-\u001a;OC6,7/F\u0001X!\r\u0011\u0013\t\t\u0005\u00063\u0002!\tAW\u0001\tg\u0016$h*Y7fgR\u0011\u0011j\u0017\u0005\u0006\u0017b\u0003\ra\u0016\u0005\u0006;\u0002!\tAX\u0001\fg\u0016$\u0018J\u001c9vi\u000e{G\u000e\u0006\u0002J?\")1\n\u0018a\u0001A!)\u0011\r\u0001C\u0001E\u0006a1/\u001a;PkR\u0004X\u000f^\"pYR\u0011\u0011j\u0019\u0005\u0006\u0017\u0002\u0004\r\u0001\t\u0005\u0006K\u0002!\tEZ\u0001\u000fm\u0006d\u0017\u000eZ1uKB\u000b'/Y7t)\u00059\u0007C\u0001\u0012i\u0013\tI7E\u0001\u0003V]&$\b\"B6\u0001\t\u0003b\u0017!\u0003;sC:\u001chm\u001c:n)\ti7\u000f\u0005\u0002oc6\tqN\u0003\u0002q\r\u0005\u00191/\u001d7\n\u0005I|'!\u0003#bi\u00064%/Y7f\u0011\u0015!(\u000e1\u0001n\u0003\u001d!\u0017\r^1tKRDQA\u001e\u0001\u0005\n]\f\u0011dZ3u'\u0016dWm\u0019;fI\u001a+\u0017\r^;sK&sG-[2fgR\u0011\u0001\t\u001f\u0005\u0006sV\u0004\rA_\u0001\u0007g\u000eDW-\\1\u0011\u0005mtX\"\u0001?\u000b\u0005u|\u0017!\u0002;za\u0016\u001c\u0018BA@}\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0003=!(/\u00198tM>\u0014XnU2iK6\fGc\u0001>\u0002\b!1\u00110!\u0001A\u0002iDq!a\u0003\u0001\t\u0003\ni!\u0001\u0003d_BLHcA\u0018\u0002\u0010!A\u0011\u0011CA\u0005\u0001\u0004\t\u0019\"A\u0003fqR\u0014\u0018\rE\u00029\u0003+I1!a\u0006\u0017\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\u0001\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)#a\b\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u0011\u0005%\"\u0001#\u0001\u0003\u0003W\tABV3di>\u00148\u000b\\5dKJ\u00042\u0001MA\u0017\r\u001d\t!\u0001#\u0001\u0003\u0003_\u0019b!!\f\u00022\u0005]\u0002c\u0001\u0012\u00024%\u0019\u0011QG\u0012\u0003\r\u0005s\u0017PU3g!\r\u0011\u0013\u0011H\u0005\u0004\u0003w\u0019#\u0001D*fe&\fG.\u001b>bE2,\u0007bB\u0017\u0002.\u0011\u0005\u0011q\b\u000b\u0003\u0003WA\u0001\"a\u0011\u0002.\u0011\u0005\u0011QI\u0001\rm\u0006d\u0017\u000eZ%oI&\u001cWm\u001d\u000b\u0005\u0003\u000f\ni\u0005E\u0002#\u0003\u0013J1!a\u0013$\u0005\u001d\u0011un\u001c7fC:Da!NA!\u0001\u0004\u0001\u0005\u0002CA)\u0003[!\t!a\u0015\u0002\u0015Y\fG.\u001b3OC6,7\u000f\u0006\u0003\u0002H\u0005U\u0003BB'\u0002P\u0001\u0007q\u000b\u0003\u0006\u0002Z\u00055\u0012\u0011!C\u0005\u00037\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\f\t\u0005\u0003?\nI'\u0004\u0002\u0002b)!\u00111MA3\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0014\u0001\u00026bm\u0006LA!a\u001b\u0002b\t1qJ\u00196fGR\u0004")
public final class VectorSlicer
extends Transformer
implements HasInputCol,
HasOutputCol {
    private final String uid;
    private final IntArrayParam indices;
    private final StringArrayParam names;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public static boolean validNames(String[] stringArray) {
        return VectorSlicer$.MODULE$.validNames(stringArray);
    }

    public static boolean validIndices(int[] nArray) {
        return VectorSlicer$.MODULE$.validIndices(nArray);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public IntArrayParam indices() {
        return this.indices;
    }

    public int[] getIndices() {
        return this.$(this.indices());
    }

    public VectorSlicer setIndices(int[] value) {
        return (VectorSlicer)this.set(this.indices(), value);
    }

    public StringArrayParam names() {
        return this.names;
    }

    public String[] getNames() {
        return this.$(this.names());
    }

    public VectorSlicer setNames(String[] value) {
        return (VectorSlicer)this.set(this.names(), value);
    }

    public VectorSlicer setInputCol(String value) {
        return (VectorSlicer)this.set(this.inputCol(), value);
    }

    public VectorSlicer setOutputCol(String value) {
        return (VectorSlicer)this.set(this.outputCol(), value);
    }

    @Override
    public void validateParams() {
        Predef$.MODULE$.require(this.$(this.indices()).length > 0 || this.$(this.names()).length > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"VectorSlicer requires that at least one feature be selected."})).s((Seq)Nil$.MODULE$);
            }
        });
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        Option option;
        block4: {
            AttributeGroup attributeGroup;
            int[] inds;
            block3: {
                block2: {
                    Option selectedAttrs;
                    this.transformSchema(dataset.schema());
                    AttributeGroup inputAttr = AttributeGroup$.MODULE$.fromStructField(dataset.schema().apply(this.$(this.inputCol())));
                    inputAttr.numAttributes().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ VectorSlicer $outer;

                        public final void apply(int numFeatures) {
                            this.apply$mcVI$sp(numFeatures);
                        }

                        public void apply$mcVI$sp(int numFeatures) {
                            int maxIndex = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(this.$outer.$(this.$outer.indices())).max((Ordering)Ordering.Int$.MODULE$));
                            Predef$.MODULE$.require(maxIndex < numFeatures, (Function0)new Serializable(this, maxIndex, numFeatures){
                                public static final long serialVersionUID = 0L;
                                private final int maxIndex$1;
                                private final int numFeatures$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Selected feature index ", " invalid for only ", " input features."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIndex$1), BoxesRunTime.boxToInteger((int)this.numFeatures$1)}));
                                }
                                {
                                    this.maxIndex$1 = maxIndex$1;
                                    this.numFeatures$1 = numFeatures$1;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    inds = this.getSelectedFeatureIndices(dataset.schema());
                    option = selectedAttrs = inputAttr.attributes().map((Function1)new Serializable(this, inds){
                        public static final long serialVersionUID = 0L;
                        private final int[] inds$1;

                        public final Attribute[] apply(Attribute[] attrs) {
                            return (Attribute[])Predef$.MODULE$.intArrayOps(this.inds$1).map((Function1)new Serializable(this, attrs){
                                public static final long serialVersionUID = 0L;
                                private final Attribute[] attrs$1;

                                public final Attribute apply(int index2) {
                                    return this.attrs$1[index2];
                                }
                                {
                                    this.attrs$1 = attrs$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
                        }
                        {
                            this.inds$1 = inds$1;
                        }
                    });
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Attribute[] attrs = (Attribute[])some.x();
                    attributeGroup = new AttributeGroup(this.$(this.outputCol()), attrs);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                attributeGroup = new AttributeGroup(this.$(this.outputCol()), inds.length);
            }
            AttributeGroup outputAttr = attributeGroup;
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorSlicer.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(VectorSlicer.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_VectorSlicer$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_VectorSlicer$$typecreator1$1(VectorSlicer $outer) {
                }
            }
            public final class Org_apache_spark_ml_feature_VectorSlicer$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_VectorSlicer$$typecreator2$1(VectorSlicer $outer) {
                }
            }
            UserDefinedFunction slicer = functions$.MODULE$.udf((Function1)new Serializable(this, inds){
                public static final long serialVersionUID = 0L;
                private final int[] inds$1;

                public final Vector apply(Vector vec) {
                    Vector vector;
                    block4: {
                        Vector vector2;
                        block3: {
                            block2: {
                                vector = vec;
                                if (!(vector instanceof DenseVector)) break block2;
                                DenseVector denseVector = (DenseVector)vector;
                                vector2 = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.intArrayOps(this.inds$1).map((Function1)new Serializable(this, denseVector){
                                    public static final long serialVersionUID = 0L;
                                    private final DenseVector x2$1;

                                    public final double apply(int i) {
                                        return this.apply$mcDI$sp(i);
                                    }

                                    public double apply$mcDI$sp(int i) {
                                        return this.x2$1.apply(i);
                                    }
                                    {
                                        this.x2$1 = x2$1;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                                break block3;
                            }
                            if (!(vector instanceof SparseVector)) break block4;
                            SparseVector sparseVector = (SparseVector)vector;
                            vector2 = sparseVector.slice(this.inds$1);
                        }
                        return vector2;
                    }
                    throw new MatchError((Object)vector);
                }
                {
                    this.inds$1 = inds$1;
                }
            }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_VectorSlicer$$typecreator1$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_VectorSlicer$$typecreator2$1(this)));
            return dataset.withColumn(this.$(this.outputCol()), slicer.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.apply(this.$(this.inputCol()))})), outputAttr.toMetadata());
        }
        throw new MatchError((Object)option);
    }

    private int[] getSelectedFeatureIndices(StructType schema) {
        int numDistinctFeatures;
        int[] indFeatures;
        ObjectRef errMsg$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        int[] nameFeatures = MetadataUtils$.MODULE$.getFeatureIndicesFromNames(schema.apply(this.$(this.inputCol())), this.$(this.names()));
        Predef$.MODULE$.require(nameFeatures.length + (indFeatures = this.$(this.indices())).length == (numDistinctFeatures = ((int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(nameFeatures).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(indFeatures), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).distinct()).length), (Function0)new Serializable(this, nameFeatures, indFeatures, errMsg$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorSlicer $outer;
            private final int[] nameFeatures$1;
            private final int[] indFeatures$1;
            private final ObjectRef errMsg$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final String apply() {
                return this.$outer.org$apache$spark$ml$feature$VectorSlicer$$errMsg$1(this.nameFeatures$1, this.indFeatures$1, this.errMsg$lzy$1, this.bitmap$0$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nameFeatures$1 = nameFeatures$1;
                this.indFeatures$1 = indFeatures$1;
                this.errMsg$lzy$1 = errMsg$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
        return (int[])Predef$.MODULE$.intArrayOps(indFeatures).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(nameFeatures), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.inputCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.checkColumnType$default$4());
        if (Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()).contains((Object)this.$(this.outputCol()))) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$(this.outputCol())})));
        }
        int numFeaturesSelected = this.$(this.indices()).length + this.$(this.names()).length;
        AttributeGroup outputAttr = new AttributeGroup(this.$(this.outputCol()), numFeaturesSelected);
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).$colon$plus((Object)outputAttr.toStructField(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(outputFields);
    }

    @Override
    public VectorSlicer copy(ParamMap extra) {
        return (VectorSlicer)this.defaultCopy(extra);
    }

    private final String errMsg$lzycompute$1(int[] nameFeatures$1, int[] indFeatures$1, ObjectRef errMsg$lzy$1, VolatileByteRef bitmap$0$1) {
        VectorSlicer vectorSlicer = this;
        synchronized (vectorSlicer) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                errMsg$lzy$1.elem = new StringBuilder().append((Object)"VectorSlicer requires indices and names to be disjoint").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" sets of features, but they overlap."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" indices: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(indFeatures$1).mkString("[", ",", "]")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" names: "})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(nameFeatures$1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.$(this.names())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x0$1) {
                        Tuple2<Object, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int i = tuple2._1$mcI$sp();
                            String n = (String)tuple2._2();
                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), n}));
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("[", ",", "]")).toString();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)errMsg$lzy$1.elem;
        }
    }

    public final String org$apache$spark$ml$feature$VectorSlicer$$errMsg$1(int[] nameFeatures$1, int[] indFeatures$1, ObjectRef errMsg$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.errMsg$lzycompute$1(nameFeatures$1, indFeatures$1, errMsg$lzy$1, bitmap$0$1) : (String)errMsg$lzy$1.elem;
    }

    public VectorSlicer(String uid) {
        this.uid = uid;
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        this.indices = new IntArrayParam(this, "indices", "An array of indices to select features from a vector column. There can be no overlap with names.", (Function1<int[], Object>)new $anonfun$1(this));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.indices().$minus$greater(Array$.MODULE$.empty(ClassTag$.MODULE$.Int()))}));
        this.names = new StringArrayParam(this, "names", "An array of feature names to select features from a vector column. There can be no overlap with indices.", (Function1<String[], Object>)new $anonfun$2(this));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.names().$minus$greater(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))}));
    }

    public VectorSlicer() {
        this(Identifiable$.MODULE$.randomUID("vectorSlicer"));
    }
}

