/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SQLContext$;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u001b\tq1+\u0015'Ue\u0006t7OZ8s[\u0016\u0014(BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011\u0001B\u0005\u0003#\u0011\u00111\u0002\u0016:b]N4wN]7fe\"A1\u0003\u0001BC\u0002\u0013\u0005C#A\u0002vS\u0012,\u0012!\u0006\t\u0003-qq!a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\ta\u0001\u0015:fI\u00164\u0017BA\u000f\u001f\u0005\u0019\u0019FO]5oO*\u00111\u0004\u0007\u0005\tA\u0001\u0011\t\u0011)A\u0005+\u0005!Q/\u001b3!\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011A\u0001\u0005\u0006'\u0005\u0002\r!\u0006\u0005\u0006E\u0001!\t\u0001\u000b\u000b\u0002I!9!\u0006\u0001b\u0001\n\u000bY\u0013!C:uCR,W.\u001a8u+\u0005a\u0003cA\u00171+5\taF\u0003\u00020\t\u0005)\u0001/\u0019:b[&\u0011\u0011G\f\u0002\u0006!\u0006\u0014\u0018-\u001c\u0005\u0007g\u0001\u0001\u000bQ\u0002\u0017\u0002\u0015M$\u0018\r^3nK:$\b\u0005C\u00036\u0001\u0011\u0005a'\u0001\u0007tKR\u001cF/\u0019;f[\u0016tG\u000f\u0006\u00028q5\t\u0001\u0001C\u0003:i\u0001\u0007Q#A\u0003wC2,X\rC\u0003<\u0001\u0011\u0005A#\u0001\u0007hKR\u001cF/\u0019;f[\u0016tG\u000fC\u0004>\u0001\t\u0007I\u0011\u0002\u000b\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJDaa\u0010\u0001!\u0002\u0013)\u0012\u0001\u0005;bE2,\u0017\nZ3oi&4\u0017.\u001a:!\u0011\u0015\t\u0005\u0001\"\u0011C\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0002D\u0013B\u0011AiR\u0007\u0002\u000b*\u0011aIB\u0001\u0004gFd\u0017B\u0001%F\u0005%!\u0015\r^1Ge\u0006lW\rC\u0003K\u0001\u0002\u00071)A\u0004eCR\f7/\u001a;\t\u000b1\u0003A\u0011I'\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$\"A\u0014+\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E+\u0015!\u0002;za\u0016\u001c\u0018BA*Q\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006+.\u0003\rAT\u0001\u0007g\u000eDW-\\1\t\u000b]\u0003A\u0011\t-\u0002\t\r|\u0007/\u001f\u000b\u0003IeCQA\u0017,A\u0002m\u000bQ!\u001a=ue\u0006\u0004\"!\f/\n\u0005us#\u0001\u0003)be\u0006lW*\u00199)\u0005\u0001y\u0006C\u00011d\u001b\u0005\t'B\u00012\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003I\u0006\u0014A\"\u0012=qKJLW.\u001a8uC2\u0004")
public class SQLTransformer
extends Transformer {
    private final String uid;
    private final Param<String> statement;
    private final String tableIdentifier;

    @Override
    public String uid() {
        return this.uid;
    }

    public final Param<String> statement() {
        return this.statement;
    }

    public SQLTransformer setStatement(String value) {
        return (SQLTransformer)this.set(this.statement(), value);
    }

    public String getStatement() {
        return this.$(this.statement());
    }

    private String tableIdentifier() {
        return this.tableIdentifier;
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        String tableName = Identifiable$.MODULE$.randomUID(this.uid());
        dataset.registerTempTable(tableName);
        String realStatement = this.$(this.statement()).replace(this.tableIdentifier(), tableName);
        DataFrame outputDF = dataset.sqlContext().sql(realStatement);
        return outputDF;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SparkContext sc = SparkContext$.MODULE$.getOrCreate();
        SQLContext sqlContext = SQLContext$.MODULE$.getOrCreate(sc);
        RDD dummyRDD = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.empty()})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class));
        DataFrame dummyDF = sqlContext.createDataFrame(dummyRDD, schema);
        dummyDF.registerTempTable(this.tableIdentifier());
        StructType outputSchema = sqlContext.sql(this.$(this.statement())).schema();
        return outputSchema;
    }

    @Override
    public SQLTransformer copy(ParamMap extra) {
        return (SQLTransformer)this.defaultCopy(extra);
    }

    public SQLTransformer(String uid) {
        this.uid = uid;
        this.statement = new Param(this, "statement", "SQL statement");
        this.tableIdentifier = "__THIS__";
    }

    public SQLTransformer() {
        this(Identifiable$.MODULE$.randomUID("sql"));
    }
}

