/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.Logging;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class QuantileDiscretizer$
implements Logging,
Serializable {
    public static final QuantileDiscretizer$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new QuantileDiscretizer$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Row[] getSampledInput(DataFrame dataset, int numBins) {
        long totalSamples = dataset.count();
        Predef$.MODULE$.require(totalSamples > 0L, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "QuantileDiscretizer requires non-empty input dataset but was given an empty input.";
            }
        });
        int requiredSamples = package$.MODULE$.max(numBins * numBins, 10000);
        double fraction = package$.MODULE$.min((double)((long)requiredSamples / dataset.count()), 1.0);
        return dataset.sample(false, fraction, (long)new XORShiftRandom().nextInt()).collect();
    }

    public double[] findSplitCandidates(double[] samples, int numSplits) {
        double[] dArray;
        Map valueCountMap = (Map)Predef$.MODULE$.doubleArrayOps(samples).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(Map<Object, Object> m, double x) {
                return m.$plus((Tuple2)new Tuple2.mcDI.sp(x, BoxesRunTime.unboxToInt((Object)m.getOrElse((Object)BoxesRunTime.boxToDouble((double)x), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                })) + 1));
            }
        });
        Tuple2[] valueCounts = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)valueCountMap.toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$2) {
                return x$2._1$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).toArray(ClassTag$.MODULE$.apply(Tuple2.class))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2.mcDI.sp(Double.MAX_VALUE, 1)}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        int possibleSplits = valueCounts.length - 1;
        if (possibleSplits <= numSplits) {
            dArray = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])valueCounts).dropRight(1)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$3) {
                    return x$3._1$mcD$sp();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        } else {
            double stride = package$.MODULE$.ceil((double)samples.length / (double)(numSplits + 1));
            ArrayBuilder splitsBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            int currentCount = valueCounts[0]._2$mcI$sp();
            double targetCount = stride;
            for (int index2 = 1; index2 < valueCounts.length; ++index2) {
                double currentGap;
                int previousCount = currentCount;
                currentCount += valueCounts[index2]._2$mcI$sp();
                double previousGap = package$.MODULE$.abs((double)previousCount - targetCount);
                if (!(previousGap < (currentGap = package$.MODULE$.abs((double)currentCount - targetCount)))) continue;
                splitsBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)valueCounts[index2 - 1]._1$mcD$sp()));
                targetCount += stride;
            }
            dArray = (double[])splitsBuilder.result();
        }
        return dArray;
    }

    public double[] getSplits(double[] candidates) {
        double[] dArray;
        double[] effectiveValues;
        double[] dArray2 = Predef$.MODULE$.doubleArrayOps(candidates).size() != 0 ? (BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(candidates).head()) == Double.NEGATIVE_INFINITY && BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(candidates).last()) == Double.POSITIVE_INFINITY ? (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(candidates).drop(1)).dropRight(1) : (BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(candidates).head()) == Double.NEGATIVE_INFINITY ? (double[])Predef$.MODULE$.doubleArrayOps(candidates).drop(1) : (BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(candidates).last()) == Double.POSITIVE_INFINITY ? (double[])Predef$.MODULE$.doubleArrayOps(candidates).dropRight(1) : candidates))) : (effectiveValues = candidates);
        if (Predef$.MODULE$.doubleArrayOps(effectiveValues).size() == 0) {
            double[] dArray3 = new double[3];
            dArray3[0] = Double.NEGATIVE_INFINITY;
            dArray3[1] = 0.0;
            dArray = dArray3;
            dArray3[2] = Double.POSITIVE_INFINITY;
        } else {
            dArray = (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(new double[]{Double.NEGATIVE_INFINITY}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(effectiveValues), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(new double[]{Double.POSITIVE_INFINITY}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        }
        return dArray;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private QuantileDiscretizer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

