/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.feature.ChiSqSelectorModel;
import org.apache.spark.ml.feature.ChiSqSelectorParams;
import org.apache.spark.ml.feature.ChiSqSelectorParams$class;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0003\u001b\ti1\t[5TcN+G.Z2u_JT!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0006\t\u0004\u001fA\u0011R\"\u0001\u0003\n\u0005E!!!C#ti&l\u0017\r^8s!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\nDQ&\u001c\u0016oU3mK\u000e$xN]'pI\u0016d\u0007CA\n\u0018\u0013\tA\"AA\nDQ&\u001c\u0016oU3mK\u000e$xN\u001d)be\u0006l7\u000f\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0011\u001c\u0003\r)\u0018\u000eZ\u000b\u00029A\u0011Qd\t\b\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!eH\u0001\u0007!J,G-\u001a4\n\u0005\u0011*#AB*ue&twM\u0003\u0002#?!Aq\u0005\u0001B\u0001B\u0003%A$\u0001\u0003vS\u0012\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\b\u0006\u0002,YA\u00111\u0003\u0001\u0005\u00065!\u0002\r\u0001\b\u0005\u0006S\u0001!\tA\f\u000b\u0002W!)\u0001\u0007\u0001C\u0001c\u0005\t2/\u001a;Ok6$v\u000e\u001d$fCR,(/Z:\u0015\u0005I\u001aT\"\u0001\u0001\t\u000bQz\u0003\u0019A\u001b\u0002\u000bY\fG.^3\u0011\u0005y1\u0014BA\u001c \u0005\rIe\u000e\u001e\u0005\u0006s\u0001!\tAO\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\t\u00114\bC\u00035q\u0001\u0007A\u0004C\u0003>\u0001\u0011\u0005a(\u0001\u0007tKR|U\u000f\u001e9vi\u000e{G\u000e\u0006\u00023\u007f!)A\u0007\u0010a\u00019!)\u0011\t\u0001C\u0001\u0005\u0006Y1/\u001a;MC\n,GnQ8m)\t\u00114\tC\u00035\u0001\u0002\u0007A\u0004C\u0003F\u0001\u0011\u0005c)A\u0002gSR$\"AE$\t\u000b!#\u0005\u0019A%\u0002\u000f\u0011\fG/Y:fiB\u0011!*T\u0007\u0002\u0017*\u0011AJB\u0001\u0004gFd\u0017B\u0001(L\u0005%!\u0015\r^1Ge\u0006lW\rC\u0003Q\u0001\u0011\u0005\u0013+A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\t\u0011\u0006\f\u0005\u0002T-6\tAK\u0003\u0002V\u0017\u0006)A/\u001f9fg&\u0011q\u000b\u0016\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B-P\u0001\u0004\u0011\u0016AB:dQ\u0016l\u0017\rC\u0003\\\u0001\u0011\u0005C,\u0001\u0003d_BLHCA\u0016^\u0011\u0015q&\f1\u0001`\u0003\u0015)\u0007\u0010\u001e:b!\t\u00017-D\u0001b\u0015\t\u0011G!A\u0003qCJ\fW.\u0003\u0002eC\nA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0002\u0001MB\u0011qM[\u0007\u0002Q*\u0011\u0011NB\u0001\u000bC:tw\u000e^1uS>t\u0017BA6i\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public final class ChiSqSelector
extends Estimator<ChiSqSelectorModel>
implements ChiSqSelectorParams {
    private final String uid;
    private final IntParam numTopFeatures;
    private final Param<String> labelCol;
    private final Param<String> outputCol;
    private final Param<String> featuresCol;

    @Override
    public final IntParam numTopFeatures() {
        return this.numTopFeatures;
    }

    @Override
    public final void org$apache$spark$ml$feature$ChiSqSelectorParams$_setter_$numTopFeatures_$eq(IntParam x$1) {
        this.numTopFeatures = x$1;
    }

    @Override
    public int getNumTopFeatures() {
        return ChiSqSelectorParams$class.getNumTopFeatures(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public ChiSqSelector setNumTopFeatures(int value) {
        return (ChiSqSelector)this.set(this.numTopFeatures(), BoxesRunTime.boxToInteger((int)value));
    }

    public ChiSqSelector setFeaturesCol(String value) {
        return (ChiSqSelector)this.set(this.featuresCol(), value);
    }

    public ChiSqSelector setOutputCol(String value) {
        return (ChiSqSelector)this.set(this.outputCol(), value);
    }

    public ChiSqSelector setLabelCol(String value) {
        return (ChiSqSelector)this.set(this.labelCol(), value);
    }

    @Override
    public ChiSqSelectorModel fit(DataFrame dataset) {
        this.transformSchema(dataset.schema(), true);
        RDD input = dataset.select(this.$(this.labelCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$(this.featuresCol())})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object features = ((SeqLike)some.get()).apply(1);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (features instanceof Vector) {
                            Vector vector = (Vector)features;
                            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
                            return labeledPoint;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        org.apache.spark.mllib.feature.ChiSqSelectorModel chiSqSelector = new org.apache.spark.mllib.feature.ChiSqSelector(BoxesRunTime.unboxToInt((Object)this.$(this.numTopFeatures()))).fit((RDD<LabeledPoint>)input);
        return this.copyValues(new ChiSqSelectorModel(this.uid(), chiSqSelector).setParent(this), this.copyValues$default$2());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.featuresCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.checkColumnType$default$4());
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.labelCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
        return SchemaUtils$.MODULE$.appendColumn(schema, this.$(this.outputCol()), (DataType)new VectorUDT());
    }

    @Override
    public ChiSqSelector copy(ParamMap extra) {
        return (ChiSqSelector)this.defaultCopy(extra);
    }

    public ChiSqSelector(String uid) {
        this.uid = uid;
        HasFeaturesCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        ChiSqSelectorParams$class.$init$(this);
    }

    public ChiSqSelector() {
        this(Identifiable$.MODULE$.randomUID("chiSqSelector"));
    }
}

