/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u00055\u00111CU3he\u0016\u001c8/[8o\u000bZ\fG.^1u_JT!a\u0001\u0003\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f%i\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u0013\u00153\u0018\r\\;bi>\u0014\bCA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0019\u0019\b.\u0019:fI*\u0011q\u0003B\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u00033Q\u0011\u0001\u0003S1t!J,G-[2uS>t7i\u001c7\u0011\u0005MY\u0012B\u0001\u000f\u0015\u0005-A\u0015m\u001d'bE\u0016d7i\u001c7\t\u0011y\u0001!Q1A\u0005B}\t1!^5e+\u0005\u0001\u0003CA\u0011(\u001d\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001&\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u001a\u0003fA\u000f,cA\u0011AfL\u0007\u0002[)\u0011aFB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u0019.\u0005\u0015\u0019\u0016N\\2fC\u0005\u0011\u0014!B\u0019/i9\u0002\u0004\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\tULG\r\t\u0015\u0004g-\n\u0004\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\b\u0006\u0002:uA\u0011q\u0002\u0001\u0005\u0006=Y\u0002\r\u0001\t\u0015\u0004u-\n\u0004f\u0001\u001c,c!)q\u0007\u0001C\u0001}Q\t\u0011\bK\u0002>WEBq!\u0011\u0001C\u0002\u0013\u0005!)\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016,\u0012a\u0011\t\u0004\t\u0016\u0003S\"\u0001\f\n\u0005\u00193\"!\u0002)be\u0006l\u0007f\u0001!,c!1\u0011\n\u0001Q\u0001\n\r\u000b1\"\\3ue&\u001cg*Y7fA!\u001a\u0001jK\u0019\t\u000b1\u0003A\u0011A\u0010\u0002\u001b\u001d,G/T3ue&\u001cg*Y7fQ\rY5&\r\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u000eg\u0016$X*\u001a;sS\u000et\u0015-\\3\u0015\u0005E\u0013V\"\u0001\u0001\t\u000bMs\u0005\u0019\u0001\u0011\u0002\u000bY\fG.^3)\u00079[\u0013\u0007C\u0003W\u0001\u0011\u0005q+\u0001\ttKR\u0004&/\u001a3jGRLwN\\\"pYR\u0011\u0011\u000b\u0017\u0005\u0006'V\u0003\r\u0001\t\u0015\u0004+.\n\u0004\"B.\u0001\t\u0003a\u0016aC:fi2\u000b'-\u001a7D_2$\"!U/\t\u000bMS\u0006\u0019\u0001\u0011)\u0007i[\u0013\u0007C\u0003a\u0001\u0011\u0005\u0013-\u0001\u0005fm\u0006dW/\u0019;f)\t\u0011W\r\u0005\u0002#G&\u0011Am\t\u0002\u0007\t>,(\r\\3\t\u000b\u0019|\u0006\u0019A4\u0002\u000f\u0011\fG/Y:fiB\u0011\u0001n[\u0007\u0002S*\u0011!NB\u0001\u0004gFd\u0017B\u00017j\u0005%!\u0015\r^1Ge\u0006lW\rK\u0002`WEBQa\u001c\u0001\u0005BA\fa\"[:MCJ<WM\u001d\"fiR,'/F\u0001r!\t\u0011#/\u0003\u0002tG\t9!i\\8mK\u0006t\u0007f\u00018,c!)a\u000f\u0001C!o\u0006!1m\u001c9z)\tI\u0004\u0010C\u0003zk\u0002\u0007!0A\u0003fqR\u0014\u0018\r\u0005\u0002Ew&\u0011AP\u0006\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001aQo\u000b@\"\u0003}\fQ!\r\u00186]AB3\u0001AA\u0002!\ra\u0013QA\u0005\u0004\u0003\u000fi#\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007f\u0001\u0001,c\u0001")
public final class RegressionEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public RegressionEvaluator setMetricName(String value) {
        return (RegressionEvaluator)this.set(this.metricName(), value);
    }

    public RegressionEvaluator setPredictionCol(String value) {
        return (RegressionEvaluator)this.set(this.predictionCol(), value);
    }

    public RegressionEvaluator setLabelCol(String value) {
        return (RegressionEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(DataFrame dataset) {
        String string;
        block6: {
            double d;
            block3: {
                RegressionMetrics metrics;
                block5: {
                    block4: {
                        block2: {
                            StructType schema = dataset.schema();
                            SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.predictionCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
                            SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.labelCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
                            RDD predictionAndLabels = dataset.select(this.$(this.predictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$(this.labelCol())})).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<Object, Object> apply(Row x0$1) {
                                    Row row = x0$1;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object prediction = ((SeqLike)some.get()).apply(0);
                                        Object label = ((SeqLike)some.get()).apply(1);
                                        if (prediction instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                            if (label instanceof Double) {
                                                double d2 = BoxesRunTime.unboxToDouble((Object)label);
                                                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                                                return sp2;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                            }, ClassTag$.MODULE$.apply(Tuple2.class));
                            metrics = new RegressionMetrics((RDD<Tuple2<Object, Object>>)predictionAndLabels);
                            String string2 = string = this.$(this.metricName());
                            if ("rmse" != null ? !"rmse".equals(string2) : string2 != null) break block2;
                            d = metrics.rootMeanSquaredError();
                            break block3;
                        }
                        String string3 = string;
                        if ("mse" != null ? !"mse".equals(string3) : string3 != null) break block4;
                        d = metrics.meanSquaredError();
                        break block3;
                    }
                    String string4 = string;
                    if ("r2" != null ? !"r2".equals(string4) : string4 != null) break block5;
                    d = metrics.r2();
                    break block3;
                }
                String string5 = string;
                if ("mae" != null ? !"mae".equals(string5) : string5 != null) break block6;
                d = metrics.meanAbsoluteError();
            }
            double metric = d;
            return metric;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public boolean isLargerBetter() {
        String string;
        block6: {
            boolean bl;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            String string2 = string = this.$(this.metricName());
                            if ("rmse" != null ? !"rmse".equals(string2) : string2 != null) break block2;
                            bl = false;
                            break block3;
                        }
                        String string3 = string;
                        if ("mse" != null ? !"mse".equals(string3) : string3 != null) break block4;
                        bl = false;
                        break block3;
                    }
                    String string4 = string;
                    if ("r2" != null ? !"r2".equals(string4) : string4 != null) break block5;
                    bl = true;
                    break block3;
                }
                String string5 = string;
                if ("mae" != null ? !"mae".equals(string5) : string5 != null) break block6;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public RegressionEvaluator copy(ParamMap extra) {
        return (RegressionEvaluator)this.defaultCopy(extra);
    }

    public RegressionEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"mse", "rmse", "r2", "mae"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (mse|rmse|r2|mae)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("rmse")}));
    }

    public RegressionEvaluator() {
        this(Identifiable$.MODULE$.randomUID("regEval"));
    }
}

