/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasRawPredictionCol;
import org.apache.spark.ml.param.shared.HasRawPredictionCol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u00015\u0011QDQ5oCJL8\t\\1tg&4\u0017nY1uS>tWI^1mk\u0006$xN\u001d\u0006\u0003\u0007\u0011\t!\"\u001a<bYV\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001q!C\u0007\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011\u0011\"\u0012<bYV\fGo\u001c:\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012AB:iCJ,GM\u0003\u0002\u0018\t\u0005)\u0001/\u0019:b[&\u0011\u0011\u0004\u0006\u0002\u0014\u0011\u0006\u001c(+Y<Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\t\u0003'mI!\u0001\b\u000b\u0003\u0017!\u000b7\u000fT1cK2\u001cu\u000e\u001c\u0005\t=\u0001\u0011)\u0019!C!?\u0005\u0019Q/\u001b3\u0016\u0003\u0001\u0002\"!I\u0014\u000f\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003M\rB3!H\u00162!\tas&D\u0001.\u0015\tqc!\u0001\u0006b]:|G/\u0019;j_:L!\u0001M\u0017\u0003\u000bMKgnY3\"\u0003I\nQ!\r\u00185]AB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0005k&$\u0007\u0005K\u00024WEBQa\u000e\u0001\u0005\u0002a\na\u0001P5oSRtDCA\u001d;!\ty\u0001\u0001C\u0003\u001fm\u0001\u0007\u0001\u0005K\u0002;WEB3AN\u00162\u0011\u00159\u0004\u0001\"\u0001?)\u0005I\u0004fA\u001f,\u0001\u0006\n\u0011)A\u00032]Ir\u0003\u0007C\u0004D\u0001\t\u0007I\u0011\u0001#\u0002\u00155,GO]5d\u001d\u0006lW-F\u0001F!\r1u\tI\u0007\u0002-%\u0011\u0001J\u0006\u0002\u0006!\u0006\u0014\u0018-\u001c\u0015\u0004\u0005.\u0002\u0005BB&\u0001A\u0003%Q)A\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004\u0003f\u0001&,\u0001\")a\n\u0001C\u0001?\u0005iq-\u001a;NKR\u0014\u0018n\u0019(b[\u0016D3!T\u0016A\u0011\u0015\t\u0006\u0001\"\u0001S\u00035\u0019X\r^'fiJL7MT1nKR\u00111\u000bV\u0007\u0002\u0001!)Q\u000b\u0015a\u0001A\u0005)a/\u00197vK\"\u001a\u0001k\u000b!\t\u000ba\u0003A\u0011A-\u0002'M,GOU1x!J,G-[2uS>t7i\u001c7\u0015\u0005MS\u0006\"B+X\u0001\u0004\u0001\u0003fA,,9\u0006\nQ,A\u00032]Ur\u0003\u0007C\u0003`\u0001\u0011\u0005\u0001-A\u0006tKR\u001c6m\u001c:f\u0007>dGCA*b\u0011\u0015)f\f1\u0001!Q\rq6\u0006\u0011\u0015\u0005=\u0012<G\f\u0005\u0002#K&\u0011am\t\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017%\u00015\u0002?U\u001cX\rI:fiJ\u000bw\u000f\u0015:fI&\u001cG/[8o\u0007>d\u0007%\u001b8ti\u0016\fG\rC\u0003k\u0001\u0011\u00051.A\u0006tKRd\u0015MY3m\u0007>dGCA*m\u0011\u0015)\u0016\u000e1\u0001!Q\rI7\u0006\u0011\u0005\u0006_\u0002!\t\u0005]\u0001\tKZ\fG.^1uKR\u0011\u0011\u000f\u001e\t\u0003EIL!a]\u0012\u0003\r\u0011{WO\u00197f\u0011\u0015)h\u000e1\u0001w\u0003\u001d!\u0017\r^1tKR\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u0004\u0002\u0007M\fH.\u0003\u0002|q\nIA)\u0019;b\rJ\fW.\u001a\u0015\u0004].\u0002\u0005\"\u0002@\u0001\t\u0003z\u0018AD5t\u0019\u0006\u0014x-\u001a:CKR$XM]\u000b\u0003\u0003\u0003\u00012AIA\u0002\u0013\r\t)a\t\u0002\b\u0005>|G.Z1oQ\ri8\u0006\u0018\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0003\u0011\u0019w\u000e]=\u0015\u0007e\ny\u0001\u0003\u0005\u0002\u0012\u0005%\u0001\u0019AA\n\u0003\u0015)\u0007\u0010\u001e:b!\r1\u0015QC\u0005\u0004\u0003/1\"\u0001\u0003)be\u0006lW*\u00199)\u000b\u0005%1&a\u0007\"\u0005\u0005u\u0011!B\u0019/i9\n\u0004f\u0001\u0001\u0002\"A\u0019A&a\t\n\u0007\u0005\u0015RF\u0001\u0007FqB,'/[7f]R\fG\u000eK\u0002\u0001W\u0001\u0003")
public class BinaryClassificationEvaluator
extends Evaluator
implements HasRawPredictionCol,
HasLabelCol {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> rawPredictionCol;

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param x$1) {
        this.rawPredictionCol = x$1;
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol$class.getRawPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public BinaryClassificationEvaluator setMetricName(String value) {
        return (BinaryClassificationEvaluator)this.set(this.metricName(), value);
    }

    public BinaryClassificationEvaluator setRawPredictionCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.rawPredictionCol(), value);
    }

    public BinaryClassificationEvaluator setScoreCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.rawPredictionCol(), value);
    }

    public BinaryClassificationEvaluator setLabelCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(DataFrame dataset) {
        String string;
        block4: {
            double d;
            BinaryClassificationMetrics metrics;
            block3: {
                block2: {
                    StructType schema = dataset.schema();
                    SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.rawPredictionCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.checkColumnType$default$4());
                    SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.labelCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
                    RDD scoreAndLabels = dataset.select(this.$(this.rawPredictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$(this.labelCol())})).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Row x0$1) {
                            Row row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                Object rawPrediction = ((SeqLike)some.get()).apply(0);
                                Object label = ((SeqLike)some.get()).apply(1);
                                if (rawPrediction instanceof Vector) {
                                    Vector vector = (Vector)rawPrediction;
                                    if (label instanceof Double) {
                                        double d = BoxesRunTime.unboxToDouble((Object)label);
                                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(vector.apply(1), d);
                                        return sp2;
                                    }
                                }
                            }
                            throw new MatchError((Object)row);
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                    metrics = new BinaryClassificationMetrics((RDD<Tuple2<Object, Object>>)scoreAndLabels);
                    String string2 = string = this.$(this.metricName());
                    if ("areaUnderROC" != null ? !"areaUnderROC".equals(string2) : string2 != null) break block2;
                    d = metrics.areaUnderROC();
                    break block3;
                }
                String string3 = string;
                if ("areaUnderPR" != null ? !"areaUnderPR".equals(string3) : string3 != null) break block4;
                d = metrics.areaUnderPR();
            }
            double metric = d;
            metrics.unpersist();
            return metric;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public boolean isLargerBetter() {
        String string;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    String string2 = string = this.$(this.metricName());
                    if ("areaUnderROC" != null ? !"areaUnderROC".equals(string2) : string2 != null) break block2;
                    bl = true;
                    break block3;
                }
                String string3 = string;
                if ("areaUnderPR" != null ? !"areaUnderPR".equals(string3) : string3 != null) break block4;
                bl = true;
            }
            return bl;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.defaultCopy(extra);
    }

    public BinaryClassificationEvaluator(String uid) {
        this.uid = uid;
        HasRawPredictionCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"areaUnderROC", "areaUnderPR"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (areaUnderROC|areaUnderPR)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("areaUnderROC")}));
    }

    public BinaryClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("binEval"));
    }
}

