/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.classification.NaiveBayesModel$;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.NaiveBayesParams$class;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u00015\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f7A!q\u0002\u0005\n\u001b\u001b\u0005\u0011\u0011BA\t\u0003\u0005\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012A\u00027j]\u0006dwM\u0003\u0002\u0018\r\u0005)Q\u000e\u001c7jE&\u0011\u0011\u0004\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001d\u0013\ti\"A\u0001\tOC&4XMQ1zKN\u0004\u0016M]1ng\"Aq\u0004\u0001BC\u0002\u0013\u0005\u0003%A\u0002vS\u0012,\u0012!\t\t\u0003E!r!a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\na\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\u0019\u0019FO]5oO*\u0011q\u0005\n\u0005\tY\u0001\u0011\t\u0011)A\u0005C\u0005!Q/\u001b3!\u0011!q\u0003A!b\u0001\n\u0003y\u0013A\u00019j+\u0005\u0011\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0007AL\u0007\u0005\u0003\u00054\u0001\t\u0015\r\u0011\"\u00015\u0003\u0015!\b.\u001a;b+\u0005)\u0004CA\n7\u0013\t9DC\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0005\ts\u0001\u0011\t\u0011)A\u0005k\u00051A\u000f[3uC\u0002Baa\u000f\u0001\u0005\u0002\u0011a\u0014A\u0002\u001fj]&$h\b\u0006\u0003\u001b{yz\u0004\"B\u0010;\u0001\u0004\t\u0003\"\u0002\u0018;\u0001\u0004\u0011\u0002\"B\u001a;\u0001\u0004)\u0004\u0002C!\u0001\u0011\u000f\u0007K\u0011\u0002\"\u0002\u0007a$\u0013'F\u0001D!\u0011\u0019CIR%\n\u0005\u0015##A\u0002+va2,'\u0007E\u0002$\u000fVJ!\u0001\u0013\u0013\u0003\r=\u0003H/[8o!\r\u0019sI\u0013\t\u0003'-K!\u0001\u0014\u000b\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\u0005\t\u001d\u0002A\t\u0011)Q\u0005\u0007\u0006!\u0001\u0010J\u0019!\u0011!\u0001\u0006\u0001#b\u0001\n\u0013\t\u0016A\u0005;iKR\fW*\u001b8vg:+w\r\u00165fi\u0006,\u0012A\u0012\u0005\t'\u0002A\t\u0011)Q\u0005\r\u0006\u0019B\u000f[3uC6Kg.^:OK\u001e$\u0006.\u001a;bA!AQ\u000b\u0001EC\u0002\u0013%a+A\u0006oK\u001e$\u0006.\u001a;b'VlW#A%\t\u0011a\u0003\u0001\u0012!Q!\n%\u000bAB\\3h)\",G/Y*v[\u0002BqA\u0017\u0001C\u0002\u0013\u00053,A\u0006ok64U-\u0019;ve\u0016\u001cX#\u0001/\u0011\u0005\rj\u0016B\u00010%\u0005\rIe\u000e\u001e\u0005\u0007A\u0002\u0001\u000b\u0011\u0002/\u0002\u00199,XNR3biV\u0014Xm\u001d\u0011\t\u000f\t\u0004!\u0019!C!7\u0006Qa.^7DY\u0006\u001c8/Z:\t\r\u0011\u0004\u0001\u0015!\u0003]\u0003-qW/\\\"mCN\u001cXm\u001d\u0011\t\u000b\u0019\u0004A\u0011B4\u0002-5,H\u000e^5o_6L\u0017\r\\\"bY\u000e,H.\u0019;j_:$\"A\u00135\t\u000b%,\u0007\u0019\u0001\n\u0002\u0011\u0019,\u0017\r^;sKNDQa\u001b\u0001\u0005\n1\fACY3s]>,H\u000e\\5DC2\u001cW\u000f\\1uS>tGC\u0001&n\u0011\u0015I'\u000e1\u0001\u0013\u0011\u0015y\u0007\u0001\"\u0015q\u0003)\u0001(/\u001a3jGR\u0014\u0016m\u001e\u000b\u0003%EDQ!\u001b8A\u0002IAQa\u001d\u0001\u0005RQ\faC]1xeA\u0014xNY1cS2LG/_%o!2\f7-\u001a\u000b\u0003%UDQA\u001e:A\u0002I\tQB]1x!J,G-[2uS>t\u0007\"\u0002=\u0001\t\u0003J\u0018\u0001B2paf$\"A\u0007>\t\u000bm<\b\u0019\u0001?\u0002\u000b\u0015DHO]1\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyH!A\u0003qCJ\fW.C\u0002\u0002\u0004y\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0003!!xn\u0015;sS:<G#A\u0011)\u0007\u0001\ti\u0001\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019BB\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\f\u0003#\u0011A\"\u0012=qKJLW.\u001a8uC2<\u0001\"a\u0007\u0003\u0011\u0003!\u0011QD\u0001\u0010\u001d\u0006Lg/\u001a\"bs\u0016\u001cXj\u001c3fYB\u0019q\"a\b\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0002\"M1\u0011qDA\u0012\u0003S\u00012aIA\u0013\u0013\r\t9\u0003\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\r\nY#C\u0002\u0002.\u0011\u0012AbU3sS\u0006d\u0017N_1cY\u0016DqaOA\u0010\t\u0003\t\t\u0004\u0006\u0002\u0002\u001e!A\u0011QGA\u0010\t\u0003\t9$A\u0004ge>lw\n\u001c3\u0015\u000bi\tI$!\u0012\t\u0011\u0005m\u00121\u0007a\u0001\u0003{\t\u0001b\u001c7e\u001b>$W\r\u001c\t\u0005\u0003\u007f\t\u0019%\u0004\u0002\u0002B)\u00111AF\u0005\u0004\u0003\u0005\u0005\u0003\u0002CA$\u0003g\u0001\r!!\u0013\u0002\rA\f'/\u001a8u!\ry\u00111J\u0005\u0004\u0003\u001b\u0012!A\u0003(bSZ,')Y=fg\"Q\u0011\u0011KA\u0010\u0003\u0003%I!a\u0015\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003+\u0002B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0003mC:<'BAA0\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0014\u0011\f\u0002\u0007\u001f\nTWm\u0019;")
public class NaiveBayesModel
extends ProbabilisticClassificationModel<Vector, NaiveBayesModel>
implements NaiveBayesParams {
    private final String uid;
    private final Vector pi;
    private final Matrix theta;
    private Tuple2<Option<Matrix>, Option<DenseVector>> x$1;
    private Option<Matrix> thetaMinusNegTheta;
    private Option<DenseVector> negThetaSum;
    private final int numFeatures;
    private final int numClasses;
    private final DoubleParam smoothing;
    private final Param<String> modelType;
    private volatile byte bitmap$0;

    public static NaiveBayesModel fromOld(org.apache.spark.mllib.classification.NaiveBayesModel naiveBayesModel, NaiveBayes naiveBayes) {
        return NaiveBayesModel$.MODULE$.fromOld(naiveBayesModel, naiveBayes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$1$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Multinomial();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    tuple22 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                } else {
                    String string4 = NaiveBayes$.MODULE$.Bernoulli();
                    String string5 = string;
                    if (string4 != null ? !string4.equals(string5) : string5 != null) throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$(this.modelType())})));
                    Matrix negTheta = this.theta().map((Function1<Object, Object>)new $anonfun$1(this));
                    DenseVector ones2 = new DenseVector((double[])Array$.MODULE$.fill(this.theta().numCols(), (Function0)new $anonfun$2(this), ClassTag$.MODULE$.Double()));
                    Matrix thetaMinusNegTheta = this.theta().map((Function1<Object, Object>)new $anonfun$3(this));
                    tuple22 = new Tuple2((Object)Option$.MODULE$.apply((Object)thetaMinusNegTheta), (Object)Option$.MODULE$.apply((Object)negTheta.multiply(ones2)));
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Option thetaMinusNegTheta = (Option)tuple23._1();
                Option negThetaSum = (Option)tuple23._2();
                this.x$1 = tuple2 = new Tuple2((Object)thetaMinusNegTheta, (Object)negThetaSum);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.x$1;
        }
    }

    private Option thetaMinusNegTheta$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.thetaMinusNegTheta = (Option)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.thetaMinusNegTheta;
        }
    }

    private Option negThetaSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.negThetaSum = (Option)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.negThetaSum;
        }
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param x$1) {
        this.modelType = x$1;
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams$class.getSmoothing(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams$class.getModelType(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector pi() {
        return this.pi;
    }

    public Matrix theta() {
        return this.theta;
    }

    private Tuple2<Option<Matrix>, Option<DenseVector>> x$1() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private Option<Matrix> thetaMinusNegTheta() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.thetaMinusNegTheta$lzycompute() : this.thetaMinusNegTheta;
    }

    private Option<DenseVector> negThetaSum() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.negThetaSum$lzycompute() : this.negThetaSum;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector features) {
        void var2_2;
        DenseVector prob2 = this.theta().multiply(features);
        BLAS$.MODULE$.axpy(1.0, this.pi(), (Vector)prob2);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector features) {
        void var2_2;
        features.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, features){
            public static final long serialVersionUID = 0L;
            private final Vector features$1;

            public final void apply(int x$2, double value) {
                this.apply$mcVID$sp(x$2, value);
            }

            public void apply$mcVID$sp(int x$2, double value) {
                if (value != 0.0 && value != 1.0) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bernoulli naive Bayes requires 0 or 1 feature values but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.features$1})));
                }
            }
            {
                this.features$1 = features$1;
            }
        });
        DenseVector prob2 = ((Matrix)this.thetaMinusNegTheta().get()).multiply(features);
        BLAS$.MODULE$.axpy(1.0, this.pi(), (Vector)prob2);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.negThetaSum().get(), (Vector)prob2);
        return var2_2;
    }

    @Override
    public Vector predictRaw(Vector features) {
        block4: {
            DenseVector denseVector;
            block3: {
                String string;
                block2: {
                    string = this.$(this.modelType());
                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    denseVector = this.multinomialCalculation(features);
                    break block3;
                }
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                denseVector = this.bernoulliCalculation(features);
            }
            return denseVector;
        }
        throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$(this.modelType())})));
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            int i;
            DenseVector denseVector = (DenseVector)vector;
            int size = denseVector.size();
            double maxLog = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(denseVector.values()).max((Ordering)Ordering.Double$.MODULE$));
            for (i = 0; i < size; ++i) {
                denseVector.values()[i] = package$.MODULE$.exp(denseVector.values()[i] - maxLog);
            }
            double probSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(denseVector.values()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            for (i = 0; i < size; ++i) {
                denseVector.values()[i] = denseVector.values()[i] / probSum;
            }
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in NaiveBayesModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public NaiveBayesModel copy(ParamMap extra) {
        return (NaiveBayesModel)this.copyValues(new NaiveBayesModel(this.uid(), this.pi(), this.theta()).setParent(this.parent()), extra);
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NaiveBayesModel (uid=", ") with ", " classes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uid(), BoxesRunTime.boxToInteger((int)this.pi().size())}));
    }

    public NaiveBayesModel(String uid, Vector pi, Matrix theta) {
        this.uid = uid;
        this.pi = pi;
        this.theta = theta;
        NaiveBayesParams$class.$init$(this);
        this.numFeatures = theta.numCols();
        this.numClasses = pi.size();
    }
}

