/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.DataFrame;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dm\u0001Ba\u0004\t\u001355\t!!\u0003\u0002\u0012\u0005\t\u0001\u0003K]8cC\nLG.[:uS\u000e\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0004mS:\fGn\u001a\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003\rY+7\r^8s!\ty\u0001\u0001\u0005\u0002\u00109%\u0011QD\u0001\u0002\u0019\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000eU1sC6\u001c\b\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\t\u0011\u0002\u0007ULG-F\u0001\"!\t\u0011\u0003F\u0004\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9C%\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014%\u0011!a\u0003A!A!\u0002\u0013\t\u0013\u0001B;jI\u0002B\u0001B\f\u0001\u0003\u0006\u0004%\taL\u0001\bo\u0016Lw\r\u001b;t+\u0005\u0011\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0011],\u0017n\u001a5ug\u0002B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001N\u0001\nS:$XM]2faR,\u0012!\u000e\t\u0003GYJ!a\u000e\u0013\u0003\r\u0011{WO\u00197f\u0011!I\u0004A!A!\u0002\u0013)\u0014AC5oi\u0016\u00148-\u001a9uA!11\b\u0001C\u0001\tq\na\u0001P5oSRtD\u0003\u0002\u000e>}}BQa\b\u001eA\u0002\u0005BQA\f\u001eA\u0002IAQa\r\u001eA\u0002UBQ!\u0011\u0001\u0005B\t\u000bAb]3u)\"\u0014Xm\u001d5pY\u0012$\"a\u0011#\u000e\u0003\u0001AQ!\u0012!A\u0002U\nQA^1mk\u0016DQa\u0012\u0001\u0005BQ\nAbZ3u)\"\u0014Xm\u001d5pY\u0012DQ!\u0013\u0001\u0005B)\u000bQb]3u)\"\u0014Xm\u001d5pY\u0012\u001cHCA\"L\u0011\u0015)\u0005\n1\u0001M!\r\u0019S*N\u0005\u0003\u001d\u0012\u0012Q!\u0011:sCfDQ\u0001\u0015\u0001\u0005BE\u000bQbZ3u)\"\u0014Xm\u001d5pY\u0012\u001cX#\u0001'\t\u000fM\u0003!\u0019!C\u0005)\u00061Q.\u0019:hS:,\u0012!\u0016\t\u0005GY\u0013R'\u0003\u0002XI\tIa)\u001e8di&|g.\r\u0005\u00073\u0002\u0001\u000b\u0011B+\u0002\u000f5\f'oZ5oA!91\f\u0001b\u0001\n\u0013!\u0016!B:d_J,\u0007BB/\u0001A\u0003%Q+\u0001\u0004tG>\u0014X\r\t\u0005\b?\u0002\u0011\r\u0011\"\u0011a\u0003-qW/\u001c$fCR,(/Z:\u0016\u0003\u0005\u0004\"a\t2\n\u0005\r$#aA%oi\"1Q\r\u0001Q\u0001\n\u0005\fAB\\;n\r\u0016\fG/\u001e:fg\u0002Bqa\u001a\u0001C\u0002\u0013\u0005\u0003-\u0001\u0006ok6\u001cE.Y:tKNDa!\u001b\u0001!\u0002\u0013\t\u0017a\u00038v[\u000ec\u0017m]:fg\u0002Bqa\u001b\u0001A\u0002\u0013%A.A\bue\u0006Lg.\u001b8h'VlW.\u0019:z+\u0005i\u0007cA\u0012oa&\u0011q\u000e\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005=\t\u0018B\u0001:\u0003\u0005\u0005bunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Ue\u0006Lg.\u001b8h'VlW.\u0019:z\u0011\u001d!\b\u00011A\u0005\nU\f1\u0003\u001e:bS:LgnZ*v[6\f'/_0%KF$\"A^=\u0011\u0005\r:\u0018B\u0001=%\u0005\u0011)f.\u001b;\t\u000fi\u001c\u0018\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\t\rq\u0004\u0001\u0015)\u0003n\u0003A!(/Y5oS:<7+^7nCJL\b\u0005C\u0003\u007f\u0001\u0011\u0005q0A\u0004tk6l\u0017M]=\u0016\u0003AD\u0001\"a\u0001\u0001\t\u0003\u0011\u0011QA\u0001\u000bg\u0016$8+^7nCJLHcA\"\u0002\b!1a0!\u0001A\u0002ADq!a\u0003\u0001\t\u0003\ti!\u0001\u0006iCN\u001cV/\\7bef,\"!a\u0004\u0011\u0007\r\n\t\"C\u0002\u0002\u0014\u0011\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0018\u0001!\tAAA\r\u0003!)g/\u00197vCR,G\u0003BA\u000e\u0003C\u00012aDA\u000f\u0013\r\tyB\u0001\u0002\u001a\u0019><\u0017n\u001d;jGJ+wM]3tg&|gnU;n[\u0006\u0014\u0018\u0010\u0003\u0005\u0002$\u0005U\u0001\u0019AA\u0013\u0003\u001d!\u0017\r^1tKR\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W1\u0011aA:rY&!\u0011qFA\u0015\u0005%!\u0015\r^1Ge\u0006lW\rC\u0004\u00024\u0001!\t&!\u000e\u0002\u000fA\u0014X\rZ5diR\u0019Q'a\u000e\t\u000f\u0005e\u0012\u0011\u0007a\u0001%\u0005Aa-Z1ukJ,7\u000fC\u0004\u0002>\u0001!\t&a\u0010\u0002-I\fwO\r9s_\n\f'-\u001b7jifLe\u000e\u00157bG\u0016$2AEA!\u0011\u001d\t\u0019%a\u000fA\u0002I\tQB]1x!J,G-[2uS>t\u0007bBA$\u0001\u0011E\u0013\u0011J\u0001\u000baJ,G-[2u%\u0006<Hc\u0001\n\u0002L!9\u0011\u0011HA#\u0001\u0004\u0011\u0002bBA(\u0001\u0011\u0005\u0013\u0011K\u0001\u0005G>\u0004\u0018\u0010F\u0002\u001b\u0003'B\u0001\"!\u0016\u0002N\u0001\u0007\u0011qK\u0001\u0006Kb$(/\u0019\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011Q\f\u0003\u0002\u000bA\f'/Y7\n\t\u0005\u0005\u00141\f\u0002\t!\u0006\u0014\u0018-\\'ba\"9\u0011Q\r\u0001\u0005R\u0005\u001d\u0014A\u0004:boJ\u0002(/\u001a3jGRLwN\u001c\u000b\u0004k\u0005%\u0004bBA\"\u0003G\u0002\rA\u0005\u0005\b\u0003[\u0002A\u0011KA8\u0003Y\u0001(o\u001c2bE&d\u0017\u000e^=3aJ,G-[2uS>tGcA\u001b\u0002r!9\u00111OA6\u0001\u0004\u0011\u0012a\u00039s_\n\f'-\u001b7jifD3\u0001AA<!\u0011\tI(a \u000e\u0005\u0005m$bAA?\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u00151\u0010\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements LogisticRegressionParams {
    private final String uid;
    private final Vector weights;
    private final double intercept;
    private final Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private final int numClasses;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public void validateParams() {
        LogisticRegressionParams$class.validateParams(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    public Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    private Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public LogisticRegressionTrainingSummary summary() {
        Option<LogisticRegressionTrainingSummary> option = this.trainingSummary();
        if (option instanceof Some) {
            LogisticRegressionTrainingSummary summ;
            Some some = (Some)option;
            LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = summ = (LogisticRegressionTrainingSummary)some.x();
            return logisticRegressionTrainingSummary;
        }
        None$ none$ = None$.MODULE$;
        Option<LogisticRegressionTrainingSummary> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new SparkException("No training summary available for this LogisticRegressionModel", (Throwable)new NullPointerException());
        }
        throw new MatchError(option);
    }

    public LogisticRegressionModel setSummary(LogisticRegressionTrainingSummary summary) {
        this.trainingSummary_$eq((Option<LogisticRegressionTrainingSummary>)new Some((Object)summary));
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LogisticRegressionSummary evaluate(DataFrame dataset) {
        return new BinaryLogisticRegressionSummary(this.transform(dataset), this.$(this.probabilityCol()), this.$(this.labelCol()));
    }

    @Override
    public double predict(Vector features) {
        return BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0;
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            int size = denseVector.size();
            for (int i = 0; i < size; ++i) {
                denseVector.values()[i] = 1.0 / (1.0 + package$.MODULE$.exp(-denseVector.values()[i]));
            }
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.weights(), this.intercept()), extra);
        Object object = this.trainingSummary().isDefined() ? newModel.setSummary((LogisticRegressionTrainingSummary)this.trainingSummary().get()) : BoxedUnit.UNIT;
        return (LogisticRegressionModel)newModel.setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double t = this.getThreshold();
        double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : package$.MODULE$.log(t / (1.0 - t)));
        return rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return probability.apply(1) > this.getThreshold() ? 1.0 : 0.0;
    }

    public LogisticRegressionModel(String uid, Vector weights2, double intercept) {
        this.uid = uid;
        this.weights = weights2;
        this.intercept = intercept;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin = new $anonfun$8(this);
        this.score = new $anonfun$9(this);
        this.numFeatures = weights2.size();
        this.numClasses = 2;
        this.trainingSummary = None$.MODULE$;
    }
}

