/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}tAB\u0001\u0003\u0011\u0003!a\"A\tTa\u0006\u00148nU)M\u00072KEI]5wKJT!a\u0001\u0003\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005\u00151\u0011\u0001\u00025jm\u0016T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h!\ty\u0001#D\u0001\u0003\r\u0019\t\"\u0001#\u0001\u0005%\t\t2\u000b]1sWN\u000bFj\u0011'J\tJLg/\u001a:\u0014\u0007A\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035ui\u0011a\u0007\u0006\u00039!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=m\u0011q\u0001T8hO&tw\rC\u0003!!\u0011\u0005!%\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0001b\u0002\u0013\u0011\u0001\u0004%I!J\u0001\u0007aJ|W\u000e\u001d;\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgn\u001a\u0005\b_A\u0001\r\u0011\"\u00031\u0003)\u0001(o\\7qi~#S-\u001d\u000b\u0003cQ\u0002\"\u0001\u0006\u001a\n\u0005M*\"\u0001B+oSRDq!\u000e\u0018\u0002\u0002\u0003\u0007a%A\u0002yIEBaa\u000e\t!B\u00131\u0013a\u00029s_6\u0004H\u000f\t\u0005\bsA\u0001\r\u0011\"\u0003;\u0003=\u0019wN\u001c;j]V,G\r\u0015:p[B$X#A\u001e\u0011\u0005qzdB\u0001\u000b>\u0013\tqT#\u0001\u0004Qe\u0016$WMZ\u0005\u0003[\u0001S!AP\u000b\t\u000f\t\u0003\u0002\u0019!C\u0005\u0007\u0006\u00192m\u001c8uS:,X\r\u001a)s_6\u0004Ho\u0018\u0013fcR\u0011\u0011\u0007\u0012\u0005\bk\u0005\u000b\t\u00111\u0001<\u0011\u00191\u0005\u0003)Q\u0005w\u0005\u00012m\u001c8uS:,X\r\u001a)s_6\u0004H\u000f\t\u0005\n\u0011B\u0001\r\u00111A\u0005\n%\u000b\u0011\u0002\u001e:b]N\u0004xN\u001d;\u0016\u0003)\u0003\"aS(\u000e\u00031S!\u0001S'\u000b\u00059S\u0011A\u0002;ie&4G/\u0003\u0002Q\u0019\n9AkU8dW\u0016$\b\"\u0003*\u0011\u0001\u0004\u0005\r\u0011\"\u0003T\u00035!(/\u00198ta>\u0014Ho\u0018\u0013fcR\u0011\u0011\u0007\u0016\u0005\bkE\u000b\t\u00111\u0001K\u0011\u00191\u0006\u0003)Q\u0005\u0015\u0006QAO]1ogB|'\u000f\u001e\u0011\t\u000ba\u0003B\u0011A-\u0002)%t7\u000f^1mYNKwM\\1m\u0011\u0006tG\r\\3s)\u0005\t\u0004\"B.\u0011\t\u0003a\u0016\u0001B7bS:$\"!M/\t\u000byS\u0006\u0019A0\u0002\t\u0005\u0014xm\u001d\t\u0004)\u0001\\\u0014BA1\u0016\u0005\u0015\t%O]1z\u0011\u0015\u0019\u0007\u0003\"\u0001e\u00031I7OU3n_R,Wj\u001c3f)\t)\u0007\u000e\u0005\u0002\u0015M&\u0011q-\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015I'\r1\u0001k\u0003\u0015\u0019H/\u0019;f!\tY\u0017/D\u0001m\u0015\tig.A\u0002dY&T!!B8\u000b\u0005AT\u0011A\u00025bI>|\u0007/\u0003\u0002sY\ny1\t\\5TKN\u001c\u0018n\u001c8Ti\u0006$XMB\u0003\u0012\u0005\u0001!AoE\u0002tkf\u0001\"a\u001b<\n\u0005]d'!C\"mS\u0012\u0013\u0018N^3s\u0011\u0015\u00013\u000f\"\u0001z)\u0005Q\bCA\bt\u0011\u001da8O1A\u0005\nu\fAb]3tg&|gn\u0015;bi\u0016,\u0012A\u001b\u0005\u0007\u007fN\u0004\u000b\u0011\u00026\u0002\u001bM,7o]5p]N#\u0018\r^3!\u0011%\t\u0019a\u001db\u0001\n\u0013\t)!A\u0002M\u001f\u001e+\"!a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u00059An\\4hS:<'bAA\t\u0015\u000591m\\7n_:\u001c\u0018\u0002BA\u000b\u0003\u0017\u00111\u0001T8h\u0011!\tIb\u001dQ\u0001\n\u0005\u001d\u0011\u0001\u0002'P\u000f\u0002B\u0011\"!\bt\u0005\u0004%I!a\b\u0002\u000f\r|gn]8mKV\u0011\u0011\u0011\u0005\t\u0005\u0003G\t\u0019D\u0004\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u000fM,7o]5p]*\u0019\u0011Q\u00068\u0002\u0005Ed\u0017\u0002BA\u0019\u0003O\tAbU3tg&|gn\u0015;bi\u0016LA!!\u000e\u00028\tIAj\\4IK2\u0004XM\u001d\u0006\u0005\u0003c\t9\u0003\u0003\u0005\u0002<M\u0004\u000b\u0011BA\u0011\u0003!\u0019wN\\:pY\u0016\u0004\u0003\u0002C2t\u0005\u0004%I!a\u0010\u0016\u0003\u0015Dq!a\u0011tA\u0003%Q-A\u0007jgJ+Wn\u001c;f\u001b>$W\r\t\u0005\n\u0003\u000f\u001a(\u0019!C\u0005\u0003\u0013\nAaY8oMV\u0011\u00111\n\t\u0005\u0003\u001b\n\t&\u0004\u0002\u0002P)\u0019\u0011qI8\n\t\u0005M\u0013q\n\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011\u0005]3\u000f)A\u0005\u0003\u0017\nQaY8oM\u0002Bq!a\u0017t\t\u0003\ni&\u0001\ttKRD\u0015N^3WCJL\u0017M\u00197fgR\u0019\u0011'a\u0018\t\u0011\u0005\u0005\u0014\u0011\fa\u0001\u0003G\nQ\u0002[5wKZ\u000b'/[1cY\u0016\u001c\bCBA3\u0003WZ4(\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e\u0016\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003[\n9GA\u0002NCBDq!!\u001dt\t\u0003\n\u0019(\u0001\u0006qe>\u001cWm]:D[\u0012$B!!\u001e\u0002|A\u0019A#a\u001e\n\u0007\u0005eTCA\u0002J]RDq!! \u0002p\u0001\u00071(A\u0002d[\u0012\u0004")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final Log LOG;
    private final SessionState.LogHelper console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    public static void main(String[] stringArray) {
        SparkSQLCLIDriver$.MODULE$.main(stringArray);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    private Log LOG() {
        return this.LOG;
    }

    private SessionState.LogHelper console() {
        return this.console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(hiveVariables).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> kv) {
                SparkSQLEnv$.MODULE$.sqlContext().conf().setConfString((String)kv._1(), (String)kv._2());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processCmd(String cmd) {
        String cmd_trimmed = cmd.trim();
        String cmd_lower = cmd_trimmed.toLowerCase(Locale.ENGLISH);
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
            this.sessionState().close();
            System.exit(0);
        }
        if (tokens[0].toLowerCase(Locale.ENGLISH).equals("source") || cmd_trimmed.startsWith("!") || this.isRemoteMode()) {
            long start = System.currentTimeMillis();
            super.processCmd(cmd);
            long end = System.currentTimeMillis();
            double timeTaken = (double)(end - start) / 1000.0;
            this.console().printInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)timeTaken)})));
            return 0;
        }
        int ret = 0;
        HiveConf hconf = (HiveConf)this.conf();
        CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
        if (proc != null) {
            if (!(proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof ResetProcessor)) {
                if (this.sessionState().getIsVerbose()) {
                    this.sessionState().out.println(new StringBuilder().append((Object)tokens[0]).append((Object)" ").append((Object)cmd_1).toString());
                }
                ret = proc.run(cmd_1).getResponseCode();
            } else {
                SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                driver.init();
                PrintStream out = this.sessionState().out;
                PrintStream err = this.sessionState().err;
                long start = System.currentTimeMillis();
                if (this.sessionState().getIsVerbose()) {
                    out.println(cmd);
                }
                CommandProcessorResponse rc = driver.run(cmd);
                long end = System.currentTimeMillis();
                double timeTaken = (double)(end - start) / 1000.0;
                ret = rc.getResponseCode();
                if (ret != 0) {
                    Throwable throwable = rc.getException();
                    if (throwable instanceof AnalysisException) {
                        AnalysisException analysisException = (AnalysisException)throwable;
                        err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analysisException.getMessage()})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        err.println(rc.getErrorMessage());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    driver.close();
                    return ret;
                }
                ArrayList res = new ArrayList();
                if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER)) {
                    Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1)new Serializable(this, out){
                        public static final long serialVersionUID = 0L;
                        private final PrintStream out$1;

                        public final void apply(List<FieldSchema> fields) {
                            this.out$1.println(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(FieldSchema x$1) {
                                    return x$1.getName();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).mkString("\t"));
                        }
                        {
                            this.out$1 = out$1;
                        }
                    });
                }
                IntRef counter = IntRef.create((int)0);
                try {
                    while (!out.checkError() && driver.getResults(res)) {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1)new Serializable(this, out, counter){
                            public static final long serialVersionUID = 0L;
                            private final PrintStream out$1;
                            private final IntRef counter$1;

                            public final void apply(String l) {
                                ++this.counter$1.elem;
                                this.out$1.println(l);
                            }
                            {
                                this.out$1 = out$1;
                                this.counter$1 = counter$1;
                            }
                        });
                        res.clear();
                    }
                }
                catch (IOException iOException) {
                    this.console().printError(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed with exception ", ": ", "\n                   |", "\n                 "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getClass().getName(), iOException.getMessage(), StringUtils.stringifyException((Throwable)iOException)})))).stripMargin());
                    ret = 1;
                }
                int cret = driver.close();
                if (ret == 0) {
                    ret = cret;
                }
                String responseMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)timeTaken)}));
                if (counter.elem != 0) {
                    responseMsg = new StringBuilder().append((Object)responseMsg).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", Fetched ", " row(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)counter.elem)}))).toString();
                }
                this.console().printInfo(responseMsg, null);
                driver.destroy();
            }
        }
        int n = ret;
        return n;
    }

    public SparkSQLCLIDriver() {
        Logging.class.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.LOG = LogFactory.getLog((String)"CliDriver");
        this.console = new SessionState.LogHelper(this.LOG());
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() == null ? new Configuration() : this.sessionState().getConf();
        if (this.isRemoteMode()) {
            throw new RuntimeException("Remote operations not supported");
        }
        SparkSQLEnv$.MODULE$.init();
    }
}

