/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hive.HiveSessionState;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService$class;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.server.SparkSQLOperationManager;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\u0001\u0003\u0001\u0011q!AF*qCJ\\7+\u0015'TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005\r!\u0011\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\u0003\u0007\u0003\u0011A\u0017N^3\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fi\u0001\"\u0001\u0005\r\u000e\u0003EQ!AE\n\u0002\u000fM,7o]5p]*\u0011A#F\u0001\u0004G2L'B\u0001\f\u0018\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0006\n\u0005e\t\"AD*fgNLwN\\'b]\u0006<WM\u001d\t\u00037qi\u0011AA\u0005\u0003;\t\u0011\u0011DU3gY\u0016\u001cG/\u001a3D_6\u0004xn]5uKN+'O^5dK\"Aq\u0004\u0001B\u0001B\u0003%\u0011%\u0001\u0006iSZ,7+\u001a:wKJ\u001c\u0001\u0001\u0005\u0002#K5\t1E\u0003\u0002%+\u000511/\u001a:wKJL!AJ\u0012\u0003\u0017!Kg/Z*feZ,'O\r\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005Q1/\u001d7D_:$X\r\u001f;\u0011\u0005)ZS\"\u0001\u0004\n\u000512!AC*R\u0019\u000e{g\u000e^3yi\")a\u0006\u0001C\u0001_\u00051A(\u001b8jiz\"2\u0001M\u00193!\tY\u0002\u0001C\u0003 [\u0001\u0007\u0011\u0005C\u0003)[\u0001\u0007\u0011\u0006\u0003\u00055\u0001!\u0015\r\u0011\"\u00036\u0003a\u0019\b/\u0019:l'Fdw\n]3sCRLwN\\'b]\u0006<WM]\u000b\u0002mA\u0011q'O\u0007\u0002q)\u0011AEA\u0005\u0003ua\u0012\u0001d\u00159be.\u001c\u0016\u000bT(qKJ\fG/[8o\u001b\u0006t\u0017mZ3s\u0011!a\u0004\u0001#A!B\u00131\u0014!G:qCJ\\7+\u001d7Pa\u0016\u0014\u0018\r^5p]6\u000bg.Y4fe\u0002BQA\u0010\u0001\u0005B}\nA!\u001b8jiR\u0011\u0001I\u0012\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0005+:LG\u000fC\u0003H{\u0001\u0007\u0001*\u0001\u0005iSZ,7i\u001c8g!\tIu*D\u0001K\u0015\tYE*\u0001\u0003d_:4'BA\u0003N\u0015\tq%\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003!*\u0013\u0001\u0002S5wK\u000e{gN\u001a\u0005\u0006%\u0002!\teU\u0001\f_B,gnU3tg&|g\u000e\u0006\u0005U1\u0002L7.\\<}!\t)f+D\u0001\u0014\u0013\t96CA\u0007TKN\u001c\u0018n\u001c8IC:$G.\u001a\u0005\u00063F\u0003\rAW\u0001\taJ|Go\\2pYB\u00111LX\u0007\u00029*\u0011QlE\u0001\u0007i\"\u0014\u0018N\u001a;\n\u0005}c&\u0001\u0005+Qe>$xnY8m-\u0016\u00148/[8o\u0011\u0015\t\u0017\u000b1\u0001c\u0003!)8/\u001a:oC6,\u0007CA2g\u001d\t\tE-\u0003\u0002f\u0005\u00061\u0001K]3eK\u001aL!a\u001a5\u0003\rM#(/\u001b8h\u0015\t)'\tC\u0003k#\u0002\u0007!-\u0001\u0004qCN\u001cx\u000f\u001a\u0005\u0006YF\u0003\rAY\u0001\nSB\fE\r\u001a:fgNDQA\\)A\u0002=\f1b]3tg&|gnQ8oMB!\u0001/\u001e2c\u001b\u0005\t(B\u0001:t\u0003\u0011)H/\u001b7\u000b\u0003Q\fAA[1wC&\u0011a/\u001d\u0002\u0004\u001b\u0006\u0004\b\"\u0002=R\u0001\u0004I\u0018!E<ji\"LU\u000e]3sg>t\u0017\r^5p]B\u0011\u0011I_\u0005\u0003w\n\u0013qAQ8pY\u0016\fg\u000eC\u0003~#\u0002\u0007!-A\beK2,w-\u0019;j_:$vn[3o\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005a1\r\\8tKN+7o]5p]R\u0019\u0001)a\u0001\t\r\u0005\u0015a\u00101\u0001U\u00035\u0019Xm]:j_:D\u0015M\u001c3mK\u0002")
public class SparkSQLSessionManager
extends SessionManager
implements ReflectedCompositeService {
    private final SQLContext sqlContext;
    private SparkSQLOperationManager sparkSqlOperationManager;
    private volatile boolean bitmap$0;

    private SparkSQLOperationManager sparkSqlOperationManager$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if (!this.bitmap$0) {
                this.sparkSqlOperationManager = new SparkSQLOperationManager();
                this.bitmap$0 = true;
            }
            return this.sparkSqlOperationManager;
        }
    }

    @Override
    public void initCompositeService(HiveConf hiveConf) {
        ReflectedCompositeService$class.initCompositeService(this, hiveConf);
    }

    private SparkSQLOperationManager sparkSqlOperationManager() {
        return this.bitmap$0 ? this.sparkSqlOperationManager : this.sparkSqlOperationManager$lzycompute();
    }

    @Override
    public void init(HiveConf hiveConf) {
        ReflectionUtils$.MODULE$.setSuperField(this, "hiveConf", hiveConf);
        Object object = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED) ? ReflectionUtils$.MODULE$.invoke(SessionManager.class, this, "initOperationLogRootDir", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])) : BoxedUnit.UNIT;
        int backgroundPoolSize = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS);
        ReflectionUtils$.MODULE$.setSuperField(this, "backgroundOperationPool", Executors.newFixedThreadPool(backgroundPoolSize));
        ((Log)ReflectionUtils$.MODULE$.getAncestorField(this, 3, "LOG")).info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HiveServer2: Async execution pool size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)backgroundPoolSize)})));
        ReflectionUtils$.MODULE$.setSuperField(this, "operationManager", this.sparkSqlOperationManager());
        this.addService(this.sparkSqlOperationManager());
        this.initCompositeService(hiveConf);
    }

    @Override
    public SessionHandle openSession(TProtocolVersion protocol, String username, String passwd, String ipAddress, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) {
        SessionHandle sessionHandle = super.openSession(protocol, username, passwd, ipAddress, sessionConf, withImpersonation, delegationToken);
        HiveSession session = super.getSession(sessionHandle);
        HiveThriftServer2$.MODULE$.listener().onSessionCreated(session.getIpAddress(), sessionHandle.getSessionId().toString(), session.getUsername());
        HiveSessionState sessionState = (HiveSessionState)this.sqlContext.sessionState();
        SQLContext ctx = sessionState.hiveThriftServerSingleSession() ? this.sqlContext : this.sqlContext.newSession();
        ctx.setConf("spark.sql.hive.version", HiveUtils$.MODULE$.hiveExecutionVersion());
        this.sparkSqlOperationManager().sessionToContexts().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sessionHandle), (Object)ctx));
        return sessionHandle;
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) {
        HiveThriftServer2$.MODULE$.listener().onSessionClosed(sessionHandle.getSessionId().toString());
        super.closeSession(sessionHandle);
        this.sparkSqlOperationManager().sessionToActivePool().$minus$eq((Object)sessionHandle);
        this.sparkSqlOperationManager().sessionToContexts().remove((Object)sessionHandle);
    }

    public SparkSQLSessionManager(HiveServer2 hiveServer, SQLContext sqlContext) {
        this.sqlContext = sqlContext;
        super(hiveServer);
        ReflectedCompositeService$class.$init$(this);
    }
}

