/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.Service;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.sql.hive.HiveContext;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService$class;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLSessionManager;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3Q!\u0001\u0002\u0001\t9\u0011!c\u00159be.\u001c\u0016\u000bT\"M\u0013N+'O^5dK*\u00111\u0001B\u0001\ri\"\u0014\u0018N\u001a;tKJ4XM\u001d\u0006\u0003\u000b\u0019\tA\u0001[5wK*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0014\u0007\u0001y\u0001\u0004\u0005\u0002\u0011-5\t\u0011C\u0003\u0002\u0013'\u0005\u00191\r\\5\u000b\u0005Q)\u0012aB:feZL7-\u001a\u0006\u0003\u000b)I!aF\t\u0003\u0015\rc\u0015jU3sm&\u001cW\r\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\tI\"+\u001a4mK\u000e$X\rZ\"p[B|7/\u001b;f'\u0016\u0014h/[2f\u0011!i\u0002A!A!\u0002\u0013y\u0012A\u00035jm\u0016\u001cVM\u001d<fe\u000e\u0001\u0001C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0014\u0003\u0019\u0019XM\u001d<fe&\u0011A%\t\u0002\f\u0011&4XmU3sm\u0016\u0014(\u0007\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003-A\u0017N^3D_:$X\r\u001f;\u0011\u0005!JS\"\u0001\u0003\n\u0005)\"!a\u0003%jm\u0016\u001cuN\u001c;fqRDQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtDc\u0001\u00180aA\u0011\u0011\u0004\u0001\u0005\u0006;-\u0002\ra\b\u0005\u0006M-\u0002\ra\n\u0005\u0006e\u0001!\teM\u0001\u0005S:LG\u000f\u0006\u00025uA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t!QK\\5u\u0011\u0015Y\u0014\u00071\u0001=\u0003!A\u0017N^3D_:4\u0007CA\u001fD\u001b\u0005q$BA A\u0003\u0011\u0019wN\u001c4\u000b\u0005\u0015\t%B\u0001\"\u000b\u0003\u0019A\u0017\rZ8pa&\u0011AI\u0010\u0002\t\u0011&4XmQ8oM\")a\t\u0001C!\u000f\u00069q-\u001a;J]\u001a|Gc\u0001%L!B\u0011\u0001#S\u0005\u0003\u0015F\u0011AbR3u\u0013:4wNV1mk\u0016DQ\u0001T#A\u00025\u000bQb]3tg&|g\u000eS1oI2,\u0007C\u0001\tO\u0013\ty\u0015CA\u0007TKN\u001c\u0018n\u001c8IC:$G.\u001a\u0005\u0006#\u0016\u0003\rAU\u0001\fO\u0016$\u0018J\u001c4p)f\u0004X\r\u0005\u0002\u0011'&\u0011A+\u0005\u0002\f\u000f\u0016$\u0018J\u001c4p)f\u0004X\r")
public class SparkSQLCLIService
extends CLIService
implements ReflectedCompositeService {
    private final HiveServer2 hiveServer;
    private final HiveContext hiveContext;

    @Override
    public void initCompositeService(HiveConf hiveConf) {
        ReflectedCompositeService$class.initCompositeService((AbstractService)this, hiveConf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(HiveConf hiveConf) {
        ReflectionUtils$.MODULE$.setSuperField(this, "hiveConf", hiveConf);
        SparkSQLSessionManager sparkSqlSessionManager = new SparkSQLSessionManager(this.hiveServer, this.hiveContext);
        ReflectionUtils$.MODULE$.setSuperField(this, "sessionManager", sparkSqlSessionManager);
        this.addService((Service)sparkSqlSessionManager);
        UserGroupInformation sparkServiceUGI = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            try {
                HiveAuthFactory.loginFromKeytab((HiveConf)hiveConf);
                sparkServiceUGI = Utils.getUGI();
                ReflectionUtils$.MODULE$.setSuperField(this, "serviceUGI", sparkServiceUGI);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof LoginException;
                if (bl) {
                    throw new ServiceException("Unable to login to kerberos with given principal/keytab", throwable2);
                }
                throw throwable;
            }
        }
        this.initCompositeService(hiveConf);
    }

    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType getInfoType) {
        GetInfoValue getInfoValue;
        GetInfoType getInfoType2 = getInfoType;
        GetInfoType getInfoType3 = GetInfoType.CLI_SERVER_NAME;
        GetInfoType getInfoType4 = getInfoType2;
        if (!(getInfoType3 != null ? !getInfoType3.equals(getInfoType4) : getInfoType4 != null)) {
            getInfoValue = new GetInfoValue("Spark SQL");
        } else {
            GetInfoType getInfoType5 = GetInfoType.CLI_DBMS_NAME;
            GetInfoType getInfoType6 = getInfoType2;
            if (!(getInfoType5 != null ? !getInfoType5.equals(getInfoType6) : getInfoType6 != null)) {
                getInfoValue = new GetInfoValue("Spark SQL");
            } else {
                GetInfoType getInfoType7 = GetInfoType.CLI_DBMS_VER;
                GetInfoType getInfoType8 = getInfoType2;
                getInfoValue = !(getInfoType7 != null ? !getInfoType7.equals(getInfoType8) : getInfoType8 != null) ? new GetInfoValue(this.hiveContext.sparkContext().version()) : super.getInfo(sessionHandle, getInfoType);
            }
        }
        return getInfoValue;
    }

    public SparkSQLCLIService(HiveServer2 hiveServer, HiveContext hiveContext) {
        this.hiveServer = hiveServer;
        this.hiveContext = hiveContext;
        super(hiveServer);
        ReflectedCompositeService$class.$init$((AbstractService)this);
    }
}

