/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.Service;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.sql.hive.HiveContext;
import org.apache.spark.sql.hive.HiveContext$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService$class;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.server.SparkSQLOperationManager;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\u0001\u0003\u0001\u0011q!AF*qCJ\\7+\u0015'TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005\r!\u0011\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\u0003\u0007\u0003\u0011A\u0017N^3\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fi\u0001\"\u0001\u0005\r\u000e\u0003EQ!AE\n\u0002\u000fM,7o]5p]*\u0011A#F\u0001\u0004G2L'B\u0001\f\u0018\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0006\n\u0005e\t\"AD*fgNLwN\\'b]\u0006<WM\u001d\t\u00037qi\u0011AA\u0005\u0003;\t\u0011\u0011DU3gY\u0016\u001cG/\u001a3D_6\u0004xn]5uKN+'O^5dK\"Aq\u0004\u0001B\u0001B\u0003%\u0011%\u0001\u0006iSZ,7+\u001a:wKJ\u001c\u0001\u0001\u0005\u0002#K5\t1E\u0003\u0002%+\u000511/\u001a:wKJL!AJ\u0012\u0003\u0017!Kg/Z*feZ,'O\r\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005Y\u0001.\u001b<f\u0007>tG/\u001a=u!\tQ3&D\u0001\u0005\u0013\taCAA\u0006ISZ,7i\u001c8uKb$\b\"\u0002\u0018\u0001\t\u0003y\u0013A\u0002\u001fj]&$h\bF\u00021cI\u0002\"a\u0007\u0001\t\u000b}i\u0003\u0019A\u0011\t\u000b!j\u0003\u0019A\u0015\t\u0011Q\u0002\u0001R1A\u0005\nU\n\u0001d\u001d9be.\u001c\u0016\u000f\\(qKJ\fG/[8o\u001b\u0006t\u0017mZ3s+\u00051\u0004CA\u001c:\u001b\u0005A$B\u0001\u0013\u0003\u0013\tQ\u0004H\u0001\rTa\u0006\u00148nU)M\u001fB,'/\u0019;j_:l\u0015M\\1hKJD\u0001\u0002\u0010\u0001\t\u0002\u0003\u0006KAN\u0001\u001agB\f'o[*rY>\u0003XM]1uS>tW*\u00198bO\u0016\u0014\b\u0005C\u0003?\u0001\u0011\u0005s(\u0001\u0003j]&$HC\u0001!G!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0011)f.\u001b;\t\u000b\u001dk\u0004\u0019\u0001%\u0002\u0011!Lg/Z\"p]\u001a\u0004\"!S(\u000e\u0003)S!a\u0013'\u0002\t\r|gN\u001a\u0006\u0003\u000b5S!A\u0014\u0006\u0002\r!\fGm\\8q\u0013\t\u0001&J\u0001\u0005ISZ,7i\u001c8g\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003-y\u0007/\u001a8TKN\u001c\u0018n\u001c8\u0015\u0011QC\u0006-[6nor\u0004\"!\u0016,\u000e\u0003MI!aV\n\u0003\u001bM+7o]5p]\"\u000bg\u000e\u001a7f\u0011\u0015I\u0016\u000b1\u0001[\u0003!\u0001(o\u001c;pG>d\u0007CA._\u001b\u0005a&BA/\u0014\u0003\u0019!\bN]5gi&\u0011q\f\u0018\u0002\u0011)B\u0013x\u000e^8d_24VM]:j_:DQ!Y)A\u0002\t\f\u0001\"^:fe:\fW.\u001a\t\u0003G\u001at!!\u00113\n\u0005\u0015\u0014\u0015A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!\u001a\"\t\u000b)\f\u0006\u0019\u00012\u0002\rA\f7o]<e\u0011\u0015a\u0017\u000b1\u0001c\u0003%I\u0007/\u00113ee\u0016\u001c8\u000fC\u0003o#\u0002\u0007q.A\u0006tKN\u001c\u0018n\u001c8D_:4\u0007\u0003\u00029vE\nl\u0011!\u001d\u0006\u0003eN\fA!\u001e;jY*\tA/\u0001\u0003kCZ\f\u0017B\u0001<r\u0005\ri\u0015\r\u001d\u0005\u0006qF\u0003\r!_\u0001\u0012o&$\b.S7qKJ\u001cxN\\1uS>t\u0007CA!{\u0013\tY(IA\u0004C_>dW-\u00198\t\u000bu\f\u0006\u0019\u00012\u0002\u001f\u0011,G.Z4bi&|g\u000eV8lK:Daa \u0001\u0005B\u0005\u0005\u0011\u0001D2m_N,7+Z:tS>tGc\u0001!\u0002\u0004!1\u0011Q\u0001@A\u0002Q\u000bQb]3tg&|g\u000eS1oI2,\u0007")
public class SparkSQLSessionManager
extends SessionManager
implements ReflectedCompositeService {
    private final HiveContext hiveContext;
    private SparkSQLOperationManager sparkSqlOperationManager;
    private volatile boolean bitmap$0;

    private SparkSQLOperationManager sparkSqlOperationManager$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if (!this.bitmap$0) {
                this.sparkSqlOperationManager = new SparkSQLOperationManager();
                this.bitmap$0 = true;
            }
            return this.sparkSqlOperationManager;
        }
    }

    @Override
    public void initCompositeService(HiveConf hiveConf) {
        ReflectedCompositeService$class.initCompositeService((AbstractService)this, hiveConf);
    }

    private SparkSQLOperationManager sparkSqlOperationManager() {
        return this.bitmap$0 ? this.sparkSqlOperationManager : this.sparkSqlOperationManager$lzycompute();
    }

    public void init(HiveConf hiveConf) {
        ReflectionUtils$.MODULE$.setSuperField(this, "hiveConf", hiveConf);
        Object object = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED) ? ReflectionUtils$.MODULE$.invoke(SessionManager.class, this, "initOperationLogRootDir", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])) : BoxedUnit.UNIT;
        int backgroundPoolSize = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS);
        ReflectionUtils$.MODULE$.setSuperField(this, "backgroundOperationPool", Executors.newFixedThreadPool(backgroundPoolSize));
        ((Log)ReflectionUtils$.MODULE$.getAncestorField(this, 3, "LOG")).info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HiveServer2: Async execution pool size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)backgroundPoolSize)})));
        ReflectionUtils$.MODULE$.setSuperField(this, "operationManager", (Object)this.sparkSqlOperationManager());
        this.addService((Service)this.sparkSqlOperationManager());
        this.initCompositeService(hiveConf);
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String passwd, String ipAddress, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) {
        SessionHandle sessionHandle = super.openSession(protocol, username, passwd, ipAddress, sessionConf, withImpersonation, delegationToken);
        HiveSession session = super.getSession(sessionHandle);
        HiveThriftServer2$.MODULE$.listener().onSessionCreated(session.getIpAddress(), sessionHandle.getSessionId().toString(), session.getUsername());
        HiveContext ctx = this.hiveContext.hiveThriftServerSingleSession() ? this.hiveContext : this.hiveContext.newSession();
        ctx.setConf("spark.sql.hive.version", HiveContext$.MODULE$.hiveExecutionVersion());
        this.sparkSqlOperationManager().sessionToContexts().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)sessionHandle), (Object)ctx));
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        HiveThriftServer2$.MODULE$.listener().onSessionClosed(sessionHandle.getSessionId().toString());
        super.closeSession(sessionHandle);
        this.sparkSqlOperationManager().sessionToActivePool().$minus$eq((Object)sessionHandle);
        this.sparkSqlOperationManager().sessionToContexts().remove((Object)sessionHandle);
    }

    public SparkSQLSessionManager(HiveServer2 hiveServer, HiveContext hiveContext) {
        this.hiveContext = hiveContext;
        super(hiveServer);
        ReflectedCompositeService$class.$init$((AbstractService)this);
    }
}

