/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015tAB\u0001\u0003\u0011\u0003!a\"A\tTa\u0006\u00148nU)M\u00072KEI]5wKJT!a\u0001\u0003\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005\u00151\u0011\u0001\u00025jm\u0016T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h!\ty\u0001#D\u0001\u0003\r\u0019\t\"\u0001#\u0001\u0005%\t\t2\u000b]1sWN\u000bFj\u0011'J\tJLg/\u001a:\u0014\u0007A\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035mi\u0011\u0001C\u0005\u00039!\u0011q\u0001T8hO&tw\rC\u0003\u001f!\u0011\u0005\u0001%\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0001b\u0002\u0012\u0011\u0001\u0004%IaI\u0001\u0007aJ|W\u000e\u001d;\u0016\u0003\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004TiJLgn\u001a\u0005\b[A\u0001\r\u0011\"\u0003/\u0003)\u0001(o\\7qi~#S-\u001d\u000b\u0003_I\u0002\"\u0001\u0006\u0019\n\u0005E*\"\u0001B+oSRDqa\r\u0017\u0002\u0002\u0003\u0007A%A\u0002yIEBa!\u000e\t!B\u0013!\u0013a\u00029s_6\u0004H\u000f\t\u0005\boA\u0001\r\u0011\"\u00039\u0003=\u0019wN\u001c;j]V,G\r\u0015:p[B$X#A\u001d\u0011\u0005ijdB\u0001\u000b<\u0013\taT#\u0001\u0004Qe\u0016$WMZ\u0005\u0003WyR!\u0001P\u000b\t\u000f\u0001\u0003\u0002\u0019!C\u0005\u0003\u0006\u00192m\u001c8uS:,X\r\u001a)s_6\u0004Ho\u0018\u0013fcR\u0011qF\u0011\u0005\bg}\n\t\u00111\u0001:\u0011\u0019!\u0005\u0003)Q\u0005s\u0005\u00012m\u001c8uS:,X\r\u001a)s_6\u0004H\u000f\t\u0005\n\rB\u0001\r\u00111A\u0005\n\u001d\u000b\u0011\u0002\u001e:b]N\u0004xN\u001d;\u0016\u0003!\u0003\"!S'\u000e\u0003)S!AR&\u000b\u00051S\u0011A\u0002;ie&4G/\u0003\u0002O\u0015\n9AkU8dW\u0016$\b\"\u0003)\u0011\u0001\u0004\u0005\r\u0011\"\u0003R\u00035!(/\u00198ta>\u0014Ho\u0018\u0013fcR\u0011qF\u0015\u0005\bg=\u000b\t\u00111\u0001I\u0011\u0019!\u0006\u0003)Q\u0005\u0011\u0006QAO]1ogB|'\u000f\u001e\u0011\t\u000bY\u0003B\u0011A,\u0002)%t7\u000f^1mYNKwM\\1m\u0011\u0006tG\r\\3s)\u0005y\u0003\"B-\u0011\t\u0003Q\u0016\u0001B7bS:$\"aL.\t\u000bqC\u0006\u0019A/\u0002\t\u0005\u0014xm\u001d\t\u0004)yK\u0014BA0\u0016\u0005\u0015\t%O]1z\u0011\u0015\t\u0007\u0003\"\u0001c\u00031I7OU3n_R,Wj\u001c3f)\t\u0019g\r\u0005\u0002\u0015I&\u0011Q-\u0006\u0002\b\u0005>|G.Z1o\u0011\u00159\u0007\r1\u0001i\u0003\u0015\u0019H/\u0019;f!\tIw.D\u0001k\u0015\tYG.A\u0002dY&T!!B7\u000b\u00059T\u0011A\u00025bI>|\u0007/\u0003\u0002qU\ny1\t\\5TKN\u001c\u0018n\u001c8Ti\u0006$XMB\u0003\u0012\u0005\u0001!!oE\u0002rgf\u0001\"!\u001b;\n\u0005UT'!C\"mS\u0012\u0013\u0018N^3s\u0011\u0015q\u0012\u000f\"\u0001x)\u0005A\bCA\br\u0011\u001dQ\u0018O1A\u0005\nm\fAb]3tg&|gn\u0015;bi\u0016,\u0012\u0001\u001b\u0005\u0007{F\u0004\u000b\u0011\u00025\u0002\u001bM,7o]5p]N#\u0018\r^3!\u0011!y\u0018O1A\u0005\n\u0005\u0005\u0011a\u0001'P\u000fV\u0011\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u001dawnZ4j]\u001eT1!!\u0004\u000b\u0003\u001d\u0019w.\\7p]NLA!!\u0005\u0002\b\t\u0019Aj\\4\t\u0011\u0005U\u0011\u000f)A\u0005\u0003\u0007\tA\u0001T(HA!I\u0011\u0011D9C\u0002\u0013%\u00111D\u0001\bG>t7o\u001c7f+\t\ti\u0002\u0005\u0003\u0002 \u0005=b\u0002BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\bg\u0016\u001c8/[8o\u0015\r\tI\u0003\\\u0001\u0003c2LA!!\f\u0002$\u0005a1+Z:tS>t7\u000b^1uK&!\u0011\u0011GA\u001a\u0005%aun\u001a%fYB,'O\u0003\u0003\u0002.\u0005\r\u0002\u0002CA\u001cc\u0002\u0006I!!\b\u0002\u0011\r|gn]8mK\u0002B\u0001\"Y9C\u0002\u0013%\u00111H\u000b\u0002G\"9\u0011qH9!\u0002\u0013\u0019\u0017!D5t%\u0016lw\u000e^3N_\u0012,\u0007\u0005C\u0005\u0002DE\u0014\r\u0011\"\u0003\u0002F\u0005!1m\u001c8g+\t\t9\u0005\u0005\u0003\u0002J\u00055SBAA&\u0015\r\t\u0019%\\\u0005\u0005\u0003\u001f\nYEA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\t\u0003'\n\b\u0015!\u0003\u0002H\u0005)1m\u001c8gA!9\u0011qK9\u0005B\u0005e\u0013A\u00039s_\u000e,7o]\"nIR!\u00111LA1!\r!\u0012QL\u0005\u0004\u0003?*\"aA%oi\"9\u00111MA+\u0001\u0004I\u0014aA2nI\u0002")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final Log LOG;
    private final SessionState.LogHelper console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        SparkSQLCLIDriver$.MODULE$.main(stringArray);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    private Log LOG() {
        return this.LOG;
    }

    private SessionState.LogHelper console() {
        return this.console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processCmd(String cmd) {
        String cmd_trimmed = cmd.trim();
        String cmd_lower = cmd_trimmed.toLowerCase(Locale.ENGLISH);
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        if (cmd_lower.equals("quit") || cmd_lower.equals("exit") || tokens[0].toLowerCase(Locale.ENGLISH).equals("source") || cmd_trimmed.startsWith("!") || tokens[0].toLowerCase().equals("list") || this.isRemoteMode()) {
            long start = System.currentTimeMillis();
            super.processCmd(cmd);
            long end = System.currentTimeMillis();
            double timeTaken = (double)(end - start) / 1000.0;
            this.console().printInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)timeTaken)})));
            return 0;
        }
        int ret = 0;
        HiveConf hconf = (HiveConf)this.conf();
        CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
        if (proc != null) {
            if (!(proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor)) {
                if (this.sessionState().getIsVerbose()) {
                    this.sessionState().out.println(new StringBuilder().append((Object)tokens[0]).append((Object)" ").append((Object)cmd_1).toString());
                }
                ret = proc.run(cmd_1).getResponseCode();
            } else {
                SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                driver.init();
                PrintStream out = this.sessionState().out;
                PrintStream err = this.sessionState().err;
                long start = System.currentTimeMillis();
                if (this.sessionState().getIsVerbose()) {
                    out.println(cmd);
                }
                CommandProcessorResponse rc = driver.run(cmd);
                long end = System.currentTimeMillis();
                double timeTaken = (double)(end - start) / 1000.0;
                ret = rc.getResponseCode();
                if (ret != 0) {
                    Throwable throwable = rc.getException();
                    if (throwable instanceof AnalysisException) {
                        AnalysisException analysisException = (AnalysisException)throwable;
                        err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analysisException.getMessage()})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        err.println(rc.getErrorMessage());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    driver.close();
                    return ret;
                }
                ArrayList res = new ArrayList();
                if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER)) {
                    Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1)new Serializable(this, out){
                        public static final long serialVersionUID = 0L;
                        private final PrintStream out$1;

                        public final void apply(List<FieldSchema> fields) {
                            this.out$1.println(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(FieldSchema x$1) {
                                    return x$1.getName();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).mkString("\t"));
                        }
                        {
                            this.out$1 = out$1;
                        }
                    });
                }
                IntRef counter = new IntRef(0);
                try {
                    while (!out.checkError() && driver.getResults(res)) {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1)new Serializable(this, out, counter){
                            public static final long serialVersionUID = 0L;
                            private final PrintStream out$1;
                            private final IntRef counter$1;

                            public final void apply(String l) {
                                ++this.counter$1.elem;
                                this.out$1.println(l);
                            }
                            {
                                this.out$1 = out$1;
                                this.counter$1 = counter$1;
                            }
                        });
                        res.clear();
                    }
                }
                catch (IOException iOException) {
                    this.console().printError(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed with exception ", ": ", "\n                   |", "\n                 "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getClass().getName(), iOException.getMessage(), StringUtils.stringifyException((Throwable)iOException)})))).stripMargin());
                    ret = 1;
                }
                int cret = driver.close();
                if (ret == 0) {
                    ret = cret;
                }
                String responseMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)timeTaken)}));
                if (counter.elem != 0) {
                    responseMsg = new StringBuilder().append((Object)responseMsg).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", Fetched ", " row(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)counter.elem)}))).toString();
                }
                this.console().printInfo(responseMsg, null);
                driver.destroy();
            }
        }
        int n = ret;
        return n;
    }

    public SparkSQLCLIDriver() {
        Logging.class.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.LOG = LogFactory.getLog((String)"CliDriver");
        this.console = new SessionState.LogHelper(this.LOG());
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() == null ? new Configuration() : this.sessionState().getConf();
        if (this.isRemoteMode()) {
            throw new RuntimeException("Remote operations not supported");
        }
        SparkSQLEnv$.MODULE$.init();
    }
}

