/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.common.HiveInterruptCallback;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.spark.Logging;
import org.apache.spark.sql.hive.HiveContext$;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.thrift.transport.TSocket;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkSQLCLIDriver$
implements Logging {
    public static final SparkSQLCLIDriver$ MODULE$;
    private String prompt;
    private String continuedPrompt;
    private TSocket org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new SparkSQLCLIDriver$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private String prompt() {
        return this.prompt;
    }

    private void prompt_$eq(String x$1) {
        this.prompt = x$1;
    }

    private String continuedPrompt() {
        return this.continuedPrompt;
    }

    private void continuedPrompt_$eq(String x$1) {
        this.continuedPrompt = x$1;
    }

    public TSocket org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport;
    }

    private void org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport_$eq(TSocket x$1) {
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport = x$1;
    }

    public void installSignalHandler() {
        HiveInterruptUtils.add((HiveInterruptCallback)new HiveInterruptCallback(){

            public void interrupt() {
                if (SparkSQLEnv$.MODULE$.sparkContext() == null) {
                    if (SparkSQLCLIDriver$.MODULE$.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport() != null) {
                        SparkSQLCLIDriver$.MODULE$.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport().getSocket().close();
                    }
                } else {
                    SparkSQLEnv$.MODULE$.sparkContext().cancelAllJobs();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        OptionsProcessor oproc = new OptionsProcessor();
        if (!oproc.process_stage1(args)) {
            System.exit(1);
        }
        HiveConf cliConf = new HiveConf(SessionState.class);
        HiveContext$.MODULE$.newTemporaryConfiguration().foreach((Function1)new Serializable(cliConf){
            public static final long serialVersionUID = 0L;
            private final HiveConf cliConf$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.cliConf$1.set(key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.cliConf$1 = cliConf$1;
            }
        });
        CliSessionState sessionState = new CliSessionState(cliConf);
        sessionState.in = System.in;
        try {
            sessionState.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            sessionState.info = new PrintStream((OutputStream)System.err, true, "UTF-8");
            sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.exit(3);
        }
        if (!oproc.process_stage2(sessionState)) {
            System.exit(2);
        }
        HiveConf conf = sessionState.getConf();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(sessionState.cmdProperties.entrySet()).asScala()).foreach((Function1)new Serializable(sessionState, conf){
            public static final long serialVersionUID = 0L;
            private final CliSessionState sessionState$1;
            private final HiveConf conf$1;

            public final Object apply(Map.Entry<Object, Object> item) {
                Object object;
                String key = item.getKey().toString();
                String value = item.getValue().toString();
                String string = key;
                String string2 = "javax.jdo.option.ConnectionURL";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    object = BoxedUnit.UNIT;
                } else {
                    this.conf$1.set(key, value);
                    object = this.sessionState$1.getOverriddenConfigurations().put(key, value);
                }
                return object;
            }
            {
                this.sessionState$1 = sessionState$1;
                this.conf$1 = conf$1;
            }
        });
        SessionState.start((SessionState)sessionState);
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkSQLEnv$.MODULE$.stop();
            }
        });
        boolean remoteMode = this.isRemoteMode(sessionState);
        if (remoteMode) {
            throw new RuntimeException("Remote operations not supported");
        }
        ClassLoader loader = conf.getClassLoader();
        String auxJars = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
        if (StringUtils.isNotBlank((CharSequence)auxJars)) {
            loader = Utilities.addToClassPath((ClassLoader)loader, (String[])StringUtils.split((String)auxJars, (String)","));
        }
        conf.setClassLoader(loader);
        Thread.currentThread().setContextClassLoader(loader);
        SparkSQLCLIDriver cli = new SparkSQLCLIDriver();
        cli.setHiveVariables(oproc.getHiveVariables());
        sessionState.in = System.in;
        try {
            sessionState.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            sessionState.info = new PrintStream((OutputStream)System.err, true, "UTF-8");
            sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.exit(3);
        }
        Object object = sessionState.database == null ? BoxedUnit.UNIT : SparkSQLEnv$.MODULE$.hiveContext().runSqlHive(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sessionState.database})));
        cli.processInitFiles(sessionState);
        if (sessionState.execString != null) {
            System.exit(cli.processLine(sessionState.execString));
        }
        try {
            if (sessionState.fileName != null) {
                System.exit(cli.processFile(sessionState.fileName));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logError((Function0<String>)new Serializable(fileNotFoundException){
                public static final long serialVersionUID = 0L;
                private final FileNotFoundException e$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not open input file for reading. (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage()}));
                }
                {
                    this.e$1 = e$1;
                }
            });
            System.exit(3);
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setBellEnabled(false);
        reader.setExpandEvents(false);
        Predef$.MODULE$.refArrayOps((Object[])CliDriver.getCommandCompleter()).foreach((Function1)new Serializable(reader){
            public static final long serialVersionUID = 0L;
            private final ConsoleReader reader$1;

            public final boolean apply(Completer e) {
                return this.reader$1.addCompleter(e);
            }
            {
                this.reader$1 = reader$1;
            }
        });
        String historyDirectory = System.getProperty("user.home");
        try {
            if (new File(historyDirectory).exists()) {
                String historyFile = new StringBuilder().append((Object)historyDirectory).append((Object)File.separator).append((Object)".hivehistory").toString();
                reader.setHistory((History)new FileHistory(new File(historyFile)));
            } else {
                this.logWarning((Function0<String>)new Serializable(historyDirectory){
                    public static final long serialVersionUID = 0L;
                    private final String historyDirectory$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"WARNING: Directory for Hive history file: ").append((Object)this.historyDirectory$1).append((Object)" does not exist.   History will not be available during this session.").toString();
                    }
                    {
                        this.historyDirectory$1 = historyDirectory$1;
                    }
                });
            }
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "WARNING: Encountered an error while trying to initialize Hive's history file.  History will not be available during this session.";
                }
            });
            this.logWarning((Function0<String>)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$2;

                public final String apply() {
                    return this.e$2.getMessage();
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport_$eq(null);
        int ret = 0;
        String prefix = "";
        Object currentDB = ReflectionUtils$.MODULE$.invokeStatic(CliDriver.class, "getFormattedDb", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(HiveConf.class), (Object)conf), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(CliSessionState.class), (Object)sessionState)}));
        String currentPrompt = this.promptWithCurrentDB$1(currentDB);
        String line = reader.readLine(new StringBuilder().append((Object)currentPrompt).append((Object)"> ").toString());
        while (true) {
            void var13_13;
            String string;
            String string2;
            if (line == null) {
                sessionState.close();
                System.exit(ret);
                return;
            }
            if (!string2.startsWith("--")) {
                void var19_19;
                String string3;
                if (new StringOps(Predef$.MODULE$.augmentString(string3)).nonEmpty()) {
                    string3 = new StringBuilder().append((Object)string3).append((Object)BoxesRunTime.boxToCharacter((char)'\n')).toString();
                }
                if (string2.trim().endsWith(";") && !string2.trim().endsWith("\\;")) {
                    void var10_10;
                    string2 = new StringBuilder().append((Object)string3).append((Object)string2).toString();
                    int n = var10_10.processLine(string2, true);
                    string3 = "";
                    string = this.promptWithCurrentDB$1(var19_19);
                } else {
                    string3 = new StringBuilder().append((Object)string3).append((Object)string2).toString();
                    string = this.continuedPromptWithDBSpaces$1(var19_19);
                }
            }
            string2 = var13_13.readLine(new StringBuilder().append((Object)string).append((Object)"> ").toString());
        }
    }

    public boolean isRemoteMode(CliSessionState state) {
        return state.isHiveServerQuery();
    }

    private final String promptWithCurrentDB$1(Object currentDB$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prompt(), currentDB$1}));
    }

    private final String continuedPromptWithDBSpaces$1(Object currentDB$1) {
        return new StringBuilder().append((Object)this.continuedPrompt()).append(ReflectionUtils$.MODULE$.invokeStatic(CliDriver.class, "spacesForString", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(String.class), currentDB$1)}))).toString();
    }

    private SparkSQLCLIDriver$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.prompt = "spark-sql";
        this.continuedPrompt = (String)new StringOps(Predef$.MODULE$.augmentString("")).padTo(this.prompt().length(), (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom());
        this.installSignalHandler();
    }
}

