/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.util;

import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Edge$mcD$sp;
import org.apache.spark.graphx.Edge$mcI$sp;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.util.GraphGenerators$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class GraphGenerators$
implements Logging {
    public static final GraphGenerators$ MODULE$;
    private final double RMATa;
    private final double RMATb;
    private final double RMATd;
    private final double RMATc;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new GraphGenerators$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public double RMATa() {
        return this.RMATa;
    }

    public double RMATb() {
        return this.RMATb;
    }

    public double RMATd() {
        return this.RMATd;
    }

    public Graph<Object, Object> logNormalGraph(SparkContext sc, int numVertices, int numEParts, double mu, double sigma, long seed) {
        int evalNumEParts = numEParts == 0 ? sc.defaultParallelism() : numEParts;
        Random seedRand = seed == -1L ? new Random() : new Random(seed);
        int seed1 = seedRand.nextInt();
        int seed2 = seedRand.nextInt();
        RDD vertices = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numVertices), evalNumEParts, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(numVertices, mu, sigma, seed1){
            public static final long serialVersionUID = 0L;
            private final int numVertices$1;
            private final double mu$1;
            private final double sigma$1;
            private final int seed1$1;

            public final Tuple2<Object, Object> apply(int src) {
                return new Tuple2.mcJJ.sp(Int$.MODULE$.int2long(src), (long)GraphGenerators$.MODULE$.sampleLogNormal(this.mu$1, this.sigma$1, this.numVertices$1, this.seed1$1 ^ src));
            }
            {
                this.numVertices$1 = numVertices$1;
                this.mu$1 = mu$1;
                this.sigma$1 = sigma$1;
                this.seed1$1 = seed1$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = vertices.flatMap((Function1)new Serializable(numVertices, seed2){
            public static final long serialVersionUID = 0L;
            private final int numVertices$1;
            private final int seed2$1;

            public final ArrayOps<Edge<Object>> apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    long src = tuple2._1$mcJ$sp();
                    long degree = tuple2._2$mcJ$sp();
                    ArrayOps arrayOps = Predef$.MODULE$.refArrayOps((Object[])GraphGenerators$.MODULE$.generateRandomEdges((int)src, (int)degree, this.numVertices$1, (long)this.seed2$1 ^ src));
                    return arrayOps;
                }
                throw new MatchError(tuple2);
            }
            {
                this.numVertices$1 = numVertices$1;
                this.seed2$1 = seed2$1;
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, BoxesRunTime.boxToLong((long)0L), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int());
    }

    public int logNormalGraph$default$3() {
        return 0;
    }

    public double logNormalGraph$default$4() {
        return 4.0;
    }

    public double logNormalGraph$default$5() {
        return 1.3;
    }

    public long logNormalGraph$default$6() {
        return -1L;
    }

    public double RMATc() {
        return this.RMATc;
    }

    public Edge<Object>[] generateRandomEdges(int src, int numEdges, int maxVertexId, long seed) {
        Random rand = seed == -1L ? new Random() : new Random(seed);
        return (Edge[])Array$.MODULE$.fill(numEdges, (Function0)new Serializable(src, maxVertexId, rand){
            public static final long serialVersionUID = 0L;
            private final int src$1;
            private final int maxVertexId$1;
            private final Random rand$1;

            public final Edge<Object> apply() {
                return new Edge$mcI$sp(Int$.MODULE$.int2long(this.src$1), Int$.MODULE$.int2long(this.rand$1.nextInt(this.maxVertexId$1)), 1);
            }
            {
                this.src$1 = src$1;
                this.maxVertexId$1 = maxVertexId$1;
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
    }

    public long generateRandomEdges$default$4() {
        return -1L;
    }

    public int sampleLogNormal(double mu, double sigma, int maxVal, long seed) {
        Random rand = seed == -1L ? new Random() : new Random(seed);
        double sigmaSq = sigma * sigma;
        double m = package$.MODULE$.exp(mu + sigmaSq / 2.0);
        double s = package$.MODULE$.sqrt(package$.MODULE$.expm1(sigmaSq) * package$.MODULE$.exp((double)2 * mu + sigmaSq));
        double X = maxVal;
        while (X >= (double)maxVal) {
            double Z = rand.nextGaussian();
            X = package$.MODULE$.exp(mu + sigma * Z);
        }
        return (int)package$.MODULE$.floor(X);
    }

    public long sampleLogNormal$default$4() {
        return -1L;
    }

    public Graph<Object, Object> rmatGraph(SparkContext sc, int requestedNumVertices, int numEdges) {
        int numVertices = (int)package$.MODULE$.round(package$.MODULE$.pow(2.0, package$.MODULE$.ceil(package$.MODULE$.log((double)requestedNumVertices) / package$.MODULE$.log(2.0))));
        int numEdgesUpperBound = (int)package$.MODULE$.pow(2.0, (double)2 * (package$.MODULE$.log((double)numVertices) / package$.MODULE$.log(2.0) - 1.0));
        if (numEdgesUpperBound < numEdges) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numEdges must be <= ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numEdgesUpperBound), BoxesRunTime.boxToInteger((int)numEdges)})));
        }
        ObjectRef edges = new ObjectRef((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        while (((Set)edges.elem).size() < numEdges) {
            if (((Set)edges.elem).size() % 100 == 0) {
                this.logDebug((Function0<String>)new Serializable(edges){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef edges$1;

                    public final String apply() {
                        return new StringBuilder().append(((Set)this.edges$1.elem).size()).append((Object)" edges").toString();
                    }
                    {
                        this.edges$1 = edges$1;
                    }
                });
            }
            edges.elem = (Set)((Set)edges.elem).$plus(this.addEdge(numVertices));
        }
        return this.outDegreeFromEdges(sc.parallelize((Seq)((Set)edges.elem).toList(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class)), ClassTag$.MODULE$.Int());
    }

    private <ED> Graph<Object, ED> outDegreeFromEdges(RDD<Edge<ED>> edges, ClassTag<ED> evidence$1) {
        RDD vertices = RDD$.MODULE$.rddToPairRDDFunctions(edges.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<Object, Object>> apply(Edge<ED> edge) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJI.sp(edge.srcId(), 1)}));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Long$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, int x$2) {
                return this.apply$mcIII$sp(x$1, x$2);
            }

            public int apply$mcIII$sp(int x$1, int x$2) {
                return x$1 + x$2;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    long vid = tuple2._1$mcJ$sp();
                    int degree = tuple2._2$mcI$sp();
                    Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(vid, degree);
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return Graph$.MODULE$.apply(vertices, edges, BoxesRunTime.boxToInteger((int)0), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Int(), evidence$1);
    }

    private Edge<Object> addEdge(int numVertices) {
        int v = (int)package$.MODULE$.round((double)numVertices / 2.0);
        Tuple2<Object, Object> tuple2 = this.chooseCell(v, v, v);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int src = tuple2._1$mcI$sp();
            int dst = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(src, dst);
            int src2 = sp3._1$mcI$sp();
            int dst2 = sp3._2$mcI$sp();
            return new Edge$mcI$sp(Int$.MODULE$.int2long(src2), Int$.MODULE$.int2long(dst2), 1);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Object> chooseCell(int x, int y, int t) {
        block6: while (t > 1) {
            int newT = (int)package$.MODULE$.round((double)t / 2.0);
            int n = this.pickQuadrant(this.RMATa(), this.RMATb(), this.RMATc(), this.RMATd());
            switch (n) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
                case 3: {
                    t = newT;
                    y += newT;
                    x += newT;
                    continue block6;
                }
                case 2: {
                    t = newT;
                    y += newT;
                    continue block6;
                }
                case 1: {
                    t = newT;
                    x += newT;
                    continue block6;
                }
                case 0: 
            }
            t = newT;
        }
        return new Tuple2.mcII.sp(x, y);
    }

    private int pickQuadrant(double a, double b, double c, double d) {
        if (a + b + c + d != 1.0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"R-MAT probability parameters sum to ").append((Object)BoxesRunTime.boxToDouble((double)(a + b + c + d))).append((Object)", should sum to 1.0").toString());
        }
        Random rand = new Random();
        double result = rand.nextDouble();
        double d2 = result;
        int n = d2 < a ? 0 : (d2 >= a && d2 < a + b ? 1 : (d2 >= a + b && d2 < a + b + c ? 2 : 3));
        return n;
    }

    public Graph<Tuple2<Object, Object>, Object> gridGraph(SparkContext sc, int rows, int cols) {
        RDD vertices = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rows), sc.parallelize$default$2(), ClassTag$.MODULE$.Int()).flatMap((Function1)new Serializable(cols){
            public static final long serialVersionUID = 0L;
            public final int cols$1;

            public final TraversableOnce<Tuple2<Object, Tuple2<Object, Object>>> apply(int r) {
                return (TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.cols$1).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.6 $outer;
                    private final int r$1;

                    public final Tuple2<Object, Tuple2<Object, Object>> apply(int c) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphGenerators$.MODULE$.org$apache$spark$graphx$util$GraphGenerators$$sub2ind$1(this.r$1, c, this.$outer.cols$1)), (Object)new Tuple2.mcII.sp(this.r$1, c));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.cols$1 = cols$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = vertices.flatMap((Function1)new Serializable(rows, cols){
            public static final long serialVersionUID = 0L;
            private final int rows$1;
            private final int cols$1;

            public final Seq<Tuple2<Object, Object>> apply(Tuple2<Object, Tuple2<Object, Object>> x0$3) {
                Tuple2 tuple2;
                Tuple2<Object, Tuple2<Object, Object>> tuple22 = x0$3;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    int r = tuple2._1$mcI$sp();
                    int c = tuple2._2$mcI$sp();
                    Seq seq = (Seq)((TraversableLike)(r + 1 < this.rows$1 ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(GraphGenerators$.MODULE$.org$apache$spark$graphx$util$GraphGenerators$$sub2ind$1(r, c, this.cols$1), GraphGenerators$.MODULE$.org$apache$spark$graphx$util$GraphGenerators$$sub2ind$1(r + 1, c, this.cols$1))})) : Seq$.MODULE$.empty())).$plus$plus((GenTraversableOnce)(c + 1 < this.cols$1 ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(GraphGenerators$.MODULE$.org$apache$spark$graphx$util$GraphGenerators$$sub2ind$1(r, c, this.cols$1), GraphGenerators$.MODULE$.org$apache$spark$graphx$util$GraphGenerators$$sub2ind$1(r, c + 1, this.cols$1))})) : Seq$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError(tuple22);
            }
            {
                this.rows$1 = rows$1;
                this.cols$1 = cols$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Edge<Object> apply(Tuple2<Object, Object> x0$4) {
                Tuple2<Object, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    long src = tuple2._1$mcJ$sp();
                    long dst = tuple2._2$mcJ$sp();
                    Edge$mcD$sp edge$mcD$sp = new Edge$mcD$sp(src, dst, 1.0);
                    return edge$mcD$sp;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double());
    }

    public Graph<Object, Object> starGraph(SparkContext sc, int nverts) {
        RDD edges = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), nverts), sc.parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(int vid) {
                return new Tuple2.mcJJ.sp(Int$.MODULE$.int2long(vid), 0L);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return Graph$.MODULE$.fromEdgeTuples((RDD<Tuple2<Object, Object>>)edges, BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Int());
    }

    public final long org$apache$spark$graphx$util$GraphGenerators$$sub2ind$1(int r, int c, int cols$1) {
        return Int$.MODULE$.int2long(r * cols$1 + c);
    }

    private GraphGenerators$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.RMATa = 0.45;
        this.RMATb = 0.15;
        this.RMATd = 0.25;
        this.RMATc = 0.15;
    }
}

