/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import org.apache.spark.SparkException;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.Pregel$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.lib.ConnectedComponents$;
import org.apache.spark.graphx.lib.PageRank$;
import org.apache.spark.graphx.lib.StronglyConnectedComponents$;
import org.apache.spark.graphx.lib.TriangleCount$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tuf\u0001B\u0001\u0003\u0001-\u0011\u0001b\u0012:ba\"|\u0005o\u001d\u0006\u0003\u0007\u0011\taa\u001a:ba\"D(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001U\u0019AB\b\u0015\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dQI!!F\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011]\u0001!\u0011!Q\u0001\na\tQa\u001a:ba\"\u0004B!\u0007\u000e\u001dO5\t!!\u0003\u0002\u001c\u0005\t)qI]1qQB\u0011QD\b\u0007\u0001\t\u0015y\u0002A1\u0001!\u0005\t1F)\u0005\u0002\"IA\u0011aBI\u0005\u0003G=\u0011qAT8uQ&tw\r\u0005\u0002\u000fK%\u0011ae\u0004\u0002\u0004\u0003:L\bCA\u000f)\t\u0015I\u0003A1\u0001!\u0005\t)E\t\u0003\u0005,\u0001\t\r\t\u0015a\u0003-\u0003))g/\u001b3f]\u000e,G%\r\t\u0004[AbR\"\u0001\u0018\u000b\u0005=z\u0011a\u0002:fM2,7\r^\u0005\u0003c9\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\tg\u0001\u0011\u0019\u0011)A\u0006i\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\u00075\u0002t\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0004=S:LGO\u0010\u000b\u0003qq\"2!\u000f\u001e<!\u0011I\u0002\u0001H\u0014\t\u000b-*\u00049\u0001\u0017\t\u000bM*\u00049\u0001\u001b\t\u000b])\u0004\u0019\u0001\r\t\u0011y\u0002\u0001R1A\u0005\u0002}\n\u0001B\\;n\u000b\u0012<Wm]\u000b\u0002\u0001B\u0011a\"Q\u0005\u0003\u0005>\u0011A\u0001T8oO\"AA\t\u0001E\u0001B\u0003&\u0001)A\u0005ok6,EmZ3tA!\u00121I\u0012\t\u0003\u001d\u001dK!\u0001S\b\u0003\u0013Q\u0014\u0018M\\:jK:$\b\u0002\u0003&\u0001\u0011\u000b\u0007I\u0011A \u0002\u00179,XNV3si&\u001cWm\u001d\u0005\t\u0019\u0002A\t\u0011)Q\u0005\u0001\u0006aa.^7WKJ$\u0018nY3tA!\u00121J\u0012\u0005\t\u001f\u0002A)\u0019!C\u0001!\u0006I\u0011N\u001c#fOJ,Wm]\u000b\u0002#B\u0019\u0011D\u0015+\n\u0005M\u0013!!\u0003,feR,\u0007P\u0015#E!\tqQ+\u0003\u0002W\u001f\t\u0019\u0011J\u001c;\t\u0011a\u0003\u0001\u0012!Q!\nE\u000b!\"\u001b8EK\u001e\u0014X-Z:!Q\t9f\t\u0003\u0005\\\u0001!\u0015\r\u0011\"\u0001Q\u0003)yW\u000f\u001e#fOJ,Wm\u001d\u0005\t;\u0002A\t\u0011)Q\u0005#\u0006Yq.\u001e;EK\u001e\u0014X-Z:!Q\taf\t\u0003\u0005a\u0001!\u0015\r\u0011\"\u0001Q\u0003\u001d!Wm\u001a:fKND\u0001B\u0019\u0001\t\u0002\u0003\u0006K!U\u0001\tI\u0016<'/Z3tA!\u0012\u0011M\u0012\u0005\u0006K\u0002!IAZ\u0001\u000bI\u0016<'/Z3t%\u0012#ECA)h\u0011\u0015AG\r1\u0001j\u00035)GmZ3ESJ,7\r^5p]B\u0011\u0011D[\u0005\u0003W\n\u0011Q\"\u00123hK\u0012K'/Z2uS>t\u0007\"B7\u0001\t\u0003q\u0017AE2pY2,7\r\u001e(fS\u001eD'm\u001c:JIN$\"a\u001c>\u0011\u0007e\u0011\u0006\u000fE\u0002\u000fcNL!A]\b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Q<hBA\rv\u0013\t1(!A\u0004qC\u000e\\\u0017mZ3\n\u0005aL(\u0001\u0003,feR,\u00070\u00133\u000b\u0005Y\u0014\u0001\"\u00025m\u0001\u0004I\u0007\"\u0002?\u0001\t\u0003i\u0018\u0001E2pY2,7\r\u001e(fS\u001eD'm\u001c:t)\rq\u0018q\u0001\t\u00043I{\b\u0003\u0002\br\u0003\u0003\u0001RADA\u0002grI1!!\u0002\u0010\u0005\u0019!V\u000f\u001d7fe!)\u0001n\u001fa\u0001S\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0011\u0001D2pY2,7\r^#eO\u0016\u001cH\u0003BA\b\u00033\u0001B!\u0007*\u0002\u0012A!a\"]A\n!\u0011I\u0012QC\u0014\n\u0007\u0005]!A\u0001\u0003FI\u001e,\u0007B\u00025\u0002\n\u0001\u0007\u0011\u000eC\u0004\u0002\u001e\u0001!\t!a\b\u0002\u0019)|\u0017N\u001c,feRL7-Z:\u0016\t\u0005\u0005\u0012q\u0006\u000b\u0005\u0003G\ti\u0004\u0006\u0003\u0002&\u0005MBc\u0001\r\u0002(!Q\u0011\u0011FA\u000e\u0003\u0003\u0005\u001d!a\u000b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0003.a\u00055\u0002cA\u000f\u00020\u00119\u0011\u0011GA\u000e\u0005\u0004\u0001#!A+\t\u0011\u0005U\u00121\u0004a\u0001\u0003o\tq!\\1q\rVt7\r\u0005\u0005\u000f\u0003s\u0019H$!\f\u001d\u0013\r\tYd\u0004\u0002\n\rVt7\r^5p]NB\u0001\"a\u0010\u0002\u001c\u0001\u0007\u0011\u0011I\u0001\u0006i\u0006\u0014G.\u001a\t\u0007\u0003\u0007\nI%!\u0014\u000e\u0005\u0005\u0015#bAA$\t\u0005\u0019!\u000f\u001a3\n\t\u0005-\u0013Q\t\u0002\u0004%\u0012#\u0005C\u0002\b\u0002\u0004M\fi\u0003C\u0004\u0002R\u0001!\t!a\u0015\u0002\r\u0019LG\u000e^3s+\u0019\t)&!\u0019\u0002nQA\u0011qKA9\u0003{\ny\tF\u0003\u0019\u00033\n)\u0007\u0003\u0006\u0002\\\u0005=\u0013\u0011!a\u0002\u0003;\n!\"\u001a<jI\u0016t7-\u001a\u00135!\u0011i\u0003'a\u0018\u0011\u0007u\t\t\u0007B\u0004\u0002d\u0005=#\u0019\u0001\u0011\u0003\u0007Y#%\u0007\u0003\u0006\u0002h\u0005=\u0013\u0011!a\u0002\u0003S\n!\"\u001a<jI\u0016t7-\u001a\u00136!\u0011i\u0003'a\u001b\u0011\u0007u\ti\u0007B\u0004\u0002p\u0005=#\u0019\u0001\u0011\u0003\u0007\u0015#%\u0007\u0003\u0005\u0002t\u0005=\u0003\u0019AA;\u0003)\u0001(/\u001a9s_\u000e,7o\u001d\t\u0007\u001d\u0005]\u0004$a\u001f\n\u0007\u0005etBA\u0005Gk:\u001cG/[8ocA1\u0011DGA0\u0003WB!\"a \u0002PA\u0005\t\u0019AAA\u0003\u0015)\u0007O]3e!\u001dq\u0011qOAB\u0003\u0013\u0003r!GAC\u0003?\nY'C\u0002\u0002\b\n\u00111\"\u00123hKR\u0013\u0018\u000e\u001d7fiB\u0019a\"a#\n\u0007\u00055uBA\u0004C_>dW-\u00198\t\u0015\u0005E\u0015q\nI\u0001\u0002\u0004\t\u0019*A\u0003waJ,G\r\u0005\u0005\u000f\u0003+\u001b\u0018qLAE\u0013\r\t9j\u0004\u0002\n\rVt7\r^5p]JBq!a'\u0001\t\u0003\ti*\u0001\tqS\u000e\\'+\u00198e_64VM\u001d;fqR\t1\u000fC\u0004\u0002\"\u0002!\t!a)\u0002/\r|gN^3siR{7)\u00198p]&\u001c\u0017\r\\#eO\u0016\u001cHc\u0001\r\u0002&\"Q\u0011qUAP!\u0003\u0005\r!!+\u0002\u00135,'oZ3Gk:\u001c\u0007C\u0002\b\u0002\u0016\u001e:s\u0005C\u0004\u0002.\u0002!\t!a,\u0002\rA\u0014XmZ3m+\u0011\t\t,a0\u0015\u0011\u0005M\u0016q^Az\u0003o$\u0002\"!.\u0002D\u0006%\u0017\u0011\u001e\u000b\u00041\u0005]\u0006BCA]\u0003W\u000b\t\u0011q\u0001\u0002<\u0006QQM^5eK:\u001cW\r\n\u001c\u0011\t5\u0002\u0014Q\u0018\t\u0004;\u0005}FaBAa\u0003W\u0013\r\u0001\t\u0002\u0002\u0003\"A\u0011QYAV\u0001\u0004\t9-A\u0003waJ|w\r\u0005\u0005\u000f\u0003s\u0019H$!0\u001d\u0011!\tY-a+A\u0002\u00055\u0017aB:f]\u0012l5o\u001a\t\b\u001d\u0005]\u0014qZAi!\u0015I\u0012Q\u0011\u000f(!\u0019\t\u0019.!9\u0002h:!\u0011Q[Ap\u001d\u0011\t9.!8\u000e\u0005\u0005e'bAAn\u0015\u00051AH]8pizJ\u0011\u0001E\u0005\u0003m>IA!a9\u0002f\nA\u0011\n^3sCR|'O\u0003\u0002w\u001fA1a\"a\u0001t\u0003{C\u0001\"a;\u0002,\u0002\u0007\u0011Q^\u0001\t[\u0016\u0014x-Z'tOBIa\"!&\u0002>\u0006u\u0016Q\u0018\u0005\t\u0003c\fY\u000b1\u0001\u0002>\u0006Q\u0011N\\5uS\u0006dWj]4\t\u0013\u0005U\u00181\u0016I\u0001\u0002\u0004!\u0016!D7bq&#XM]1uS>t7\u000fC\u0005\u0002z\u0006-\u0006\u0013!a\u0001S\u0006y\u0011m\u0019;jm\u0016$\u0015N]3di&|g\u000eC\u0004\u0002~\u0002!\t!a@\u0002\u0011A\fw-\u001a*b].$bA!\u0001\u0003\n\t5\u0001CB\r\u001b\u0005\u0007\u0011\u0019\u0001E\u0002\u000f\u0005\u000bI1Aa\u0002\u0010\u0005\u0019!u.\u001e2mK\"A!1BA~\u0001\u0004\u0011\u0019!A\u0002u_2D!Ba\u0004\u0002|B\u0005\t\u0019\u0001B\u0002\u0003%\u0011Xm]3u!J|'\rC\u0004\u0003\u0014\u0001!\tA!\u0006\u0002)A,'o]8oC2L'0\u001a3QC\u001e,'+\u00198l)!\u0011\tAa\u0006\u0003\u001c\tu\u0001b\u0002B\r\u0005#\u0001\ra]\u0001\u0004gJ\u001c\u0007\u0002\u0003B\u0006\u0005#\u0001\rAa\u0001\t\u0015\t=!\u0011\u0003I\u0001\u0002\u0004\u0011\u0019\u0001C\u0004\u0003\"\u0001!\tAa\t\u00025M$\u0018\r^5d!\u0016\u00148o\u001c8bY&TX\r\u001a)bO\u0016\u0014\u0016M\\6\u0015\u0011\t\u0005!Q\u0005B\u0014\u0005WAqA!\u0007\u0003 \u0001\u00071\u000fC\u0004\u0003*\t}\u0001\u0019\u0001+\u0002\u000f9,X.\u0013;fe\"Q!q\u0002B\u0010!\u0003\u0005\rAa\u0001\t\u000f\t=\u0002\u0001\"\u0001\u00032\u0005q1\u000f^1uS\u000e\u0004\u0016mZ3SC:\\GC\u0002B\u0001\u0005g\u0011)\u0004C\u0004\u0003*\t5\u0002\u0019\u0001+\t\u0015\t=!Q\u0006I\u0001\u0002\u0004\u0011\u0019\u0001C\u0004\u0003:\u0001!\tAa\u000f\u0002'\r|gN\\3di\u0016$7i\\7q_:,g\u000e^:\u0015\u0005\tu\u0002\u0003B\r\u001bg\u001eBqA!\u0011\u0001\t\u0003\u0011\u0019%A\u0007ue&\fgn\u001a7f\u0007>,h\u000e\u001e\u000b\u0003\u0005\u000b\u0002B!\u0007\u000eUO!9!\u0011\n\u0001\u0005\u0002\t-\u0013aG:ue>tw\r\\=D_:tWm\u0019;fI\u000e{W\u000e]8oK:$8\u000f\u0006\u0003\u0003>\t5\u0003b\u0002B\u0015\u0005\u000f\u0002\r\u0001\u0016\u0005\n\u0005#\u0002\u0011\u0013!C\u0001\u0005'\n\u0001CZ5mi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\r\tU#q\fB2+\t\u00119F\u000b\u0003\u0003Z\t\u0015\u0004c\u0002\b\u0002x\tm\u0013\u0011\u0012\t\b3\u0005\u0015%Q\fB1!\ri\"q\f\u0003\b\u0003G\u0012yE1\u0001!!\ri\"1\r\u0003\b\u0003_\u0012yE1\u0001!W\t\u00119\u0007\u0005\u0003\u0003j\tMTB\u0001B6\u0015\u0011\u0011iGa\u001c\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B9\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU$1\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B=\u0001E\u0005I\u0011\u0001B>\u0003A1\u0017\u000e\u001c;fe\u0012\"WMZ1vYR$3'\u0006\u0004\u0003~\t\u0015%qQ\u000b\u0003\u0005\u007fRCA!!\u0003fAAa\"!&t\u0005\u0007\u000bI\tE\u0002\u001e\u0005\u000b#q!a\u0019\u0003x\t\u0007\u0001\u0005B\u0004\u0002p\t]$\u0019\u0001\u0011\t\u0013\t-\u0005!%A\u0005\u0002\t5\u0015!I2p]Z,'\u000f\u001e+p\u0007\u0006twN\\5dC2,EmZ3tI\u0011,g-Y;mi\u0012\nTC\u0001BHU\u0011\tIK!\u001a\t\u0013\tM\u0005!%A\u0005\u0002\tU\u0015\u0001\u00059sK\u001e,G\u000e\n3fM\u0006,H\u000e\u001e\u00133+\u0011\u00119Ja'\u0016\u0005\te%f\u0001+\u0003f\u00119\u0011\u0011\u0019BI\u0005\u0004\u0001\u0003\"\u0003BP\u0001E\u0005I\u0011\u0001BQ\u0003A\u0001(/Z4fY\u0012\"WMZ1vYR$3'\u0006\u0003\u0003$\n\u001dVC\u0001BSU\rI'Q\r\u0003\b\u0003\u0003\u0014iJ1\u0001!\u0011%\u0011Y\u000bAI\u0001\n\u0003\u0011i+\u0001\nqC\u001e,'+\u00198lI\u0011,g-Y;mi\u0012\u0012TC\u0001BXU\u0011\u0011\u0019A!\u001a\t\u0013\tM\u0006!%A\u0005\u0002\t5\u0016A\b9feN|g.\u00197ju\u0016$\u0007+Y4f%\u0006t7\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u00119\fAI\u0001\n\u0003\u0011i+\u0001\u0013ti\u0006$\u0018n\u0019)feN|g.\u00197ju\u0016$\u0007+Y4f%\u0006t7\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u0011Y\fAI\u0001\n\u0003\u0011i+\u0001\rti\u0006$\u0018n\u0019)bO\u0016\u0014\u0016M\\6%I\u00164\u0017-\u001e7uII\u0002")
public class GraphOps<VD, ED>
implements Serializable {
    private final Graph<VD, ED> graph;
    private final ClassTag<VD> evidence$1;
    private final ClassTag<ED> evidence$2;
    private transient long numEdges;
    private transient long numVertices;
    private transient VertexRDD<Object> inDegrees;
    private transient VertexRDD<Object> outDegrees;
    private transient VertexRDD<Object> degrees;
    private volatile transient byte bitmap$trans$0;

    private long numEdges$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.numEdges = this.graph.edges().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.numEdges;
        }
    }

    private long numVertices$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numVertices = this.graph.vertices().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.numVertices;
        }
    }

    private VertexRDD inDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.In()).setName("GraphOps.inDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.inDegrees;
        }
    }

    private VertexRDD outDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.outDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Out()).setName("GraphOps.outDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.outDegrees;
        }
    }

    private VertexRDD degrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.degrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Either()).setName("GraphOps.degrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
            return this.degrees;
        }
    }

    public long numEdges() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.numEdges$lzycompute() : this.numEdges;
    }

    public long numVertices() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numVertices$lzycompute() : this.numVertices;
    }

    public VertexRDD<Object> inDegrees() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inDegrees$lzycompute() : this.inDegrees;
    }

    public VertexRDD<Object> outDegrees() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.outDegrees$lzycompute() : this.outDegrees;
    }

    public VertexRDD<Object> degrees() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.degrees$lzycompute() : this.degrees;
    }

    private VertexRDD<Object> degreesRDD(EdgeDirection edgeDirection) {
        VertexRDD<Object> vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.In();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(EdgeContext<VD, ED, Object> x$1) {
                    x$1.sendToDst(BoxesRunTime.boxToInteger((int)1));
                }
            }, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$2, int x$3) {
                    return this.apply$mcIII$sp(x$2, x$3);
                }

                public int apply$mcIII$sp(int x$2, int x$3) {
                    return x$2 + x$3;
                }
            }, TripletFields.None, ClassTag$.MODULE$.Int());
        } else {
            EdgeDirection edgeDirection4 = edgeDirection;
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
            vertexRDD = !(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null) ? this.graph.aggregateMessages(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(EdgeContext<VD, ED, Object> x$4) {
                    x$4.sendToSrc(BoxesRunTime.boxToInteger((int)1));
                }
            }, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$5, int x$6) {
                    return this.apply$mcIII$sp(x$5, x$6);
                }

                public int apply$mcIII$sp(int x$5, int x$6) {
                    return x$5 + x$6;
                }
            }, TripletFields.None, ClassTag$.MODULE$.Int()) : this.graph.aggregateMessages(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(EdgeContext<VD, ED, Object> ctx) {
                    ctx.sendToSrc(BoxesRunTime.boxToInteger((int)1));
                    ctx.sendToDst(BoxesRunTime.boxToInteger((int)1));
                }
            }, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$7, int x$8) {
                    return this.apply$mcIII$sp(x$7, x$8);
                }

                public int apply$mcIII$sp(int x$7, int x$8) {
                    return x$7 + x$8;
                }
            }, TripletFields.None, ClassTag$.MODULE$.Int());
        }
        return vertexRDD;
    }

    public VertexRDD<long[]> collectNeighborIds(EdgeDirection edgeDirection) {
        block5: {
            VertexRDD vertexRDD;
            block3: {
                block4: {
                    block2: {
                        EdgeDirection edgeDirection2 = edgeDirection;
                        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
                        if (edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null) break block2;
                        vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(EdgeContext<VD, ED, long[]> ctx) {
                                ctx.sendToSrc(new long[]{ctx.dstId()});
                                ctx.sendToDst(new long[]{ctx.srcId()});
                            }
                        }, new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long[] apply(long[] x$9, long[] x$10) {
                                return (long[])Predef$.MODULE$.longArrayOps(x$9).$plus$plus((GenTraversableOnce)Predef$.MODULE$.longArrayOps(x$10), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE)));
                            }
                        }, TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
                        break block3;
                    }
                    EdgeDirection edgeDirection4 = edgeDirection;
                    EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
                    if (edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null) break block4;
                    vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(EdgeContext<VD, ED, long[]> ctx) {
                            ctx.sendToSrc(new long[]{ctx.dstId()});
                        }
                    }, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long[] apply(long[] x$11, long[] x$12) {
                            return (long[])Predef$.MODULE$.longArrayOps(x$11).$plus$plus((GenTraversableOnce)Predef$.MODULE$.longArrayOps(x$12), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE)));
                        }
                    }, TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
                    break block3;
                }
                EdgeDirection edgeDirection6 = edgeDirection;
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.In();
                if (edgeDirection6 != null ? !((Object)edgeDirection6).equals(edgeDirection7) : edgeDirection7 != null) break block5;
                vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(EdgeContext<VD, ED, long[]> ctx) {
                        ctx.sendToDst(new long[]{ctx.srcId()});
                    }
                }, new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long[] apply(long[] x$13, long[] x$14) {
                        return (long[])Predef$.MODULE$.longArrayOps(x$13).$plus$plus((GenTraversableOnce)Predef$.MODULE$.longArrayOps(x$14), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE)));
                    }
                }, TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
            }
            VertexRDD nbrs = vertexRDD;
            return this.graph.vertices().leftZipJoin(nbrs, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long[] apply(long vid, VD vdata, Option<long[]> nbrsOpt) {
                    return (long[])nbrsOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long[] apply() {
                            return (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Long.TYPE));
                        }
                    });
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        }
        throw new SparkException("It doesn't make sense to collect neighbor ids without a direction. (EdgeDirection.Both is not supported; use EdgeDirection.Either instead.)");
    }

    public VertexRDD<Tuple2<Object, VD>[]> collectNeighbors(EdgeDirection edgeDirection) {
        EdgeDirection edgeDirection2;
        block7: {
            VertexRDD vertexRDD;
            block5: {
                block6: {
                    block4: {
                        edgeDirection2 = edgeDirection;
                        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
                        EdgeDirection edgeDirection4 = edgeDirection2;
                        if (edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null) break block4;
                        vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(EdgeContext<VD, ED, Tuple2<Object, VD>[]> ctx) {
                                ctx.sendToSrc((Tuple2<Object, VD>[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
                                ctx.sendToDst((Tuple2<Object, VD>[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
                            }
                        }, new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, VD>[] apply(Tuple2<Object, VD>[] a, Tuple2<Object, VD>[] b) {
                                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                            }
                        }, TripletFields.All, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                        break block5;
                    }
                    EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
                    EdgeDirection edgeDirection6 = edgeDirection2;
                    if (edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null) break block6;
                    vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(EdgeContext<VD, ED, Tuple2<Object, VD>[]> ctx) {
                            ctx.sendToDst((Tuple2<Object, VD>[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
                        }
                    }, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, VD>[] apply(Tuple2<Object, VD>[] a, Tuple2<Object, VD>[] b) {
                            return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                        }
                    }, TripletFields.Src, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                    break block5;
                }
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null) break block7;
                vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(EdgeContext<VD, ED, Tuple2<Object, VD>[]> ctx) {
                        ctx.sendToSrc((Tuple2<Object, VD>[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
                    }
                }, new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, VD>[] apply(Tuple2<Object, VD>[] a, Tuple2<Object, VD>[] b) {
                        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    }
                }, TripletFields.Dst, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            }
            VertexRDD nbrs = vertexRDD;
            return this.graph.vertices().leftJoin(nbrs, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, VD>[] apply(long vid, VD vdata, Option<Tuple2<Object, VD>[]> nbrsOpt) {
                    return (Tuple2[])nbrsOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, VD>[] apply() {
                            return (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class));
                        }
                    });
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
        }
        EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
        EdgeDirection edgeDirection10 = edgeDirection2;
        if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
            throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
        }
        throw new MatchError((Object)edgeDirection2);
    }

    public VertexRDD<Edge<ED>[]> collectEdges(EdgeDirection edgeDirection) {
        EdgeDirection edgeDirection2;
        block7: {
            VertexRDD<Object> vertexRDD;
            block5: {
                block6: {
                    block4: {
                        edgeDirection2 = edgeDirection;
                        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
                        EdgeDirection edgeDirection4 = edgeDirection2;
                        if (edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null) break block4;
                        vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(EdgeContext<VD, ED, Edge<ED>[]> ctx) {
                                ctx.sendToSrc((Edge<ED>[])((Object[])new Edge[]{new Edge<ED>(ctx.srcId(), ctx.dstId(), ctx.attr())}));
                                ctx.sendToDst((Edge<ED>[])((Object[])new Edge[]{new Edge<ED>(ctx.srcId(), ctx.dstId(), ctx.attr())}));
                            }
                        }, new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Edge<ED>[] apply(Edge<ED>[] a, Edge<ED>[] b) {
                                return (Edge[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class)));
                            }
                        }, TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
                        break block5;
                    }
                    EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
                    EdgeDirection edgeDirection6 = edgeDirection2;
                    if (edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null) break block6;
                    vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(EdgeContext<VD, ED, Edge<ED>[]> ctx) {
                            ctx.sendToDst((Edge<ED>[])((Object[])new Edge[]{new Edge<ED>(ctx.srcId(), ctx.dstId(), ctx.attr())}));
                        }
                    }, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Edge<ED>[] apply(Edge<ED>[] a, Edge<ED>[] b) {
                            return (Edge[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class)));
                        }
                    }, TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
                    break block5;
                }
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null) break block7;
                vertexRDD = this.graph.aggregateMessages(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(EdgeContext<VD, ED, Edge<ED>[]> ctx) {
                        ctx.sendToSrc((Edge<ED>[])((Object[])new Edge[]{new Edge<ED>(ctx.srcId(), ctx.dstId(), ctx.attr())}));
                    }
                }, new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Edge<ED>[] apply(Edge<ED>[] a, Edge<ED>[] b) {
                        return (Edge[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class)));
                    }
                }, TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
            }
            return vertexRDD;
        }
        EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
        EdgeDirection edgeDirection10 = edgeDirection2;
        if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
            throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
        }
        throw new MatchError((Object)edgeDirection2);
    }

    public <U> Graph<VD, ED> joinVertices(RDD<Tuple2<Object, U>> table, Function3<Object, VD, U, VD> mapFunc, ClassTag<U> evidence$3) {
        Serializable uf = new Serializable(this, mapFunc){
            public static final long serialVersionUID = 0L;
            private final Function3 mapFunc$1;

            public final VD apply(long id, VD data, Option<U> o) {
                Option<U> option;
                block4: {
                    Object object;
                    block3: {
                        block2: {
                            option = o;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Object u = some.x();
                            object = this.mapFunc$1.apply((Object)BoxesRunTime.boxToLong((long)id), data, u);
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<U> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        object = data;
                    }
                    return object;
                }
                throw new MatchError(option);
            }
            {
                this.mapFunc$1 = mapFunc$1;
            }
        };
        return this.graph.outerJoinVertices(table, uf, evidence$3, this.evidence$1, Predef.$eq$colon$eq$.MODULE$.tpEquals());
    }

    public <VD2, ED2> Graph<VD, ED> filter(Function1<Graph<VD, ED>, Graph<VD2, ED2>> preprocess, Function1<EdgeTriplet<VD2, ED2>, Object> epred, Function2<Object, VD2, Object> vpred, ClassTag<VD2> evidence$4, ClassTag<ED2> evidence$5) {
        return this.graph.mask(((Graph)preprocess.apply(this.graph)).subgraph(epred, vpred), evidence$4, evidence$5);
    }

    public <VD2, ED2> Function1<EdgeTriplet<VD2, ED2>, Object> filter$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(EdgeTriplet<VD2, ED2> x) {
                return true;
            }
        };
    }

    public <VD2, ED2> Function2<Object, VD2, Object> filter$default$3() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long v, VD2 d) {
                return true;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public long pickRandomVertex() {
        double probability = 50.0 / (double)Graph$.MODULE$.graphToGraphOps(this.graph, this.evidence$1, this.evidence$2).numVertices();
        boolean found = false;
        long retVal = BoxesRunTime.unboxToLong(null);
        while (!found) {
            void var1_1;
            RDD selectedVertices = this.graph.vertices().flatMap((Function1)new Serializable(this, (double)var1_1){
                public static final long serialVersionUID = 0L;
                private final double probability$1;

                public final Iterable<Object> apply(Tuple2<Object, VD> vidVvals) {
                    return Random$.MODULE$.nextDouble() < this.probability$1 ? Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)vidVvals._1$mcJ$sp()))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                {
                    this.probability$1 = probability$1;
                }
            }, ClassTag$.MODULE$.apply(Long.TYPE));
            if (selectedVertices.count() <= 1L) continue;
            boolean bl = true;
            long[] collectedVertices = (long[])selectedVertices.collect();
            long l = collectedVertices[Random$.MODULE$.nextInt(Predef$.MODULE$.longArrayOps(collectedVertices).size())];
        }
        return retVal;
    }

    public Graph<VD, ED> convertToCanonicalEdges(Function2<ED, ED, ED> mergeFunc) {
        RDD newEdges = RDD$.MODULE$.rddToPairRDDFunctions(this.graph.edges().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, ED> apply(Edge<ED> x0$1) {
                Edge<ED> edge = x0$1;
                Tuple2 tuple2 = edge.srcId() < edge.dstId() ? new Tuple2((Object)new Tuple2.mcJJ.sp(edge.srcId(), edge.dstId()), edge.attr()) : new Tuple2((Object)new Tuple2.mcJJ.sp(edge.dstId(), edge.srcId()), edge.attr());
                return tuple2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), this.evidence$2, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).reduceByKey(mergeFunc).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Edge<ED> apply(Tuple2<Tuple2<Object, Object>, ED> e) {
                return new Edge<Object>(((Tuple2)e._1())._1$mcJ$sp(), ((Tuple2)e._1())._2$mcJ$sp(), e._2());
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(this.graph.vertices(), newEdges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), this.evidence$1, this.evidence$2);
    }

    public Function2<ED, ED, ED> convertToCanonicalEdges$default$1() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ED apply(ED e1, ED e2) {
                return e1;
            }
        };
    }

    public <A> Graph<VD, ED> pregel(A initialMsg, int maxIterations, EdgeDirection activeDirection, Function3<Object, VD, A, VD> vprog, Function1<EdgeTriplet<VD, ED>, Iterator<Tuple2<Object, A>>> sendMsg2, Function2<A, A, A> mergeMsg, ClassTag<A> evidence$6) {
        return Pregel$.MODULE$.apply(this.graph, initialMsg, maxIterations, activeDirection, vprog, sendMsg2, mergeMsg, this.evidence$1, this.evidence$2, evidence$6);
    }

    public <A> int pregel$default$2() {
        return Integer.MAX_VALUE;
    }

    public <A> EdgeDirection pregel$default$3() {
        return EdgeDirection$.MODULE$.Either();
    }

    public Graph<Object, Object> pageRank(double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergence(this.graph, tol, resetProb, this.evidence$1, this.evidence$2);
    }

    public double pageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, Object> personalizedPageRank(long src, double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergenceWithOptions(this.graph, tol, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double personalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPersonalizedPageRank(long src, int numIter, double resetProb) {
        return PageRank$.MODULE$.runWithOptions(this.graph, numIter, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double staticPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPageRank(int numIter, double resetProb) {
        return PageRank$.MODULE$.run(this.graph, numIter, resetProb, this.evidence$1, this.evidence$2);
    }

    public double staticPageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, ED> connectedComponents() {
        return ConnectedComponents$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> triangleCount() {
        return TriangleCount$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> stronglyConnectedComponents(int numIter) {
        return StronglyConnectedComponents$.MODULE$.run(this.graph, numIter, this.evidence$1, this.evidence$2);
    }

    public GraphOps(Graph<VD, ED> graph, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        this.graph = graph;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }
}

