/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.streaming.Durations;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kafka010.ConsumerStrategies;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.KafkaUtils;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import scala.Tuple2;

public final class JavaDirectKafkaWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaDirectKafkaWordCount <brokers> <topics>\n  <brokers> is a list of one or more Kafka brokers\n  <topics> is a list of one or more kafka topics to consume from\n\n");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        String brokers = args[0];
        String topics = args[1];
        SparkConf sparkConf = new SparkConf().setAppName("JavaDirectKafkaWordCount");
        JavaStreamingContext jssc = new JavaStreamingContext(sparkConf, Durations.seconds((long)2L));
        HashSet<String> topicsSet = new HashSet<String>(Arrays.asList(topics.split(",")));
        HashMap<String, String> kafkaParams = new HashMap<String, String>();
        kafkaParams.put("metadata.broker.list", brokers);
        JavaInputDStream messages = KafkaUtils.createDirectStream((JavaStreamingContext)jssc, (LocationStrategy)LocationStrategies.PreferConsistent(), (ConsumerStrategy)ConsumerStrategies.Subscribe(topicsSet, kafkaParams));
        JavaDStream lines = messages.map(ConsumerRecord::value);
        JavaDStream words = lines.flatMap((FlatMapFunction & Serializable)x -> Arrays.asList(SPACE.split((CharSequence)x)).iterator());
        JavaPairDStream wordCounts = words.mapToPair((PairFunction & Serializable)s -> new Tuple2(s, (Object)1)).reduceByKey((Function2 & Serializable)(i1, i2) -> i1 + i2);
        wordCounts.print();
        jssc.start();
        jssc.awaitTermination();
    }
}

