/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Tuple2;

public final class JavaStructuredNetworkWordCountWindowed {
    public static void main(String[] args) throws Exception {
        int slideSize;
        if (args.length < 3) {
            System.err.println("Usage: JavaStructuredNetworkWordCountWindowed <hostname> <port> <window duration in seconds> [<slide duration in seconds>]");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int windowSize = Integer.parseInt(args[2]);
        int n = slideSize = args.length == 3 ? windowSize : Integer.parseInt(args[3]);
        if (slideSize > windowSize) {
            System.err.println("<slide duration> must be less than or equal to <window duration>");
        }
        String windowDuration = windowSize + " seconds";
        String slideDuration = slideSize + " seconds";
        SparkSession spark = SparkSession.builder().appName("JavaStructuredNetworkWordCountWindowed").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).option("includeTimestamp", true).load();
        Dataset words = lines.as(Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.TIMESTAMP())).flatMap((FlatMapFunction)new FlatMapFunction<Tuple2<String, Timestamp>, Tuple2<String, Timestamp>>(){

            public Iterator<Tuple2<String, Timestamp>> call(Tuple2<String, Timestamp> t) {
                ArrayList<Tuple2> result = new ArrayList<Tuple2>();
                for (String word : ((String)t._1).split(" ")) {
                    result.add(new Tuple2((Object)word, t._2));
                }
                return result.iterator();
            }
        }, Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.TIMESTAMP())).toDF(new String[]{"word", "timestamp"});
        Dataset windowedCounts = words.groupBy(new Column[]{functions.window((Column)words.col("timestamp"), (String)windowDuration, (String)slideDuration), words.col("word")}).count().orderBy("window", new String[0]);
        StreamingQuery query = windowedCounts.writeStream().outputMode("complete").format("console").option("truncate", "false").start();
        query.awaitTermination();
    }
}

