/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.mllib.evaluation.RankingMetrics;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RankingMetricsExample$ {
    public static final RankingMetricsExample$ MODULE$;

    static {
        new RankingMetricsExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("RankingMetricsExample").getOrCreate();
        RDD ratings = spark.read().textFile("data/mllib/sample_movielens_data.txt").rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Rating apply(String line) {
                String[] fields = line.split("::");
                return new Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble() - 2.5);
            }
        }, ClassTag$.MODULE$.apply(Rating.class)).cache();
        RDD binarizedRatings = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Rating apply(Rating r) {
                return new Rating(r.user(), r.product(), r.rating() > 0.0 ? 1.0 : 0.0);
            }
        }, ClassTag$.MODULE$.apply(Rating.class)).cache();
        long numRatings = ratings.count();
        long numUsers = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Rating x$1) {
                return x$1.user();
            }
        }, ClassTag$.MODULE$.Int()).distinct().count();
        long numMovies = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Rating x$2) {
                return x$2.product();
            }
        }, ClassTag$.MODULE$.Int()).distinct().count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " ratings from ", " users on ", " movies."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numRatings), BoxesRunTime.boxToLong((long)numUsers), BoxesRunTime.boxToLong((long)numMovies)})));
        int numIterations = 10;
        int rank = 10;
        double lambda = 0.01;
        MatrixFactorizationModel model = ALS$.MODULE$.train(ratings, rank, numIterations, lambda);
        RDD userRecommended = model.recommendProductsForUsers(10).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Rating[]> apply(Tuple2<Object, Rating[]> x0$1) {
                Tuple2<Object, Rating[]> tuple2 = x0$1;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Rating[] recs = (Rating[])tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), Predef$.MODULE$.refArrayOps((Object[])recs).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Rating apply(Rating r) {
                            return RankingMetricsExample$.MODULE$.org$apache$spark$examples$mllib$RankingMetricsExample$$scaledRating$1(r);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class))));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD userMovies = binarizedRatings.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Rating x$3) {
                return x$3.user();
            }
        }, ClassTag$.MODULE$.Int());
        RDD relevantDocuments = RDD$.MODULE$.rddToPairRDDFunctions(userMovies, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Int$.MODULE$).join(userRecommended).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<int[], int[]> apply(Tuple2<Object, Tuple2<Iterable<Rating>, Rating[]>> x0$2) {
                Tuple2 tuple2;
                Tuple2<Object, Tuple2<Iterable<Rating>, Rating[]>> tuple22 = x0$2;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    Iterable actual = (Iterable)tuple2._1();
                    Rating[] predictions = (Rating[])tuple2._2();
                    Tuple2 tuple23 = new Tuple2(Predef$.MODULE$.refArrayOps((Object[])predictions).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Rating x$4) {
                            return x$4.product();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), ((TraversableOnce)((TraversableLike)actual.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Rating x$5) {
                            return x$5.rating() > 0.0;
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Rating x$6) {
                            return x$6.product();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()));
                    return tuple23;
                }
                throw new MatchError(tuple22);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RankingMetrics metrics = new RankingMetrics(relevantDocuments, ClassTag$.MODULE$.Int());
        Predef$.MODULE$.intArrayOps(new int[]{1, 3, 5}).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final RankingMetrics metrics$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Precision at ", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)k), BoxesRunTime.boxToDouble((double)this.metrics$1.precisionAt(k))})));
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mean average precision = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.meanAveragePrecision())})));
        Predef$.MODULE$.intArrayOps(new int[]{1, 3, 5}).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final RankingMetrics metrics$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NDCG at ", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)k), BoxesRunTime.boxToDouble((double)this.metrics$1.ndcgAt(k))})));
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        RDD allPredictions = model.predict(ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Rating r) {
                return new Tuple2.mcII.sp(r.user(), r.product());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(Rating r) {
                return new Tuple2((Object)new Tuple2.mcII.sp(r.user(), r.product()), (Object)BoxesRunTime.boxToDouble((double)r.rating()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD allRatings = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(Rating r) {
                return new Tuple2((Object)new Tuple2.mcII.sp(r.user(), r.product()), (Object)BoxesRunTime.boxToDouble((double)r.rating()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD predictionsAndLabels = RDD$.MODULE$.rddToPairRDDFunctions(allPredictions, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).join(allRatings).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$3) {
                Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null && tuple23 != null) {
                        double predicted = tuple23._1$mcD$sp();
                        double actual = tuple23._2$mcD$sp();
                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(predicted, actual);
                        return sp2;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RegressionMetrics regressionMetrics = new RegressionMetrics(predictionsAndLabels);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RMSE = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)regressionMetrics.rootMeanSquaredError())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"R-squared = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)regressionMetrics.r2())})));
    }

    public final Rating org$apache$spark$examples$mllib$RankingMetricsExample$$scaledRating$1(Rating r) {
        double scaledRating = package$.MODULE$.max(package$.MODULE$.min(r.rating(), 1.0), 0.0);
        return new Rating(r.user(), r.product(), scaledRating);
    }

    private RankingMetricsExample$() {
        MODULE$ = this;
    }
}

