/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class JavaRegressionMetricsExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("Java Regression Metrics Example");
        JavaSparkContext sc = new JavaSparkContext(conf);
        String path = "data/mllib/sample_linear_regression_data.txt";
        JavaRDD data = sc.textFile(path);
        JavaRDD parsedData = data.map((Function)new Function<String, LabeledPoint>(){

            public LabeledPoint call(String line) {
                String[] parts = line.split(" ");
                double[] v = new double[parts.length - 1];
                for (int i = 1; i < parts.length - 1; ++i) {
                    v[i - 1] = Double.parseDouble(parts[i].split(":")[1]);
                }
                return new LabeledPoint(Double.parseDouble(parts[0]), Vectors.dense((double[])v));
            }
        });
        parsedData.cache();
        int numIterations = 100;
        final LinearRegressionModel model = LinearRegressionWithSGD.train((RDD)JavaRDD.toRDD((JavaRDD)parsedData), (int)numIterations);
        JavaRDD valuesAndPreds = parsedData.map((Function)new Function<LabeledPoint, Tuple2<Object, Object>>(){

            public Tuple2<Object, Object> call(LabeledPoint point) {
                double prediction = model.predict(point.features());
                return new Tuple2((Object)prediction, (Object)point.label());
            }
        });
        RegressionMetrics metrics = new RegressionMetrics(valuesAndPreds.rdd());
        System.out.format("MSE = %f\n", metrics.meanSquaredError());
        System.out.format("RMSE = %f\n", metrics.rootMeanSquaredError());
        System.out.format("R Squared = %f\n", metrics.r2());
        System.out.format("MAE = %f\n", metrics.meanAbsoluteError());
        System.out.format("Explained Variance = %f\n", metrics.explainedVariance());
        model.save(sc.sc(), "target/tmp/LogisticRegressionModel");
        LinearRegressionModel sameModel = LinearRegressionModel.load((SparkContext)sc.sc(), (String)"target/tmp/LogisticRegressionModel");
        sc.stop();
    }
}

