/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.graphx;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.GraphOps;
import org.apache.spark.graphx.GraphXUtils$;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.graphx.PartitionStrategy$;
import org.apache.spark.graphx.util.GraphGenerators$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class SynthBenchmark$ {
    public static final SynthBenchmark$ MODULE$;

    static {
        new SynthBenchmark$();
    }

    public void main(String[] args) {
        Tuple2[] options = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])args).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String arg) {
                String[] stringArray = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(arg)).dropWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$1) {
                        return x$1 == '-';
                    }
                }))).split('=');
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String opt = (String)((SeqLike)option.get()).apply(0);
                    String v = (String)((SeqLike)option.get()).apply(1);
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opt), (Object)v);
                    return tuple2;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid argument: ").append((Object)arg).toString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        ObjectRef app = ObjectRef.create((Object)"pagerank");
        IntRef niter = IntRef.create((int)10);
        IntRef numVertices = IntRef.create((int)100000);
        ObjectRef numEPart = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef partitionStrategy = ObjectRef.create((Object)None$.MODULE$);
        DoubleRef mu = DoubleRef.create((double)4.0);
        DoubleRef sigma = DoubleRef.create((double)1.3);
        ObjectRef degFile = ObjectRef.create((Object)"");
        IntRef seed = IntRef.create((int)-1);
        Predef$.MODULE$.refArrayOps((Object[])options).foreach((Function1)new Serializable(app, niter, numVertices, numEPart, partitionStrategy, mu, sigma, degFile, seed){
            public static final long serialVersionUID = 0L;
            private final ObjectRef app$1;
            private final IntRef niter$1;
            private final IntRef numVertices$1;
            private final ObjectRef numEPart$1;
            private final ObjectRef partitionStrategy$1;
            private final DoubleRef mu$1;
            private final DoubleRef sigma$1;
            private final ObjectRef degFile$1;
            private final IntRef seed$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2;
                block13: {
                    block5: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block4: {
                                                        tuple2 = x0$1;
                                                        if (tuple2 == null) break block4;
                                                        String string = (String)tuple2._1();
                                                        String v = (String)tuple2._2();
                                                        if (!"app".equals(string)) break block4;
                                                        this.app$1.elem = v;
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block5;
                                                    }
                                                    if (tuple2 == null) break block6;
                                                    String string = (String)tuple2._1();
                                                    String v = (String)tuple2._2();
                                                    if (!"niters".equals(string)) break block6;
                                                    this.niter$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block5;
                                                }
                                                if (tuple2 == null) break block7;
                                                String string = (String)tuple2._1();
                                                String v = (String)tuple2._2();
                                                if (!"nverts".equals(string)) break block7;
                                                this.numVertices$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block5;
                                            }
                                            if (tuple2 == null) break block8;
                                            String string = (String)tuple2._1();
                                            String v = (String)tuple2._2();
                                            if (!"numEPart".equals(string)) break block8;
                                            this.numEPart$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(v)).toInt()));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block5;
                                        }
                                        if (tuple2 == null) break block9;
                                        String string = (String)tuple2._1();
                                        String v = (String)tuple2._2();
                                        if (!"partStrategy".equals(string)) break block9;
                                        this.partitionStrategy$1.elem = new Some((Object)PartitionStrategy$.MODULE$.fromString(v));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block5;
                                    }
                                    if (tuple2 == null) break block10;
                                    String string = (String)tuple2._1();
                                    String v = (String)tuple2._2();
                                    if (!"mu".equals(string)) break block10;
                                    this.mu$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toDouble();
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block5;
                                }
                                if (tuple2 == null) break block11;
                                String string = (String)tuple2._1();
                                String v = (String)tuple2._2();
                                if (!"sigma".equals(string)) break block11;
                                this.sigma$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toDouble();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block5;
                            }
                            if (tuple2 == null) break block12;
                            String string = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            if (!"degFile".equals(string)) break block12;
                            this.degFile$1.elem = v;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block5;
                        }
                        if (tuple2 == null) break block13;
                        String string = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        if (!"seed".equals(string)) break block13;
                        this.seed$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                if (tuple2 != null) {
                    String opt = (String)tuple2._1();
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid option: ").append((Object)opt).toString());
                }
                throw new MatchError(tuple2);
            }
            {
                this.app$1 = app$1;
                this.niter$1 = niter$1;
                this.numVertices$1 = numVertices$1;
                this.numEPart$1 = numEPart$1;
                this.partitionStrategy$1 = partitionStrategy$1;
                this.mu$1 = mu$1;
                this.sigma$1 = sigma$1;
                this.degFile$1 = degFile$1;
                this.seed$1 = seed$1;
            }
        });
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GraphX Synth Benchmark (nverts = ", ", app = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numVertices.elem), (String)app.elem})));
        GraphXUtils$.MODULE$.registerKryoClasses(conf);
        SparkContext sc = new SparkContext(conf);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating graph..."})).s((Seq)Nil$.MODULE$));
        Graph unpartitionedGraph = GraphGenerators$.MODULE$.logNormalGraph(sc, numVertices.elem, BoxesRunTime.unboxToInt((Object)((Option)numEPart.elem).getOrElse((Function0)new Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.sc$1.defaultParallelism();
            }
            {
                this.sc$1 = sc$1;
            }
        })), mu.elem, sigma.elem, (long)seed.elem);
        Graph graph = ((Graph)Option$.MODULE$.option2Iterable((Option)partitionStrategy.elem).foldLeft((Object)unpartitionedGraph, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Graph<Object, Object> apply(Graph<Object, Object> x$2, PartitionStrategy x$3) {
                return x$2.partitionBy(x$3);
            }
        })).cache();
        long startTime = System.currentTimeMillis();
        long numEdges = graph.edges().count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Done creating graph. Num Vertices = ", ", Num Edges = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numVertices.elem), BoxesRunTime.boxToLong((long)numEdges)})));
        long loadTime = System.currentTimeMillis() - startTime;
        if (!((String)degFile.elem).isEmpty()) {
            FileOutputStream fos = new FileOutputStream((String)degFile.elem);
            PrintWriter pos = new PrintWriter(fos);
            Map hist = graph.vertices().leftJoin((RDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int()).degrees(), (Function3)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(long id, long x$4, Option<Object> optDeg) {
                    return BoxesRunTime.unboxToInt((Object)optDeg.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }));
                }
            }, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> p) {
                    return p._2$mcI$sp();
                }
            }, ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
            hist.foreach((Function1)new Serializable(pos){
                public static final long serialVersionUID = 0L;
                private final PrintWriter pos$1;

                public final void apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int deg = tuple2._1$mcI$sp();
                        long count = tuple2._2$mcJ$sp();
                        this.pos$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " \\t ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)deg), BoxesRunTime.boxToLong((long)count)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.pos$1 = pos$1;
                }
            });
        }
        startTime = System.currentTimeMillis();
        String string = (String)app.elem;
        String string2 = "pagerank";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.println((Object)"Running PageRank");
            GraphOps qual$1 = Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int());
            int x$7 = niter.elem;
            double x$8 = qual$1.staticPageRank$default$2();
            double totalPR = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(qual$1.staticPageRank(x$7, x$8).vertices().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$5) {
                    return x$5._2$mcD$sp();
                }
            }, ClassTag$.MODULE$.Double())).sum();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total PageRank = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)totalPR)})));
        } else {
            String string3 = (String)app.elem;
            String string4 = "cc";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Predef$.MODULE$.println((Object)"Running Connected Components");
                long numComponents = Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int()).connectedComponents().vertices().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<Object, Object> x$6) {
                        return x$6._2$mcJ$sp();
                    }
                }, ClassTag$.MODULE$.apply(Long.TYPE)).distinct().count();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of components = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numComponents)})));
            }
        }
        long runTime = System.currentTimeMillis() - startTime;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Num Vertices = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numVertices.elem)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Num Edges = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numEdges)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creation time = ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)loadTime / 1000.0))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Run time = ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)runTime / 1000.0))})));
        sc.stop();
    }

    private SynthBenchmark$() {
        MODULE$ = this;
    }
}

