/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.hive;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class JavaSparkHiveExample {
    public static void main(String[] args) {
        String warehouseLocation = "spark-warehouse";
        SparkSession spark = SparkSession.builder().appName("Java Spark Hive Example").config("spark.sql.warehouse.dir", warehouseLocation).enableHiveSupport().getOrCreate();
        spark.sql("CREATE TABLE IF NOT EXISTS src (key INT, value STRING)");
        spark.sql("LOAD DATA LOCAL INPATH 'examples/src/main/resources/kv1.txt' INTO TABLE src");
        spark.sql("SELECT * FROM src").show();
        spark.sql("SELECT COUNT(*) FROM src").show();
        Dataset sqlDF = spark.sql("SELECT key, value FROM src WHERE key < 10 ORDER BY key");
        Dataset stringsDS = sqlDF.map((MapFunction)new MapFunction<Row, String>(){

            public String call(Row row) throws Exception {
                return "Key: " + row.get(0) + ", Value: " + row.get(1);
            }
        }, Encoders.STRING());
        stringsDS.show();
        ArrayList<Record> records = new ArrayList<Record>();
        for (int key = 1; key < 100; ++key) {
            Record record = new Record();
            record.setKey(key);
            record.setValue("val_" + key);
            records.add(record);
        }
        Dataset recordsDF = spark.createDataFrame(records, Record.class);
        recordsDF.createOrReplaceTempView("records");
        spark.sql("SELECT * FROM records r JOIN src s ON r.key = s.key").show();
        spark.stop();
    }

    public static class Record
    implements Serializable {
        private int key;
        private String value;

        public int getKey() {
            return this.key;
        }

        public void setKey(int key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

