/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.MinHashLSH;
import org.apache.spark.ml.feature.MinHashLSHModel;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaMinHashLSHExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaMinHashLSHExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0, Vectors.sparse((int)6, (int[])new int[]{0, 1, 2}, (double[])new double[]{1.0, 1.0, 1.0})}), RowFactory.create((Object[])new Object[]{1, Vectors.sparse((int)6, (int[])new int[]{2, 3, 4}, (double[])new double[]{1.0, 1.0, 1.0})}), RowFactory.create((Object[])new Object[]{2, Vectors.sparse((int)6, (int[])new int[]{0, 2, 4}, (double[])new double[]{1.0, 1.0, 1.0})}));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("keys", (DataType)new VectorUDT(), false, Metadata.empty())});
        Dataset dataFrame = spark.createDataFrame(data, schema);
        MinHashLSH mh = new MinHashLSH().setNumHashTables(1).setInputCol("keys").setOutputCol("values");
        MinHashLSHModel model = (MinHashLSHModel)mh.fit(dataFrame);
        model.transform(dataFrame).show();
        spark.stop();
    }
}

