/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GBTRegressor;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaGradientBoostedTreeRegressorExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaGradientBoostedTreeRegressorExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        Dataset[] splits = data.randomSplit(new double[]{0.7, 0.3});
        Dataset trainingData = splits[0];
        Dataset testData = splits[1];
        GBTRegressor gbt = ((GBTRegressor)((GBTRegressor)new GBTRegressor().setLabelCol("label")).setFeaturesCol("indexedFeatures")).setMaxIter(10);
        Pipeline pipeline = new Pipeline().setStages(new PipelineStage[]{featureIndexer, gbt});
        PipelineModel model = pipeline.fit(trainingData);
        Dataset predictions = model.transform(testData);
        predictions.select("prediction", new String[]{"label", "features"}).show(5);
        RegressionEvaluator evaluator = new RegressionEvaluator().setLabelCol("label").setPredictionCol("prediction").setMetricName("rmse");
        double rmse2 = evaluator.evaluate(predictions);
        System.out.println("Root Mean Squared Error (RMSE) on test data = " + rmse2);
        GBTRegressionModel gbtModel = (GBTRegressionModel)model.stages()[1];
        System.out.println("Learned regression GBT model:\n" + gbtModel.toDebugString());
        spark.stop();
    }
}

