/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SparkPageRank$ {
    public static final SparkPageRank$ MODULE$;

    static {
        new SparkPageRank$();
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of PageRank and is given as an example!\n        |Please use the PageRank implementation found in org.apache.spark.graphx.lib.PageRank\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: SparkPageRank <file> <iter>");
            System.exit(1);
        }
        this.showWarning();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SparkPageRank").getOrCreate();
        int iters = args.length > 1 ? new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt() : 10;
        RDD lines = spark.read().textFile(args[0]).rdd();
        RDD links = RDD$.MODULE$.rddToPairRDDFunctions(lines.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String s) {
                String[] parts = s.split("\\s+");
                return new Tuple2((Object)parts[0], (Object)parts[1]);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).distinct(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.String$.MODULE$).groupByKey().cache();
        ObjectRef ranks = ObjectRef.create((Object)RDD$.MODULE$.rddToPairRDDFunctions(links, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<String> v) {
                return 1.0;
            }
        }));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), iters).foreach$mVc$sp((Function1)new Serializable(links, ranks){
            public static final long serialVersionUID = 0L;
            private final RDD links$1;
            private final ObjectRef ranks$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RDD contribs = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(this.links$1, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).join((RDD)this.ranks$1.elem), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.String$.MODULE$).values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Tuple2<String, Object>> apply(Tuple2<Iterable<String>, Object> x0$1) {
                        Tuple2<Iterable<String>, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Iterable urls = (Iterable)tuple2._1();
                            double rank = tuple2._2$mcD$sp();
                            int size = urls.size();
                            Iterable iterable = (Iterable)urls.map((Function1)new Serializable(this, rank, size){
                                public static final long serialVersionUID = 0L;
                                private final double rank$1;
                                private final int size$1;

                                public final Tuple2<String, Object> apply(String url) {
                                    return new Tuple2((Object)url, (Object)BoxesRunTime.boxToDouble((double)(this.rank$1 / (double)this.size$1)));
                                }
                                {
                                    this.rank$1 = rank$1;
                                    this.size$1 = size$1;
                                }
                            }, Iterable$.MODULE$.canBuildFrom());
                            return iterable;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                this.ranks$1.elem = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(contribs, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Double(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$1, double x$2) {
                        return this.apply$mcDDD$sp(x$1, x$2);
                    }

                    public double apply$mcDDD$sp(double x$1, double x$2) {
                        return x$1 + x$2;
                    }
                }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Double(), (Ordering)Ordering.String$.MODULE$).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$3) {
                        return this.apply$mcDD$sp(x$3);
                    }

                    public double apply$mcDD$sp(double x$3) {
                        return 0.15 + 0.85 * x$3;
                    }
                });
            }
            {
                this.links$1 = links$1;
                this.ranks$1 = ranks$1;
            }
        });
        Tuple2[] output = (Tuple2[])((RDD)ranks.elem).collect();
        Predef$.MODULE$.refArrayOps((Object[])output).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, Object> tup) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)((String)tup._1())).append((Object)" has rank: ").append((Object)BoxesRunTime.boxToDouble((double)tup._2$mcD$sp())).append((Object)".").toString());
            }
        });
        spark.stop();
    }

    private SparkPageRank$() {
        MODULE$ = this;
    }
}

