/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class JavaSQLDataSourceExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("Java Spark SQL data sources example").config("spark.some.config.option", "some-value").getOrCreate();
        JavaSQLDataSourceExample.runBasicDataSourceExample(spark);
        JavaSQLDataSourceExample.runBasicParquetExample(spark);
        JavaSQLDataSourceExample.runParquetSchemaMergingExample(spark);
        JavaSQLDataSourceExample.runJsonDatasetExample(spark);
        JavaSQLDataSourceExample.runJdbcDatasetExample(spark);
        spark.stop();
    }

    private static void runBasicDataSourceExample(SparkSession spark) {
        Dataset usersDF = spark.read().load("examples/src/main/resources/users.parquet");
        usersDF.select("name", new String[]{"favorite_color"}).write().save("namesAndFavColors.parquet");
        Dataset peopleDF = spark.read().format("json").load("examples/src/main/resources/people.json");
        peopleDF.select("name", new String[]{"age"}).write().format("parquet").save("namesAndAges.parquet");
        Dataset sqlDF = spark.sql("SELECT * FROM parquet.`examples/src/main/resources/users.parquet`");
    }

    private static void runBasicParquetExample(SparkSession spark) {
        Dataset peopleDF = spark.read().json("examples/src/main/resources/people.json");
        peopleDF.write().parquet("people.parquet");
        Dataset parquetFileDF = spark.read().parquet("people.parquet");
        parquetFileDF.createOrReplaceTempView("parquetFile");
        Dataset namesDF = spark.sql("SELECT name FROM parquetFile WHERE age BETWEEN 13 AND 19");
        Dataset namesDS = namesDF.map((MapFunction)new MapFunction<Row, String>(){

            public String call(Row row) {
                return "Name: " + row.getString(0);
            }
        }, Encoders.STRING());
        namesDS.show();
    }

    private static void runParquetSchemaMergingExample(SparkSession spark) {
        ArrayList<Square> squares = new ArrayList<Square>();
        for (int value = 1; value <= 5; ++value) {
            Square square = new Square();
            square.setValue(value);
            square.setSquare(value * value);
            squares.add(square);
        }
        Dataset squaresDF = spark.createDataFrame(squares, Square.class);
        squaresDF.write().parquet("data/test_table/key=1");
        ArrayList<Cube> cubes = new ArrayList<Cube>();
        for (int value = 6; value <= 10; ++value) {
            Cube cube = new Cube();
            cube.setValue(value);
            cube.setCube(value * value * value);
            cubes.add(cube);
        }
        Dataset cubesDF = spark.createDataFrame(cubes, Cube.class);
        cubesDF.write().parquet("data/test_table/key=2");
        Dataset mergedDF = spark.read().option("mergeSchema", true).parquet("data/test_table");
        mergedDF.printSchema();
    }

    private static void runJsonDatasetExample(SparkSession spark) {
        Dataset people = spark.read().json("examples/src/main/resources/people.json");
        people.printSchema();
        people.createOrReplaceTempView("people");
        Dataset namesDF = spark.sql("SELECT name FROM people WHERE age BETWEEN 13 AND 19");
        namesDF.show();
        List<String> jsonData = Arrays.asList("{\"name\":\"Yin\",\"address\":{\"city\":\"Columbus\",\"state\":\"Ohio\"}}");
        JavaRDD anotherPeopleRDD = new JavaSparkContext(spark.sparkContext()).parallelize(jsonData);
        Dataset anotherPeople = spark.read().json(anotherPeopleRDD);
        anotherPeople.show();
    }

    private static void runJdbcDatasetExample(SparkSession spark) {
        Dataset jdbcDF = spark.read().format("jdbc").option("url", "jdbc:postgresql:dbserver").option("dbtable", "schema.tablename").option("user", "username").option("password", "password").load();
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", "username");
        connectionProperties.put("password", "password");
        Dataset jdbcDF2 = spark.read().jdbc("jdbc:postgresql:dbserver", "schema.tablename", connectionProperties);
        jdbcDF.write().format("jdbc").option("url", "jdbc:postgresql:dbserver").option("dbtable", "schema.tablename").option("user", "username").option("password", "password").save();
        jdbcDF2.write().jdbc("jdbc:postgresql:dbserver", "schema.tablename", connectionProperties);
    }

    public static class Cube
    implements Serializable {
        private int value;
        private int cube;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getCube() {
            return this.cube;
        }

        public void setCube(int cube) {
            this.cube = cube;
        }
    }

    public static class Square
    implements Serializable {
        private int value;
        private int square;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getSquare() {
            return this.square;
        }

        public void setSquare(int square) {
            this.square = square;
        }
    }
}

