/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class JavaLinearRegressionWithSGDExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaLinearRegressionWithSGDExample");
        JavaSparkContext sc = new JavaSparkContext(conf);
        String path = "data/mllib/ridge-data/lpsa.data";
        JavaRDD data = sc.textFile(path);
        JavaRDD parsedData = data.map((Function)new Function<String, LabeledPoint>(){

            public LabeledPoint call(String line) {
                String[] parts = line.split(",");
                String[] features = parts[1].split(" ");
                double[] v = new double[features.length];
                for (int i = 0; i < features.length - 1; ++i) {
                    v[i] = Double.parseDouble(features[i]);
                }
                return new LabeledPoint(Double.parseDouble(parts[0]), Vectors.dense((double[])v));
            }
        });
        parsedData.cache();
        int numIterations = 100;
        double stepSize = 1.0E-8;
        final LinearRegressionModel model = LinearRegressionWithSGD.train((RDD)JavaRDD.toRDD((JavaRDD)parsedData), (int)numIterations, (double)stepSize);
        JavaRDD valuesAndPreds = parsedData.map((Function)new Function<LabeledPoint, Tuple2<Double, Double>>(){

            public Tuple2<Double, Double> call(LabeledPoint point) {
                double prediction = model.predict(point.features());
                return new Tuple2((Object)prediction, (Object)point.label());
            }
        });
        double MSE = new JavaDoubleRDD(valuesAndPreds.map((Function)new Function<Tuple2<Double, Double>, Object>(){

            public Object call(Tuple2<Double, Double> pair) {
                return Math.pow((Double)pair._1() - (Double)pair._2(), 2.0);
            }
        }).rdd()).mean();
        System.out.println("training Mean Squared Error = " + MSE);
        model.save(sc.sc(), "target/tmp/javaLinearRegressionWithSGDModel");
        LinearRegressionModel sameModel = LinearRegressionModel.load((SparkContext)sc.sc(), (String)"target/tmp/javaLinearRegressionWithSGDModel");
        sc.stop();
    }
}

