/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.spark.SparkConf;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.examples.streaming.DroppedWordsCounter$;
import org.apache.spark.examples.streaming.WordBlacklist$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.LongAccumulator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RecoverableNetworkWordCount$ {
    public static final RecoverableNetworkWordCount$ MODULE$;

    static {
        new RecoverableNetworkWordCount$();
    }

    public StreamingContext createContext(String ip, int port, String outputPath, String checkpointDirectory) {
        Predef$.MODULE$.println((Object)"Creating new context");
        File outputFile = new File(outputPath);
        Object object = outputFile.exists() ? BoxesRunTime.boxToBoolean((boolean)outputFile.delete()) : BoxedUnit.UNIT;
        SparkConf sparkConf = new SparkConf().setAppName("RecoverableNetworkWordCount");
        StreamingContext ssc = new StreamingContext(sparkConf, Seconds$.MODULE$.apply(1L));
        ssc.checkpoint(checkpointDirectory);
        ReceiverInputDStream lines = ssc.socketTextStream(ip, port, ssc.socketTextStream$default$3());
        DStream words = lines.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.split(" "));
            }
        }, ClassTag$.MODULE$.apply(String.class));
        DStream wordCounts = DStream$.MODULE$.toPairDStreamFunctions(words.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String x$2) {
                return new Tuple2((Object)x$2, (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$3, int x$4) {
                return this.apply$mcIII$sp(x$3, x$4);
            }

            public int apply$mcIII$sp(int x$3, int x$4) {
                return x$3 + x$4;
            }
        });
        wordCounts.foreachRDD((Function2)new Serializable(outputFile){
            public static final long serialVersionUID = 0L;
            private final File outputFile$1;

            public final void apply(RDD<Tuple2<String, Object>> rdd, Time time) {
                Broadcast<Seq<String>> blacklist = WordBlacklist$.MODULE$.getInstance(rdd.sparkContext());
                LongAccumulator droppedWordsCounter = DroppedWordsCounter$.MODULE$.getInstance(rdd.sparkContext());
                String counts = Predef$.MODULE$.refArrayOps((Object[])rdd.filter((Function1)new Serializable(this, blacklist, droppedWordsCounter){
                    public static final long serialVersionUID = 0L;
                    private final Broadcast blacklist$1;
                    private final LongAccumulator droppedWordsCounter$1;

                    public final boolean apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            boolean bl;
                            String word = (String)tuple2._1();
                            int count = tuple2._2$mcI$sp();
                            if (((SeqLike)this.blacklist$1.value()).contains((Object)word)) {
                                this.droppedWordsCounter$1.add((long)count);
                                bl = false;
                            } else {
                                bl = true;
                            }
                            boolean bl2 = bl;
                            return bl2;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.blacklist$1 = blacklist$1;
                        this.droppedWordsCounter$1 = droppedWordsCounter$1;
                    }
                }).collect()).mkString("[", ", ", "]");
                String output = new StringBuilder().append((Object)"Counts at time ").append((Object)time).append((Object)" ").append((Object)counts).toString();
                Predef$.MODULE$.println((Object)output);
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dropped ").append((Object)droppedWordsCounter.value()).append((Object)" word(s) totally").toString());
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Appending to ").append((Object)this.outputFile$1.getAbsolutePath()).toString());
                Files.append((CharSequence)new StringBuilder().append((Object)output).append((Object)"\n").toString(), (File)this.outputFile$1, (Charset)Charset.defaultCharset());
            }
            {
                this.outputFile$1 = outputFile$1;
            }
        });
        return ssc;
    }

    public void main(String[] args) {
        String[] stringArray;
        Option option;
        if (args.length != 4) {
            System.err.println(new StringBuilder().append((Object)"Your arguments were ").append((Object)Predef$.MODULE$.refArrayOps((Object[])args).mkString("[", ", ", "]")).toString());
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("\n          |Usage: RecoverableNetworkWordCount <hostname> <port> <checkpoint-directory>\n          |     <output-file>. <hostname> and <port> describe the TCP server that Spark\n          |     Streaming would connect to receive data. <checkpoint-directory> directory to\n          |     HDFS-compatible file system which checkpoint data <output-file> file to which the\n          |     word counts will be appended\n          |\n          |In local mode, <master> should be 'local[n]' with n > 1\n          |Both <checkpoint-directory> and <output-file> must be absolute paths\n        ")).stripMargin());
            System.exit(1);
        }
        if (!(option = Array$.MODULE$.unapplySeq((Object)(stringArray = args))).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
            String ip = (String)((SeqLike)option.get()).apply(0);
            String string = (String)((SeqLike)option.get()).apply(1);
            String checkpointDirectory = (String)((SeqLike)option.get()).apply(2);
            String outputPath = (String)((SeqLike)option.get()).apply(3);
            Option option2 = IntParam$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                Tuple4 tuple4;
                int port = BoxesRunTime.unboxToInt((Object)option2.get());
                Tuple4 tuple42 = tuple4 = new Tuple4((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port), (Object)checkpointDirectory, (Object)outputPath);
                String ip2 = (String)tuple42._1();
                int port2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
                String checkpointDirectory2 = (String)tuple42._3();
                String outputPath2 = (String)tuple42._4();
                StreamingContext ssc = StreamingContext$.MODULE$.getOrCreate(checkpointDirectory2, (Function0)new Serializable(ip2, port2, checkpointDirectory2, outputPath2){
                    public static final long serialVersionUID = 0L;
                    private final String ip$1;
                    private final int port$1;
                    private final String checkpointDirectory$1;
                    private final String outputPath$1;

                    public final StreamingContext apply() {
                        return RecoverableNetworkWordCount$.MODULE$.createContext(this.ip$1, this.port$1, this.outputPath$1, this.checkpointDirectory$1);
                    }
                    {
                        this.ip$1 = ip$1;
                        this.port$1 = port$1;
                        this.checkpointDirectory$1 = checkpointDirectory$1;
                        this.outputPath$1 = outputPath$1;
                    }
                }, StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4());
                ssc.start();
                ssc.awaitTermination();
                return;
            }
        }
        throw new MatchError((Object)stringArray);
    }

    private RecoverableNetworkWordCount$() {
        MODULE$ = this;
    }
}

