/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.mllib.feature.ChiSqSelector;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils;

public class JavaChiSqSelectorExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaChiSqSelectorExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        JavaRDD points = MLUtils.loadLibSVMFile((SparkContext)jsc.sc(), (String)"data/mllib/sample_libsvm_data.txt").toJavaRDD().cache();
        JavaRDD discretizedData = points.map((Function)new Function<LabeledPoint, LabeledPoint>(){

            public LabeledPoint call(LabeledPoint lp) {
                double[] discretizedFeatures = new double[lp.features().size()];
                for (int i = 0; i < lp.features().size(); ++i) {
                    discretizedFeatures[i] = Math.floor(lp.features().apply(i) / 16.0);
                }
                return new LabeledPoint(lp.label(), Vectors.dense((double[])discretizedFeatures));
            }
        });
        ChiSqSelector selector = new ChiSqSelector(50);
        final ChiSqSelectorModel transformer = selector.fit(discretizedData.rdd());
        JavaRDD filteredData = discretizedData.map((Function)new Function<LabeledPoint, LabeledPoint>(){

            public LabeledPoint call(LabeledPoint lp) {
                return new LabeledPoint(lp.label(), transformer.transform(lp.features()));
            }
        });
        System.out.println("filtered data: ");
        filteredData.foreach((VoidFunction)new VoidFunction<LabeledPoint>(){

            public void call(LabeledPoint labeledPoint) throws Exception {
                System.out.println(labeledPoint.toString());
            }
        });
        jsc.stop();
    }
}

