/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.apache.spark.ml.classification.GBTClassifier;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class GradientBoostedTreeClassifierExample$ {
    public static final GradientBoostedTreeClassifierExample$ MODULE$;

    static {
        new GradientBoostedTreeClassifierExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("GradientBoostedTreeClassifierExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel").fit(data);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        Dataset[] datasetArray = data.randomSplit(new double[]{0.7, 0.3});
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset trainingData = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset testData = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)trainingData, (Object)testData);
            Dataset trainingData2 = (Dataset)tuple22._1();
            Dataset testData2 = (Dataset)tuple22._2();
            GBTClassifier gbt = ((GBTClassifier)new GBTClassifier().setLabelCol("indexedLabel").setFeaturesCol("indexedFeatures")).setMaxIter(10);
            IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, gbt, labelConverter}));
            PipelineModel model = pipeline.fit(trainingData2);
            Dataset predictions = model.transform(testData2);
            predictions.select("predictedLabel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"})).show(5);
            MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction").setMetricName("accuracy");
            double accuracy = evaluator.evaluate(predictions);
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Test Error = ").append((Object)BoxesRunTime.boxToDouble((double)(1.0 - accuracy))).toString());
            GBTClassificationModel gbtModel = (GBTClassificationModel)model.stages()[2];
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Learned classification GBT model:\n").append((Object)gbtModel.toDebugString()).toString());
            spark.stop();
            return;
        }
        throw new MatchError((Object)datasetArray);
    }

    private GradientBoostedTreeClassifierExample$() {
        MODULE$ = this;
    }
}

