/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import scala.Tuple2;

public class JavaLatentDirichletAllocationExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaKLatentDirichletAllocationExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        String path = "data/mllib/sample_lda_data.txt";
        JavaRDD data = jsc.textFile(path);
        JavaRDD parsedData = data.map((Function)new Function<String, Vector>(){

            public Vector call(String s) {
                String[] sarray = s.trim().split(" ");
                double[] values = new double[sarray.length];
                for (int i = 0; i < sarray.length; ++i) {
                    values[i] = Double.parseDouble(sarray[i]);
                }
                return Vectors.dense((double[])values);
            }
        });
        JavaPairRDD corpus = JavaPairRDD.fromJavaRDD((JavaRDD)parsedData.zipWithIndex().map((Function)new Function<Tuple2<Vector, Long>, Tuple2<Long, Vector>>(){

            public Tuple2<Long, Vector> call(Tuple2<Vector, Long> doc_id) {
                return doc_id.swap();
            }
        }));
        corpus.cache();
        LDAModel ldaModel = new LDA().setK(3).run(corpus);
        System.out.println("Learned topics (as distributions over vocab of " + ldaModel.vocabSize() + " words):");
        Matrix topics = ldaModel.topicsMatrix();
        for (int topic = 0; topic < 3; ++topic) {
            System.out.print("Topic " + topic + ":");
            for (int word = 0; word < ldaModel.vocabSize(); ++word) {
                System.out.print(" " + topics.apply(word, topic));
            }
            System.out.println();
        }
        ldaModel.save(jsc.sc(), "target/org/apache/spark/JavaLatentDirichletAllocationExample/LDAModel");
        DistributedLDAModel sameModel = DistributedLDAModel.load((SparkContext)jsc.sc(), (String)"target/org/apache/spark/JavaLatentDirichletAllocationExample/LDAModel");
        jsc.stop();
    }
}

