/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQuery;

public final class JavaStructuredKafkaWordCount {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: JavaStructuredKafkaWordCount <bootstrap-servers> <subscribe-type> <topics>");
            System.exit(1);
        }
        String bootstrapServers = args[0];
        String subscribeType = args[1];
        String topics = args[2];
        SparkSession spark = SparkSession.builder().appName("JavaStructuredKafkaWordCount").getOrCreate();
        Dataset lines = spark.readStream().format("kafka").option("kafka.bootstrap.servers", bootstrapServers).option(subscribeType, topics).load().selectExpr(new String[]{"CAST(value AS STRING)"}).as(Encoders.STRING());
        Dataset wordCounts = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterator<String> call(String x) {
                return Arrays.asList(x.split(" ")).iterator();
            }
        }, Encoders.STRING()).groupBy("value", new String[0]).count();
        StreamingQuery query = wordCounts.writeStream().outputMode("complete").format("console").start();
        query.awaitTermination();
    }
}

