/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MulticlassMetricsExample$ {
    public static final MulticlassMetricsExample$ MODULE$;

    static {
        new MulticlassMetricsExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("MulticlassMetricsExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_multiclass_classification_data.txt");
        RDD[] rDDArray = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        Option option = Array$.MODULE$.unapplySeq((Object)rDDArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            RDD training = (RDD)((SeqLike)option.get()).apply(0);
            RDD test = (RDD)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)training, (Object)test);
            RDD training2 = (RDD)tuple22._1();
            RDD test2 = (RDD)tuple22._2();
            training2.cache();
            LogisticRegressionModel model = new LogisticRegressionWithLBFGS().setNumClasses(3).run(training2);
            RDD predictionAndLabels = test2.map((Function1)new Serializable(model){
                public static final long serialVersionUID = 0L;
                private final LogisticRegressionModel model$1;

                public final Tuple2<Object, Object> apply(LabeledPoint x0$1) {
                    LabeledPoint labeledPoint = x0$1;
                    if (labeledPoint != null) {
                        double label = labeledPoint.label();
                        Vector features = labeledPoint.features();
                        double prediction = this.model$1.predict(features);
                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(prediction, label);
                        return sp2;
                    }
                    throw new MatchError((Object)labeledPoint);
                }
                {
                    this.model$1 = model$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            MulticlassMetrics metrics = new MulticlassMetrics(predictionAndLabels);
            Predef$.MODULE$.println((Object)"Confusion matrix:");
            Predef$.MODULE$.println((Object)metrics.confusionMatrix());
            double accuracy = metrics.accuracy();
            Predef$.MODULE$.println((Object)"Summary Statistics");
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)accuracy)})));
            double[] labels = metrics.labels();
            Predef$.MODULE$.doubleArrayOps(labels).foreach((Function1)new Serializable(metrics){
                public static final long serialVersionUID = 0L;
                private final MulticlassMetrics metrics$1;

                public final void apply(double l) {
                    this.apply$mcVD$sp(l);
                }

                public void apply$mcVD$sp(double l) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Precision(", ") = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)l)}))).append((Object)BoxesRunTime.boxToDouble((double)this.metrics$1.precision(l))).toString());
                }
                {
                    this.metrics$1 = metrics$1;
                }
            });
            Predef$.MODULE$.doubleArrayOps(labels).foreach((Function1)new Serializable(metrics){
                public static final long serialVersionUID = 0L;
                private final MulticlassMetrics metrics$1;

                public final void apply(double l) {
                    this.apply$mcVD$sp(l);
                }

                public void apply$mcVD$sp(double l) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recall(", ") = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)l)}))).append((Object)BoxesRunTime.boxToDouble((double)this.metrics$1.recall(l))).toString());
                }
                {
                    this.metrics$1 = metrics$1;
                }
            });
            Predef$.MODULE$.doubleArrayOps(labels).foreach((Function1)new Serializable(metrics){
                public static final long serialVersionUID = 0L;
                private final MulticlassMetrics metrics$1;

                public final void apply(double l) {
                    this.apply$mcVD$sp(l);
                }

                public void apply$mcVD$sp(double l) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FPR(", ") = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)l)}))).append((Object)BoxesRunTime.boxToDouble((double)this.metrics$1.falsePositiveRate(l))).toString());
                }
                {
                    this.metrics$1 = metrics$1;
                }
            });
            Predef$.MODULE$.doubleArrayOps(labels).foreach((Function1)new Serializable(metrics){
                public static final long serialVersionUID = 0L;
                private final MulticlassMetrics metrics$1;

                public final void apply(double l) {
                    this.apply$mcVD$sp(l);
                }

                public void apply$mcVD$sp(double l) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"F1-Score(", ") = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)l)}))).append((Object)BoxesRunTime.boxToDouble((double)this.metrics$1.fMeasure(l))).toString());
                }
                {
                    this.metrics$1 = metrics$1;
                }
            });
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weighted precision: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.weightedPrecision())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weighted recall: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.weightedRecall())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weighted F1 score: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.weightedFMeasure())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weighted false positive rate: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.weightedFalsePositiveRate())})));
            return;
        }
        throw new MatchError((Object)rDDArray);
    }

    private MulticlassMetricsExample$() {
        MODULE$ = this;
    }
}

