/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.mllib.feature.ElementwiseProduct;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;

public class JavaElementwiseProductExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaElementwiseProductExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        JavaRDD data = jsc.parallelize(Arrays.asList(Vectors.dense((double)1.0, (double[])new double[]{2.0, 3.0}), Vectors.dense((double)4.0, (double[])new double[]{5.0, 6.0})));
        Vector transformingVector = Vectors.dense((double)0.0, (double[])new double[]{1.0, 2.0});
        final ElementwiseProduct transformer = new ElementwiseProduct(transformingVector);
        JavaRDD transformedData = transformer.transform(data);
        JavaRDD transformedData2 = data.map((Function)new Function<Vector, Vector>(){

            public Vector call(Vector v) {
                return transformer.transform(v);
            }
        });
        System.out.println("transformedData: ");
        transformedData.foreach((VoidFunction)new VoidFunction<Vector>(){

            public void call(Vector vector) throws Exception {
                System.out.println(vector.toString());
            }
        });
        System.out.println("transformedData2: ");
        transformedData2.foreach((VoidFunction)new VoidFunction<Vector>(){

            public void call(Vector vector) throws Exception {
                System.out.println(vector.toString());
            }
        });
        jsc.stop();
    }
}

