/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class NaiveBayesExample$ {
    public static final NaiveBayesExample$ MODULE$;

    static {
        new NaiveBayesExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("NaiveBayesExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        Dataset[] datasetArray = data.randomSplit(new double[]{0.7, 0.3}, 1234L);
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset trainingData = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset testData = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)trainingData, (Object)testData);
            Dataset trainingData2 = (Dataset)tuple22._1();
            Dataset testData2 = (Dataset)tuple22._2();
            NaiveBayesModel model = (NaiveBayesModel)new NaiveBayes().fit(trainingData2);
            Dataset predictions = model.transform(testData2);
            predictions.show();
            MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setLabelCol("label").setPredictionCol("prediction").setMetricName("accuracy");
            double accuracy = evaluator.evaluate(predictions);
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Test set accuracy = ").append((Object)BoxesRunTime.boxToDouble((double)accuracy)).toString());
            spark.stop();
            return;
        }
        throw new MatchError((Object)datasetArray);
    }

    private NaiveBayesExample$() {
        MODULE$ = this;
    }
}

