/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming.clickstream;

import org.apache.spark.SparkContext;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.examples.streaming.clickstream.PageView;
import org.apache.spark.examples.streaming.clickstream.PageView$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PageViewStream$ {
    public static final PageViewStream$ MODULE$;

    static {
        new PageViewStream$();
    }

    public void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: PageViewStream <metric> <host> <port>");
            System.err.println("<metric> must be one of pageCounts, slidingPageCounts, errorRatePerZipCode, activeUserCount, popularUsersSeen");
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String metric = args[0];
        String host = args[1];
        int port = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        StreamingContext ssc = new StreamingContext("local[2]", "PageViewStream", Seconds$.MODULE$.apply(1L), System.getenv("SPARK_HOME"), Option$.MODULE$.option2Iterable(StreamingContext$.MODULE$.jarOfClass(this.getClass())).toSeq(), StreamingContext$.MODULE$.$lessinit$greater$default$6());
        DStream pageViews = ssc.socketTextStream(host, port, ssc.socketTextStream$default$3()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.split("\n"));
            }
        }, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PageView apply(String x$2) {
                return PageView$.MODULE$.fromString(x$2);
            }
        }, ClassTag$.MODULE$.apply(PageView.class));
        DStream qual$1 = pageViews.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(PageView view) {
                return view.url();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        int x$6 = qual$1.countByValue$default$1();
        DStream pageCounts = qual$1.countByValue(x$6, (Ordering)Ordering.String$.MODULE$);
        DStream qual$2 = pageViews.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(PageView view) {
                return view.url();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        Duration x$7 = Seconds$.MODULE$.apply(10L);
        Duration x$8 = Seconds$.MODULE$.apply(2L);
        int x$9 = qual$2.countByValueAndWindow$default$3();
        DStream slidingPageCounts = qual$2.countByValueAndWindow(x$7, x$8, x$9, (Ordering)Ordering.String$.MODULE$);
        DStream statusesPerZipCode = DStream$.MODULE$.toPairDStreamFunctions(pageViews.window(Seconds$.MODULE$.apply(30L), Seconds$.MODULE$.apply(2L)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(PageView view) {
                return new Tuple2.mcII.sp(view.zipCode(), view.status());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).groupByKey();
        DStream errorRatePerZipCode = statusesPerZipCode.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, Iterable<Object>> x0$1) {
                Tuple2<Object, Iterable<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int zip = tuple2._1$mcI$sp();
                    Iterable statuses = (Iterable)tuple2._2();
                    int normalCount = statuses.count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x$3) {
                            return this.apply$mcZI$sp(x$3);
                        }

                        public boolean apply$mcZI$sp(int x$3) {
                            return x$3 == 200;
                        }
                    });
                    int errorCount = statuses.size() - normalCount;
                    float errorRatio = (float)errorCount / (float)statuses.size();
                    String string = (double)errorRatio > 0.05 ? new StringOps(Predef$.MODULE$.augmentString("%s: **%s**")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)zip), BoxesRunTime.boxToFloat((float)errorRatio)})) : new StringOps(Predef$.MODULE$.augmentString("%s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)zip), BoxesRunTime.boxToFloat((float)errorRatio)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(String.class));
        DStream activeUserCount = DStream$.MODULE$.toPairDStreamFunctions(pageViews.window(Seconds$.MODULE$.apply(15L), Seconds$.MODULE$.apply(2L)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(PageView view) {
                return new Tuple2.mcII.sp(view.userID(), 1);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).groupByKey().count().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(long x$4) {
                return new StringBuilder().append((Object)"Unique active users: ").append((Object)BoxesRunTime.boxToLong((long)x$4)).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        SparkContext qual$3 = ssc.sparkContext();
        Seq x$10 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"Patrick Wendell"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"Reynold Xin"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"Matei Zaharia")}));
        int x$11 = qual$3.parallelize$default$2();
        RDD userList = qual$3.parallelize(x$10, x$11, ClassTag$.MODULE$.apply(Tuple2.class));
        String string = metric;
        if ("pageCounts".equals(string)) {
            pageCounts.print();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("slidingPageCounts".equals(string)) {
            slidingPageCounts.print();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("errorRatePerZipCode".equals(string)) {
            errorRatePerZipCode.print();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("activeUserCount".equals(string)) {
            activeUserCount.print();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("popularUsersSeen".equals(string)) {
            pageViews.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(PageView view) {
                    return new Tuple2.mcII.sp(view.userID(), 1);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).foreachRDD((Function2)new Serializable(userList){
                public static final long serialVersionUID = 0L;
                private final RDD userList$1;

                public final void apply(RDD<Tuple2<Object, Object>> rdd, Time time) {
                    Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(rdd, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).join(this.userList$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, Tuple2<Object, String>> x$5) {
                            return (String)((Tuple2)x$5._2())._2();
                        }
                    }, ClassTag$.MODULE$.apply(String.class)).take(10)).foreach((Function1)new Serializable(this, time){
                        public static final long serialVersionUID = 0L;
                        private final Time time$1;

                        public final void apply(String u) {
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Saw user %s at time %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{u, this.time$1})));
                        }
                        {
                            this.time$1 = time$1;
                        }
                    });
                }
                {
                    this.userList$1 = userList$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Invalid metric entered: ").append((Object)metric).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ssc.start();
        ssc.awaitTermination();
    }

    private PageViewStream$() {
        MODULE$ = this;
    }
}

