/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.clustering.BisectingKMeans;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;

public class JavaBisectingKMeansExample {
    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaBisectingKMeansExample");
        JavaSparkContext sc = new JavaSparkContext(sparkConf);
        ArrayList localData = Lists.newArrayList((Object[])new Vector[]{Vectors.dense((double)0.1, (double[])new double[]{0.1}), Vectors.dense((double)0.3, (double[])new double[]{0.3}), Vectors.dense((double)10.1, (double[])new double[]{10.1}), Vectors.dense((double)10.3, (double[])new double[]{10.3}), Vectors.dense((double)20.1, (double[])new double[]{20.1}), Vectors.dense((double)20.3, (double[])new double[]{20.3}), Vectors.dense((double)30.1, (double[])new double[]{30.1}), Vectors.dense((double)30.3, (double[])new double[]{30.3})});
        JavaRDD data = sc.parallelize((List)localData, 2);
        BisectingKMeans bkm = new BisectingKMeans().setK(4);
        BisectingKMeansModel model = bkm.run(data);
        System.out.println("Compute Cost: " + model.computeCost(data));
        Vector[] clusterCenters = model.clusterCenters();
        for (int i = 0; i < clusterCenters.length; ++i) {
            Vector clusterCenter = clusterCenters[i];
            System.out.println("Cluster Center " + i + ": " + clusterCenter);
        }
        sc.stop();
    }
}

