/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;

public final class NaiveBayesExample$ {
    public static final NaiveBayesExample$ MODULE$;

    static {
        new NaiveBayesExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("NaiveBayesExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] rDDArray = data.randomSplit(new double[]{0.6, 0.4}, data.randomSplit$default$2());
        Option option = Array$.MODULE$.unapplySeq((Object)rDDArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            RDD training = (RDD)((SeqLike)option.get()).apply(0);
            RDD test = (RDD)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)training, (Object)test);
            RDD training2 = (RDD)tuple22._1();
            RDD test2 = (RDD)tuple22._2();
            NaiveBayesModel model = NaiveBayes$.MODULE$.train(training2, 1.0, "multinomial");
            RDD predictionAndLabel = test2.map((Function1)new Serializable(model){
                public static final long serialVersionUID = 0L;
                private final NaiveBayesModel model$1;

                public final Tuple2<Object, Object> apply(LabeledPoint p) {
                    return new Tuple2.mcDD.sp(this.model$1.predict(p.features()), p.label());
                }
                {
                    this.model$1 = model$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            double accuracy = 1.0 * (double)predictionAndLabel.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> x) {
                    return x._1$mcD$sp() == x._2$mcD$sp();
                }
            }).count() / (double)test2.count();
            model.save(sc, "target/tmp/myNaiveBayesModel");
            NaiveBayesModel sameModel = NaiveBayesModel$.MODULE$.load(sc, "target/tmp/myNaiveBayesModel");
            return;
        }
        throw new MatchError((Object)rDDArray);
    }

    private NaiveBayesExample$() {
        MODULE$ = this;
    }
}

