/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.squaredDistance$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class SparkKMeans$ {
    public static final SparkKMeans$ MODULE$;

    static {
        new SparkKMeans$();
    }

    public Vector<Object> parseVector(String line) {
        return DenseVector$.MODULE$.apply$mDc$sp((double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line)).split(' ')).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public int closestPoint(Vector<Object> p, Vector<Object>[] centers) {
        IntRef bestIndex = IntRef.create((int)0);
        DoubleRef closest = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), centers.length).foreach$mVc$sp((Function1)new Serializable(p, centers, bestIndex, closest){
            public static final long serialVersionUID = 0L;
            private final Vector p$1;
            private final Vector[] centers$1;
            private final IntRef bestIndex$1;
            private final DoubleRef closest$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                double tempDist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)this.p$1, (Object)this.centers$1[i], squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)Vector$.MODULE$.zipValuesImpl_V_V_Double())));
                if (tempDist < this.closest$1.elem) {
                    this.closest$1.elem = tempDist;
                    this.bestIndex$1.elem = i;
                }
            }
            {
                this.p$1 = p$1;
                this.centers$1 = centers$1;
                this.bestIndex$1 = bestIndex$1;
                this.closest$1 = closest$1;
            }
        });
        return bestIndex.elem;
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of KMeans Clustering and is given as an example!\n        |Please use org.apache.spark.ml.clustering.KMeans\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: SparkKMeans <file> <k> <convergeDist>");
            System.exit(1);
        }
        this.showWarning();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SparkKMeans").getOrCreate();
        RDD lines = spark.read().textFile(args[0]).rdd();
        RDD data = lines.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector<Object> apply(String line) {
                return SparkKMeans$.MODULE$.parseVector(line);
            }
        }, ClassTag$.MODULE$.apply(Vector.class)).cache();
        int K = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        double convergeDist = new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble();
        Vector[] kPoints = (Vector[])data.takeSample(false, K, 42L);
        DoubleRef tempDist = DoubleRef.create((double)1.0);
        while (tempDist.elem > convergeDist) {
            RDD closest = data.map((Function1)new Serializable(kPoints){
                public static final long serialVersionUID = 0L;
                private final Vector[] kPoints$1;

                public final Tuple2<Object, Tuple2<Vector<Object>, Object>> apply(Vector<Object> p) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)SparkKMeans$.MODULE$.closestPoint(p, this.kPoints$1)), (Object)new Tuple2(p, (Object)BoxesRunTime.boxToInteger((int)1)));
                }
                {
                    this.kPoints$1 = kPoints$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD pointStats = RDD$.MODULE$.rddToPairRDDFunctions(closest, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Vector<Object>, Object> apply(Tuple2<Vector<Object>, Object> x0$1, Tuple2<Vector<Object>, Object> x1$1) {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Tuple2 tuple23 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            Vector p1 = (Vector)tuple22._1();
                            int c1 = tuple22._2$mcI$sp();
                            if (tuple23 != null) {
                                Vector p2 = (Vector)tuple23._1();
                                int c2 = tuple23._2$mcI$sp();
                                Tuple2 tuple24 = new Tuple2(p1.$plus((Object)p2, (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd()), (Object)BoxesRunTime.boxToInteger((int)(c1 + c2)));
                                return tuple24;
                            }
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
            });
            Map newPoints = RDD$.MODULE$.rddToPairRDDFunctions(pointStats.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Vector<Object>> apply(Tuple2<Object, Tuple2<Vector<Object>, Object>> pair) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)pair._1$mcI$sp()), ((ImmutableNumericOps)((Tuple2)pair._2())._1()).$times((Object)BoxesRunTime.boxToDouble((double)(1.0 / (double)((Tuple2)pair._2())._2$mcI$sp())), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()));
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            tempDist.elem = 0.0;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), K).foreach$mVc$sp((Function1)new Serializable(kPoints, tempDist, newPoints){
                public static final long serialVersionUID = 0L;
                private final Vector[] kPoints$1;
                private final DoubleRef tempDist$1;
                private final Map newPoints$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.tempDist$1.elem += BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)this.kPoints$1[i], this.newPoints$1.apply((Object)BoxesRunTime.boxToInteger((int)i)), squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)Vector$.MODULE$.zipValuesImpl_V_V_Double())));
                }
                {
                    this.kPoints$1 = kPoints$1;
                    this.tempDist$1 = tempDist$1;
                    this.newPoints$1 = newPoints$1;
                }
            });
            newPoints.foreach((Function1)new Serializable(kPoints){
                public static final long serialVersionUID = 0L;
                private final Vector[] kPoints$1;

                public final void apply(Tuple2<Object, Vector<Object>> newP) {
                    this.kPoints$1[newP._1$mcI$sp()] = (Vector)newP._2();
                }
                {
                    this.kPoints$1 = kPoints$1;
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Finished iteration (delta = ").append((Object)BoxesRunTime.boxToDouble((double)tempDist.elem)).append((Object)")").toString());
        }
        Predef$.MODULE$.println((Object)"Final centers:");
        Predef$.MODULE$.refArrayOps((Object[])kPoints).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        spark.stop();
    }

    private SparkKMeans$() {
        MODULE$ = this;
    }
}

