/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionModel$;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LinearRegressionWithSGDExample$ {
    public static final LinearRegressionWithSGDExample$ MODULE$;

    static {
        new LinearRegressionWithSGDExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("LinearRegressionWithSGDExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/ridge-data/lpsa.data", sc.textFile$default$2());
        RDD parsedData = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String line) {
                String[] parts = new StringOps(Predef$.MODULE$.augmentString(line)).split(',');
                return new LabeledPoint(new StringOps(Predef$.MODULE$.augmentString(parts[0])).toDouble(), Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(parts[1])).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
        int numIterations = 100;
        double stepSize = 1.0E-8;
        LinearRegressionModel model = LinearRegressionWithSGD$.MODULE$.train(parsedData, numIterations, stepSize);
        RDD valuesAndPreds = parsedData.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final LinearRegressionModel model$1;

            public final Tuple2<Object, Object> apply(LabeledPoint point) {
                double prediction = this.model$1.predict(point.features());
                return new Tuple2.mcDD.sp(point.label(), prediction);
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double MSE = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(valuesAndPreds.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double v = tuple2._1$mcD$sp();
                    double p = tuple2._2$mcD$sp();
                    double d = package$.MODULE$.pow(v - p, 2.0);
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"training Mean Squared Error = ").append((Object)BoxesRunTime.boxToDouble((double)MSE)).toString());
        model.save(sc, "target/tmp/scalaLinearRegressionWithSGDModel");
        LinearRegressionModel sameModel = LinearRegressionModel$.MODULE$.load(sc, "target/tmp/scalaLinearRegressionWithSGDModel");
        sc.stop();
    }

    private LinearRegressionWithSGDExample$() {
        MODULE$ = this;
    }
}

