/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaBucketizerExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaBucketizerExample").getOrCreate();
        double[] splits = new double[]{Double.NEGATIVE_INFINITY, -0.5, 0.0, 0.5, Double.POSITIVE_INFINITY};
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{-0.5}), RowFactory.create((Object[])new Object[]{-0.3}), RowFactory.create((Object[])new Object[]{0.0}), RowFactory.create((Object[])new Object[]{0.2}));
        StructType schema = new StructType(new StructField[]{new StructField("features", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset dataFrame = spark.createDataFrame(data, schema);
        Bucketizer bucketizer = new Bucketizer().setInputCol("features").setOutputCol("bucketedFeatures").setSplits(splits);
        Dataset bucketedData = bucketizer.transform(dataFrame);
        bucketedData.show();
        spark.stop();
    }
}

