/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.spark.examples.SparkHdfsLR;
import org.apache.spark.examples.SparkHdfsLR$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SparkHdfsLR$ {
    public static final SparkHdfsLR$ MODULE$;
    private final int D;
    private final Random rand;

    static {
        new SparkHdfsLR$();
    }

    public int D() {
        return this.D;
    }

    public Random rand() {
        return this.rand;
    }

    public SparkHdfsLR.DataPoint parsePoint(String line) {
        StringTokenizer tok = new StringTokenizer(line, " ");
        double y = new StringOps(Predef$.MODULE$.augmentString(tok.nextToken())).toDouble();
        double[] x = new double[this.D()];
        for (int i = 0; i < this.D(); ++i) {
            x[i] = new StringOps(Predef$.MODULE$.augmentString(tok.nextToken())).toDouble();
        }
        return new SparkHdfsLR.DataPoint((Vector<Object>)new DenseVector.mcD.sp(x), y);
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of Logistic Regression and is given as an example!\n        |Please use org.apache.spark.ml.classification.LogisticRegression\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: SparkHdfsLR <file> <iters>");
            System.exit(1);
        }
        this.showWarning();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SparkHdfsLR").getOrCreate();
        String inputPath = args[0];
        RDD lines = spark.read().textFile(inputPath).rdd();
        RDD points = lines.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparkHdfsLR.DataPoint apply(String line) {
                return SparkHdfsLR$.MODULE$.parsePoint(line);
            }
        }, ClassTag$.MODULE$.apply(SparkHdfsLR.DataPoint.class)).cache();
        int ITERATIONS = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        ObjectRef w = ObjectRef.create((Object)((DenseVector)DenseVector$.MODULE$.fill(this.D(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return (double)2 * SparkHdfsLR$.MODULE$.rand().nextDouble() - 1.0;
            }
        }, ClassTag$.MODULE$.Double())));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Initial w: ").append((Object)((DenseVector)w.elem)).toString());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), ITERATIONS).foreach((Function1)new Serializable(points, w){
            public static final long serialVersionUID = 0L;
            private final RDD points$1;
            public final ObjectRef w$1;

            public final DenseVector<Object> apply(int i) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"On iteration ").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                Vector gradient = (Vector)this.points$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final Vector<Object> apply(SparkHdfsLR.DataPoint p) {
                        return (Vector)((ImmutableNumericOps)p.x().$times((Object)BoxesRunTime.boxToDouble((double)(1.0 / (1.0 + package$.MODULE$.exp(-p.y() * BoxesRunTime.unboxToDouble((Object)((DenseVector)this.$outer.w$1.elem).dot(p.x(), DenseVector$.MODULE$.canDot_DV_V_Double())))) - 1.0)), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())).$times((Object)BoxesRunTime.boxToDouble((double)p.y()), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector<Object> apply(Vector<Object> x$1, Vector<Object> x$2) {
                        return (Vector)x$1.$plus(x$2, (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
                    }
                });
                return (DenseVector)((DenseVector)this.w$1.elem).$minus$eq((Object)gradient, (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpSub());
            }
            {
                this.points$1 = points$1;
                this.w$1 = w$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Final w: ").append((Object)((DenseVector)w.elem)).toString());
        spark.stop();
    }

    private SparkHdfsLR$() {
        MODULE$ = this;
        this.D = 10;
        this.rand = new Random(42L);
    }
}

