/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.StorageLevels;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.examples.streaming.JavaRecord;
import org.apache.spark.examples.streaming.JavaSparkSessionSingleton;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.Durations;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;

public final class JavaSqlNetworkWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaNetworkWordCount <hostname> <port>");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        SparkConf sparkConf = new SparkConf().setAppName("JavaSqlNetworkWordCount");
        JavaStreamingContext ssc = new JavaStreamingContext(sparkConf, Durations.seconds((long)1L));
        JavaReceiverInputDStream lines = ssc.socketTextStream(args[0], Integer.parseInt(args[1]), StorageLevels.MEMORY_AND_DISK_SER);
        JavaDStream words = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterator<String> call(String x) {
                return Arrays.asList(SPACE.split(x)).iterator();
            }
        });
        words.foreachRDD((VoidFunction2)new VoidFunction2<JavaRDD<String>, Time>(){

            public void call(JavaRDD<String> rdd, Time time) {
                SparkSession spark = JavaSparkSessionSingleton.getInstance(rdd.context().getConf());
                JavaRDD rowRDD = rdd.map((Function)new Function<String, JavaRecord>(){

                    public JavaRecord call(String word) {
                        JavaRecord record = new JavaRecord();
                        record.setWord(word);
                        return record;
                    }
                });
                Dataset wordsDataFrame = spark.createDataFrame(rowRDD, JavaRecord.class);
                wordsDataFrame.createOrReplaceTempView("words");
                Dataset wordCountsDataFrame = spark.sql("select word, count(*) as total from words group by word");
                System.out.println("========= " + time + "=========");
                wordCountsDataFrame.show();
            }
        });
        ssc.start();
        ssc.awaitTermination();
    }
}

