/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.LinearRegression;
import org.apache.spark.examples.mllib.LinearRegression$Params$;
import org.apache.spark.examples.mllib.LinearRegression$RegType$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scopt.OptionParser;
import scopt.Read$;

public final class LinearRegression$ {
    public static final LinearRegression$ MODULE$;

    static {
        new LinearRegression$();
    }

    public void main(String[] args) {
        LinearRegression.Params defaultParams = new LinearRegression.Params(LinearRegression$Params$.MODULE$.apply$default$1(), LinearRegression$Params$.MODULE$.apply$default$2(), LinearRegression$Params$.MODULE$.apply$default$3(), LinearRegression$Params$.MODULE$.apply$default$4(), LinearRegression$Params$.MODULE$.apply$default$5());
        OptionParser<LinearRegression.Params> parser = new OptionParser<LinearRegression.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LinearRegression: an example app for linear regression."}));
                this.opt("numIterations", Read$.MODULE$.intRead()).text("number of iterations").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegression.Params apply(int x, LinearRegression.Params c) {
                        int x$5 = x;
                        String x$6 = c.copy$default$1();
                        double x$7 = c.copy$default$3();
                        Enumeration.Value x$8 = c.copy$default$4();
                        double x$9 = c.copy$default$5();
                        return c.copy(x$6, x$5, x$7, x$8, x$9);
                    }
                });
                this.opt("stepSize", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initial step size, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.stepSize())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegression.Params apply(double x, LinearRegression.Params c) {
                        double x$10 = x;
                        String x$11 = c.copy$default$1();
                        int x$12 = c.copy$default$2();
                        Enumeration.Value x$13 = c.copy$default$4();
                        double x$14 = c.copy$default$5();
                        return c.copy(x$11, x$12, x$10, x$13, x$14);
                    }
                });
                this.opt("regType", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regularization type (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LinearRegression$RegType$.MODULE$.values().mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.regType()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegression.Params apply(String x, LinearRegression.Params c) {
                        Enumeration.Value x$15 = LinearRegression$RegType$.MODULE$.withName(x);
                        String x$16 = c.copy$default$1();
                        int x$17 = c.copy$default$2();
                        double x$18 = c.copy$default$3();
                        double x$19 = c.copy$default$5();
                        return c.copy(x$16, x$17, x$18, x$15, x$19);
                    }
                });
                this.opt("regParam", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regularization parameter, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.regParam())})));
                this.arg("<input>", Read$.MODULE$.stringRead()).required().text("input paths to labeled examples in LIBSVM format").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegression.Params apply(String x, LinearRegression.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5());
                    }
                });
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n          |For example, the following command runs this app on a synthetic dataset:\n          |\n          | bin/spark-submit --class org.apache.spark.examples.mllib.LinearRegression \\\n          |  examples/target/scala-*/spark-examples-*.jar \\\n          |  data/mllib/sample_linear_regression_data.txt\n        ")).stripMargin());
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(LinearRegression.Params params) {
                LinearRegression$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.exit(1);
            }
        });
    }

    public void run(LinearRegression.Params params) {
        Enumeration.Value value;
        block5: {
            SimpleUpdater simpleUpdater;
            long numTest;
            RDD test;
            RDD training;
            SparkContext sc;
            block3: {
                block4: {
                    block2: {
                        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LinearRegression with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                        sc = new SparkContext(conf);
                        Logger.getRootLogger().setLevel(Level.WARN);
                        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
                        RDD[] splits = examples.randomSplit(new double[]{0.8, 0.2}, examples.randomSplit$default$2());
                        training = splits[0].cache();
                        test = splits[1].cache();
                        long numTraining = training.count();
                        numTest = test.count();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training: ", ", test: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numTraining), BoxesRunTime.boxToLong((long)numTest)})));
                        examples.unpersist(false);
                        value = params.regType();
                        Enumeration.Value value2 = LinearRegression$RegType$.MODULE$.NONE();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        simpleUpdater = new SimpleUpdater();
                        break block3;
                    }
                    Enumeration.Value value4 = LinearRegression$RegType$.MODULE$.L1();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    simpleUpdater = new L1Updater();
                    break block3;
                }
                Enumeration.Value value6 = LinearRegression$RegType$.MODULE$.L2();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                simpleUpdater = new SquaredL2Updater();
            }
            SimpleUpdater updater = simpleUpdater;
            LinearRegressionWithSGD algorithm = new LinearRegressionWithSGD();
            algorithm.optimizer().setNumIterations(params.numIterations()).setStepSize(params.stepSize()).setUpdater((Updater)updater).setRegParam(params.regParam());
            LinearRegressionModel model = (LinearRegressionModel)algorithm.run(training);
            RDD prediction = model.predict(test.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Vector apply(LabeledPoint x$1) {
                    return x$1.features();
                }
            }, ClassTag$.MODULE$.apply(Vector.class)));
            RDD predictionAndLabel = prediction.zip(test.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(LabeledPoint x$2) {
                    return x$2.label();
                }
            }, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double());
            double loss = BoxesRunTime.unboxToDouble((Object)predictionAndLabel.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        double p = tuple2._1$mcD$sp();
                        double l = tuple2._2$mcD$sp();
                        double err = p - l;
                        double d = err * err;
                        return d;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.Double()).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(double x$3, double x$4) {
                    return this.apply$mcDDD$sp(x$3, x$4);
                }

                public double apply$mcDDD$sp(double x$3, double x$4) {
                    return x$3 + x$4;
                }
            }));
            double rmse2 = package$.MODULE$.sqrt(loss / (double)numTest);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test RMSE = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rmse2)})));
            sc.stop();
            return;
        }
        throw new MatchError((Object)value);
    }

    private LinearRegression$() {
        MODULE$ = this;
    }
}

